/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.base.sfsb.util;

import com.sun.ejb.spi.sfsb.util.SFSBUUIDUtil;
import com.sun.enterprise.util.Utility;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleKeyGenerator
implements SFSBUUIDUtil<SimpleSessionKey> {
    protected long prefix;
    protected long suffix;
    protected int idCounter;

    public SimpleKeyGenerator() {
        long now = System.currentTimeMillis();
        now = (int)(now >>> 32) + (int)now;
        this.scramble((int)now, System.identityHashCode(this));
    }

    public SimpleKeyGenerator(byte[] ipAddress, int port) {
        this.scramble(Utility.bytesToInt((byte[])ipAddress, (int)0), port);
    }

    public SimpleKeyGenerator(long uniquePrefix) {
        this.prefix = uniquePrefix;
        this.suffix = System.currentTimeMillis();
        this.idCounter = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SimpleSessionKey createSessionKey() {
        int id = 0;
        SimpleKeyGenerator simpleKeyGenerator = this;
        synchronized (simpleKeyGenerator) {
            id = this.idCounter++;
            if (id < 0) {
                this.idCounter = 0;
                id = 0;
                this.suffix = System.currentTimeMillis();
            }
        }
        return new SimpleSessionKey(this.prefix, this.suffix, id);
    }

    @Override
    public byte[] keyToByteArray(SimpleSessionKey key) {
        byte[] array = new byte[20];
        Utility.longToBytes((long)key.prefix, (byte[])array, (int)0);
        Utility.longToBytes((long)key.suffix, (byte[])array, (int)8);
        Utility.intToBytes((int)key.id, (byte[])array, (int)16);
        return array;
    }

    @Override
    public SimpleSessionKey byteArrayToKey(byte[] array, int startIndex, int len) {
        long myPrefix = Utility.bytesToLong((byte[])array, (int)startIndex);
        long mySuffix = Utility.bytesToLong((byte[])array, (int)(startIndex + 8));
        int myId = Utility.bytesToInt((byte[])array, (int)(startIndex + 16));
        return new SimpleSessionKey(myPrefix, mySuffix, myId);
    }

    private void scramble(int hi, int lo) {
        byte[] hiBytes = new byte[4];
        Utility.intToBytes((int)hi, (byte[])hiBytes, (int)0);
        byte[] loBytes = new byte[4];
        Utility.intToBytes((int)lo, (byte[])loBytes, (int)0);
        SimpleKeyGenerator.swapBytes(hiBytes, loBytes, 2, 3);
        SimpleKeyGenerator.swapBytes(hiBytes, loBytes, 3, 0);
        SimpleKeyGenerator.swapBytes(hiBytes, loBytes, 1, 3);
        SimpleKeyGenerator.swapBytes(hiBytes, hiBytes, 0, 3);
        SimpleKeyGenerator.swapBytes(loBytes, loBytes, 2, 3);
        this.prefix = Utility.bytesToInt((byte[])hiBytes, (int)0);
        this.prefix = (this.prefix << 32) + (long)Utility.bytesToInt((byte[])loBytes, (int)0);
        this.idCounter = 0;
        this.suffix = (int)System.currentTimeMillis();
    }

    private static final void swapBytes(byte[] a, byte[] b, int index1, int index2) {
        byte temp = a[index1];
        a[index1] = b[index2];
        b[index2] = temp;
    }

    protected static class SimpleSessionKey
    implements Serializable {
        long prefix;
        long suffix;
        int id;

        public SimpleSessionKey(long prefix, long suffix, int id) {
            this.prefix = prefix;
            this.suffix = suffix;
            this.id = id;
        }

        public int hashCode() {
            return this.id;
        }

        public boolean equals(Object otherObj) {
            if (otherObj instanceof SimpleSessionKey) {
                SimpleSessionKey other = (SimpleSessionKey)otherObj;
                return this.id == other.id && this.prefix == other.prefix && this.suffix == other.suffix;
            }
            return false;
        }

        public String toString() {
            StringBuffer sbuf = new StringBuffer();
            sbuf.append(Long.toHexString(this.prefix)).append("-").append(Long.toHexString(this.suffix)).append("-").append(Integer.toHexString(this.id));
            return sbuf.toString();
        }
    }
}

