/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.embedded;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.ejb.containers.EjbContainerUtilImpl;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.logging.LogDomains;
import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJBException;
import javax.ejb.embeddable.EJBContainer;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.glassfish.ejb.embedded.DeploymentElement;
import org.glassfish.embeddable.Deployer;
import org.glassfish.embeddable.GlassFish;
import org.glassfish.embeddable.GlassFishException;
import org.glassfish.embeddable.archive.ScatteredArchive;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJBContainerImpl
extends EJBContainer {
    private static final Logger _logger = LogDomains.getLogger(EjbContainerUtilImpl.class, (String)"javax.enterprise.system.container.ejb");
    private final GlassFish server;
    private final Deployer deployer;
    private String deployedAppName;
    private Habitat habitat;
    private volatile int state = 0;
    private Cleanup cleanup = null;
    private DeploymentElement.ResultApplication res_app;
    private static final int STARTING = 0;
    private static final int RUNNING = 1;
    private static final int CLOSING = 2;
    private static final int CLOSED = 3;

    EJBContainerImpl(GlassFish server) throws GlassFishException {
        this.server = server;
        this.server.start();
        this.habitat = (Habitat)server.getService(Habitat.class);
        this.deployer = server.getDeployer();
        this.state = 1;
        this.cleanup = new Cleanup(this);
    }

    void deploy(Map<?, ?> properties, Set<DeploymentElement> modules) throws EJBException {
        try {
            String appName = properties == null ? null : (String)properties.get("javax.ejb.embeddable.appName");
            this.res_app = DeploymentElement.getOrCreateApplication(modules, appName);
            Object app = this.res_app.getApplication();
            if (app == null) {
                throw new EJBException("Invalid set of modules to deploy - see log for details");
            }
            if (_logger.isLoggable(Level.INFO)) {
                _logger.info("[EJBContainerImpl] Deploying app: " + app);
            }
            String[] params = appName != null ? new String[]{"--name", appName} : new String[]{};
            this.deployedAppName = app instanceof ScatteredArchive ? this.deployer.deploy(((ScatteredArchive)app).toURI(), params) : this.deployer.deploy((File)app, params);
        }
        catch (Exception e) {
            throw new EJBException("Failed to deploy EJB modules", e);
        }
        if (this.deployedAppName == null) {
            throw new EJBException("Failed to deploy EJB modules - see log for details");
        }
    }

    public Context getContext() {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("IN getContext()");
        }
        try {
            return new InitialContext();
        }
        catch (Exception e) {
            throw new EJBException(_logger.getResourceBundle().getString("ejb.embedded.cannot_create_context"), e);
        }
    }

    public void close() {
        if (this.cleanup != null) {
            this.cleanup.disable();
        }
        if (this.isOpen()) {
            this.forceClose();
        }
    }

    void forceClose() {
        this.state = 2;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("IN close()");
        }
        this.cleanupTransactions();
        this.cleanupConnectorRuntime();
        this.undeploy();
        if (this.res_app != null && this.res_app.deleteOnExit()) {
            try {
                FileUtils.whack((File)((File)this.res_app.getApplication()));
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Error in removing temp file", e);
            }
        }
        this.stop();
    }

    boolean isOpen() {
        return this.state == 1;
    }

    private void cleanupTransactions() {
        try {
            Inhabitant inhabitant = this.habitat.getInhabitantByType(TransactionManager.class);
            if (inhabitant != null && inhabitant.isInstantiated()) {
                TransactionManager txmgr = (TransactionManager)inhabitant.get();
                txmgr.rollback();
            }
        }
        catch (Throwable t) {
            _logger.log(Level.SEVERE, "Error in cleanupTransactions", t);
        }
    }

    private void cleanupConnectorRuntime() {
        try {
            Inhabitant inhabitant = this.habitat.getInhabitantByType(ConnectorRuntime.class);
            if (inhabitant != null && inhabitant.isInstantiated()) {
                ConnectorRuntime connectorRuntime = (ConnectorRuntime)inhabitant.get();
                connectorRuntime.cleanUpResourcesAndShutdownAllActiveRAs();
            }
        }
        catch (Throwable t) {
            _logger.log(Level.SEVERE, "Error in cleanupConnectorRuntime", t);
        }
    }

    private void undeploy() {
        if (this.deployedAppName != null) {
            try {
                this.deployer.undeploy(this.deployedAppName, new String[0]);
            }
            catch (Exception e) {
                _logger.warning("Cannot undeploy deployed modules: " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void stop() {
        block10: {
            if (this.state == 3) {
                return;
            }
            this.server.stop();
            Object var3_1 = null;
            try {
                this.server.dispose();
            }
            catch (GlassFishException e2) {
                _logger.log(Level.WARNING, "Cannot dispose embedded server", e2);
            }
            this.state = 3;
            {
                break block10;
                catch (GlassFishException e) {
                    _logger.log(Level.WARNING, "Cannot stop embedded server", e);
                    Object var3_2 = null;
                    try {
                        this.server.dispose();
                    }
                    catch (GlassFishException e2) {
                        _logger.log(Level.WARNING, "Cannot dispose embedded server", e2);
                    }
                    this.state = 3;
                }
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                try {
                    this.server.dispose();
                }
                catch (GlassFishException e2) {
                    _logger.log(Level.WARNING, "Cannot dispose embedded server", e2);
                }
                this.state = 3;
                throw throwable;
            }
        }
    }

    private static class Cleanup
    implements Runnable {
        private Thread cleanupThread = null;
        private EJBContainerImpl container = null;

        Cleanup(EJBContainerImpl container) {
            this.container = container;
            this.cleanupThread = new Thread((Runnable)this, "EJBContainerImplCleanup");
            Runtime.getRuntime().addShutdownHook(this.cleanupThread);
        }

        void disable() {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Runtime.getRuntime().removeShutdownHook(Cleanup.this.cleanupThread);
                    return null;
                }
            });
        }

        public void run() {
            if (this.container.isOpen()) {
                this.container.forceClose();
            }
        }
    }
}

