/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.iiop.security;

import com.sun.corba.ee.impl.encoding.CDROutputStream;
import com.sun.corba.ee.impl.encoding.EncapsInputStream;
import com.sun.corba.ee.org.omg.CSIIOP.AS_ContextSec;
import com.sun.corba.ee.org.omg.CSIIOP.CompoundSecMech;
import com.sun.corba.ee.org.omg.CSIIOP.CompoundSecMechList;
import com.sun.corba.ee.org.omg.CSIIOP.CompoundSecMechListHelper;
import com.sun.corba.ee.org.omg.CSIIOP.SAS_ContextSec;
import com.sun.corba.ee.org.omg.CSIIOP.ServiceConfiguration;
import com.sun.corba.ee.org.omg.CSIIOP.TLS_SEC_TRANS;
import com.sun.corba.ee.org.omg.CSIIOP.TLS_SEC_TRANSHelper;
import com.sun.corba.ee.org.omg.CSIIOP.TransportAddress;
import com.sun.corba.ee.spi.folb.SocketInfo;
import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.ior.TaggedComponent;
import com.sun.corba.ee.spi.ior.iiop.IIOPProfile;
import com.sun.corba.ee.spi.ior.iiop.IIOPProfileTemplate;
import com.sun.corba.ee.spi.orbutil.generic.UnaryFunction;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbIORConfigurationDescriptor;
import com.sun.enterprise.iiop.security.GSSUtils;
import com.sun.enterprise.security.SecurityServicesUtil;
import com.sun.enterprise.util.Utility;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.enterprise.iiop.api.GlassFishORBHelper;
import org.glassfish.enterprise.iiop.impl.CSIv2Policy;
import org.omg.CORBA.INV_POLICY;
import org.omg.CORBA.ORB;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.PortableInterceptor.IORInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CSIV2TaggedComponentInfo {
    public static final int SUPPORTED_IDENTITY_TOKEN_TYPES = 15;
    private static final String DEFAULT_REALM = "default";
    private static final Logger _logger;
    private static final org.omg.IOP.TaggedComponent NULL_TAGGED_COMPONENT;
    private String _realm_name = null;
    private byte[] _realm_name_bytes = null;
    private ORB orb;
    private int sslMutualAuthPort;
    private GlassFishORBHelper orbHelper;

    public CSIV2TaggedComponentInfo(ORB orb) {
        this.orb = orb;
        this.orbHelper = (GlassFishORBHelper)SecurityServicesUtil.getInstance().getHabitat().getComponent(GlassFishORBHelper.class);
    }

    public CSIV2TaggedComponentInfo(ORB orb, int sslMutualAuthPort) {
        this(orb);
        this.sslMutualAuthPort = sslMutualAuthPort;
        this.orbHelper = (GlassFishORBHelper)SecurityServicesUtil.getInstance().getHabitat().getComponent(GlassFishORBHelper.class);
    }

    public EjbDescriptor getEjbDescriptor(IORInfo iorInfo) {
        CSIv2Policy csiv2Policy = null;
        try {
            csiv2Policy = (CSIv2Policy)iorInfo.get_effective_policy(this.orbHelper.getCSIv2PolicyType());
        }
        catch (INV_POLICY ex) {
            _logger.log(Level.FINE, "CSIV2TaggedComponentInfo.getEjbDescriptor: CSIv2Policy not present");
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "TxSecIORInterceptor.establish_components: CSIv2Policy: " + csiv2Policy);
        }
        EjbDescriptor ejbDesc = null;
        if (csiv2Policy != null) {
            ejbDesc = csiv2Policy.getEjbDescriptor();
        }
        return ejbDesc;
    }

    public org.omg.IOP.TaggedComponent createSecurityTaggedComponent(int sslPort, EjbDescriptor desc) {
        org.omg.IOP.TaggedComponent tc = null;
        try {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "IIOP: Creating a Security Tagged Component");
            }
            this._realm_name = desc.getApplication().getRealm();
            CompoundSecMech[] mechList = this.createCompoundSecMechs(sslPort, desc);
            tc = this.createCompoundSecMechListComponent(mechList);
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "iiop.createcompund_exception", e);
        }
        return tc;
    }

    public org.omg.IOP.TaggedComponent createSecurityTaggedComponent(List<SocketInfo> socketInfos, EjbDescriptor desc) {
        org.omg.IOP.TaggedComponent tc = null;
        try {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "IIOP: Creating a Security Tagged Component");
            }
            this._realm_name = desc.getApplication().getRealm();
            CompoundSecMech[] mechList = this.createCompoundSecMechs(socketInfos, desc);
            tc = this.createCompoundSecMechListComponent(mechList);
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "iiop.createcompund_exception", e);
        }
        return tc;
    }

    private boolean getBooleanValue(Properties props, String name) {
        String val = props.getProperty(name, "false");
        boolean result = val.equals("true");
        return result;
    }

    public org.omg.IOP.TaggedComponent createSecurityTaggedComponent(int sslPort) {
        org.omg.IOP.TaggedComponent tc = null;
        try {
            Properties props = this.orbHelper.getCSIv2Props();
            boolean sslRequired = this.getBooleanValue(props, "com.sun.CSIV2.ssl.server.required");
            boolean clientAuthRequired = this.getBooleanValue(props, "com.sun.CSIV2.client.auth.required");
            CompoundSecMech[] mechList = new CompoundSecMech[1];
            org.omg.IOP.TaggedComponent transportMech = this.createSSLInfo(sslPort, null, sslRequired);
            AS_ContextSec asContext = this.createASContextSec(null);
            SAS_ContextSec sasContext = this.createSASContextSec(null);
            short targetRequires = clientAuthRequired ? (short)64 : 0;
            mechList[0] = new CompoundSecMech(targetRequires, transportMech, asContext, sasContext);
            tc = this.createCompoundSecMechListComponent(mechList);
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "iiop.createcompund_exception", e);
        }
        return tc;
    }

    private org.omg.IOP.TaggedComponent createCompoundSecMechListComponent(CompoundSecMech[] mechList) {
        CDROutputStream out = (CDROutputStream)this.orb.create_output_stream();
        out.putEndian();
        boolean stateful = false;
        CompoundSecMechList list = new CompoundSecMechList(stateful, mechList);
        CompoundSecMechListHelper.write((OutputStream)out, (CompoundSecMechList)list);
        byte[] buf = out.toByteArray();
        org.omg.IOP.TaggedComponent tc = new org.omg.IOP.TaggedComponent(33, buf);
        return tc;
    }

    private Set<EjbIORConfigurationDescriptor> getIORConfigurationDescriptors(EjbDescriptor desc) {
        Set iorDescSet = desc.getIORConfigurationDescriptors();
        int size = iorDescSet.size();
        if (size == 0) {
            EjbIORConfigurationDescriptor eDesc = new EjbIORConfigurationDescriptor();
            eDesc.setIntegrity("SUPPORTED");
            eDesc.setConfidentiality("SUPPORTED");
            eDesc.setEstablishTrustInClient("SUPPORTED");
            iorDescSet.add(eDesc);
            size = 1;
            Set permissions = desc.getPermissionedRoles();
            if (permissions.size() > 0) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "IIOP:Application has protected methods");
                }
                eDesc.setAuthMethodRequired(true);
                if (this._realm_name != null) {
                    eDesc.setRealmName(this._realm_name);
                }
            }
        }
        return iorDescSet;
    }

    private CompoundSecMech[] createCompoundSecMechs(DescriptorMaker maker, EjbDescriptor desc) throws IOException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "IIOP: Creating CompoundSecMech");
        }
        Set<EjbIORConfigurationDescriptor> iorDescSet = this.getIORConfigurationDescriptors(desc);
        CompoundSecMech[] mechList = new CompoundSecMech[iorDescSet.size()];
        Iterator<EjbIORConfigurationDescriptor> itr = iorDescSet.iterator();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "IORDescSet SIZE:" + iorDescSet.size());
        }
        for (int i = 0; i < iorDescSet.size(); ++i) {
            EjbIORConfigurationDescriptor iorDesc = itr.next();
            int target_requires = this.getTargetRequires(iorDesc);
            org.omg.IOP.TaggedComponent comp = (org.omg.IOP.TaggedComponent)maker.evaluate(iorDesc);
            AS_ContextSec asContext = this.createASContextSec(iorDesc);
            SAS_ContextSec sasContext = this.createSASContextSec(iorDesc);
            int targ_req = target_requires | asContext.target_requires | sasContext.target_requires;
            mechList[i] = new CompoundSecMech((short)targ_req, comp, asContext, sasContext);
        }
        return mechList;
    }

    private CompoundSecMech[] createCompoundSecMechs(final List<SocketInfo> socketInfos, EjbDescriptor desc) throws IOException {
        DescriptorMaker maker = new DescriptorMaker(){

            public org.omg.IOP.TaggedComponent evaluate(EjbIORConfigurationDescriptor desc) {
                return CSIV2TaggedComponentInfo.this.createSSLInfo(socketInfos, desc, false);
            }
        };
        return this.createCompoundSecMechs(maker, desc);
    }

    private CompoundSecMech[] createCompoundSecMechs(final int sslPort, EjbDescriptor desc) throws IOException {
        DescriptorMaker maker = new DescriptorMaker(){

            public org.omg.IOP.TaggedComponent evaluate(EjbIORConfigurationDescriptor desc) {
                return CSIV2TaggedComponentInfo.this.createSSLInfo(sslPort, desc, false);
            }
        };
        return this.createCompoundSecMechs(maker, desc);
    }

    public AS_ContextSec createASContextSec(EjbIORConfigurationDescriptor iorDesc) throws IOException {
        AS_ContextSec asContext = null;
        int target_supports = 0;
        int target_requires = 0;
        byte[] client_authentication_mechanism = new byte[]{};
        byte[] target_name = new byte[]{};
        String authMethod = null;
        boolean authMethodRequired = false;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "IIOP: Creating AS_Context");
        }
        if (iorDesc != null) {
            authMethod = iorDesc.getAuthenticationMethod();
            authMethodRequired = iorDesc.isAuthMethodRequired();
        }
        if (authMethod != null && authMethod.equalsIgnoreCase("NONE")) {
            asContext = new AS_ContextSec((short)target_supports, (short)target_requires, client_authentication_mechanism, target_name);
            return asContext;
        }
        if (this._realm_name == null) {
            if (iorDesc != null) {
                this._realm_name = iorDesc.getRealmName();
            }
            if (this._realm_name == null) {
                this._realm_name = DEFAULT_REALM;
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "IIOP:AS_Context: Realm Name = null, setting default realm for logging in");
                }
            }
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "IIOP:AS_Context: Realm Name for login = " + this._realm_name);
        }
        this._realm_name_bytes = this._realm_name.getBytes();
        target_name = GSSUtils.createExportedName(GSSUtils.GSSUP_MECH_OID, this._realm_name_bytes);
        target_supports = 64;
        if (authMethodRequired) {
            target_requires = 64;
        }
        client_authentication_mechanism = GSSUtils.getMechanism();
        asContext = new AS_ContextSec((short)target_supports, (short)target_requires, client_authentication_mechanism, target_name);
        return asContext;
    }

    public SAS_ContextSec createSASContextSec(EjbIORConfigurationDescriptor iorDesc) throws IOException {
        SAS_ContextSec sasContext = null;
        int target_supports = 0;
        boolean target_requires = false;
        ServiceConfiguration[] priv = new ServiceConfiguration[]{};
        String callerPropagation = null;
        Object mechanisms = new byte[][]{};
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "IIOP: Creating SAS_Context");
        }
        int supported_identity_token_type = 0;
        if (iorDesc != null) {
            callerPropagation = iorDesc.getCallerPropagation();
        }
        if (callerPropagation != null && callerPropagation.equalsIgnoreCase("NONE")) {
            sasContext = new SAS_ContextSec((short)target_supports, (short)(target_requires ? 1 : 0), priv, (byte[][])mechanisms, supported_identity_token_type);
            return sasContext;
        }
        target_supports = 1024;
        byte[] upm = GSSUtils.getMechanism();
        mechanisms = new byte[1][upm.length];
        for (int i = 0; i < upm.length; ++i) {
            mechanisms[0][i] = upm[i];
        }
        if (target_supports != 0) {
            supported_identity_token_type = 15;
        }
        sasContext = new SAS_ContextSec((short)target_supports, (short)(target_requires ? 1 : 0), priv, (byte[][])mechanisms, supported_identity_token_type);
        return sasContext;
    }

    public int getTargetSupports(EjbIORConfigurationDescriptor iorDesc) {
        String establishTrustInClient;
        String establishTrustInTarget;
        String confidentiality;
        if (iorDesc == null) {
            return 0;
        }
        int supports = 0;
        String integrity = iorDesc.getIntegrity();
        if (!integrity.equalsIgnoreCase("NONE")) {
            supports |= 2;
        }
        if (!(confidentiality = iorDesc.getConfidentiality()).equalsIgnoreCase("NONE")) {
            supports |= 4;
        }
        if (!(establishTrustInTarget = iorDesc.getEstablishTrustInTarget()).equalsIgnoreCase("NONE")) {
            supports |= 0x20;
        }
        if (!(establishTrustInClient = iorDesc.getEstablishTrustInClient()).equalsIgnoreCase("NONE")) {
            supports |= 0x40;
        }
        return supports;
    }

    public int getTargetRequires(EjbIORConfigurationDescriptor iorDesc) {
        String establishTrustInClient;
        String establishTrustInTarget;
        String confidentiality;
        if (iorDesc == null) {
            return 0;
        }
        int requires = 0;
        String integrity = iorDesc.getIntegrity();
        if (integrity.equalsIgnoreCase("REQUIRED")) {
            requires |= 2;
        }
        if ((confidentiality = iorDesc.getConfidentiality()).equalsIgnoreCase("REQUIRED")) {
            requires |= 4;
        }
        if ((establishTrustInTarget = iorDesc.getEstablishTrustInTarget()).equalsIgnoreCase("REQUIRED")) {
            requires |= 0x20;
        }
        if ((establishTrustInClient = iorDesc.getEstablishTrustInClient()).equalsIgnoreCase("REQUIRED")) {
            requires |= 0x40;
        }
        return requires;
    }

    private int getTargetSupportsDefault(EjbIORConfigurationDescriptor desc) {
        int targetSupports = 0;
        targetSupports = desc == null ? 102 : this.getTargetSupports(desc);
        return targetSupports;
    }

    private int getTargetRequiresDefault(EjbIORConfigurationDescriptor desc, boolean sslRequired) {
        int targetRequires = 0;
        if (desc == null) {
            if (sslRequired) {
                targetRequires = 70;
            }
        } else {
            targetRequires = this.getTargetRequires(desc);
        }
        return targetRequires;
    }

    private org.omg.IOP.TaggedComponent createTlsSecTransComponent(int targetSupports, int targetRequires, TransportAddress[] listTa) {
        TLS_SEC_TRANS tls_sec = new TLS_SEC_TRANS((short)targetSupports, (short)targetRequires, listTa);
        CDROutputStream out = (CDROutputStream)this.orb.create_output_stream();
        out.putEndian();
        TLS_SEC_TRANSHelper.write((OutputStream)out, (TLS_SEC_TRANS)tls_sec);
        byte[] buf = out.toByteArray();
        org.omg.IOP.TaggedComponent tc = new org.omg.IOP.TaggedComponent(36, buf);
        return tc;
    }

    private TransportAddress[] generateTransportAddresses(int sslPort) {
        String hostName = Utility.getLocalAddress();
        short shortPort = Utility.intToShort((int)sslPort);
        TransportAddress ta = new TransportAddress(hostName, shortPort);
        TransportAddress[] listTa = new TransportAddress[]{ta};
        return listTa;
    }

    private TransportAddress[] generateTransportAddresses(List<SocketInfo> socketInfos) {
        TransportAddress[] listTa = new TransportAddress[socketInfos.size()];
        for (int i = 0; i < socketInfos.size(); ++i) {
            TransportAddress ta;
            SocketInfo socketInfo = socketInfos.get(i);
            int sslport = socketInfo.port;
            String host = socketInfo.host;
            short short_port = Utility.intToShort((int)sslport);
            listTa[i] = ta = new TransportAddress(host, short_port);
        }
        return listTa;
    }

    private org.omg.IOP.TaggedComponent createSSLInfo(int sslport, EjbIORConfigurationDescriptor iorDesc, boolean sslRequired) {
        int ssl_port;
        int targetSupports = this.getTargetSupportsDefault(iorDesc);
        int targetRequires = this.getTargetRequiresDefault(iorDesc, sslRequired);
        boolean mutualAuthRequired = iorDesc != null && (targetRequires & 0x40) == 64;
        int n = ssl_port = mutualAuthRequired ? this.sslMutualAuthPort : sslport;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "IIOP: Creating Transport Mechanism for sslport " + ssl_port);
        }
        if ((targetSupports | targetRequires) == 0 || ssl_port == -1) {
            return NULL_TAGGED_COMPONENT;
        }
        TransportAddress[] listTa = this.generateTransportAddresses(ssl_port);
        return this.createTlsSecTransComponent(targetSupports, targetRequires, listTa);
    }

    private org.omg.IOP.TaggedComponent createSSLInfo(List<SocketInfo> socketInfos, EjbIORConfigurationDescriptor iorDesc, boolean sslRequired) {
        int targetSupports = this.getTargetSupportsDefault(iorDesc);
        int targetRequires = this.getTargetRequiresDefault(iorDesc, sslRequired);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "IIOP: Creating Transport Mechanism for socketInfos " + socketInfos);
        }
        if ((targetSupports | targetRequires) == 0) {
            return NULL_TAGGED_COMPONENT;
        }
        TransportAddress[] listTa = this.generateTransportAddresses(socketInfos);
        return this.createTlsSecTransComponent(targetSupports, targetRequires, listTa);
    }

    public boolean allMechanismsRequireSSL(Set iorDescSet) {
        int size = iorDescSet.size();
        if (size == 0) {
            return false;
        }
        Iterator itr = iorDescSet.iterator();
        for (int i = 0; i < size; ++i) {
            EjbIORConfigurationDescriptor iorDesc = (EjbIORConfigurationDescriptor)itr.next();
            int target_requires = this.getTargetRequires(iorDesc);
            if (target_requires != 0) continue;
            return false;
        }
        return true;
    }

    public CompoundSecMech[] getSecurityMechanisms(IOR ior) {
        IIOPProfile prof = ior.getProfile();
        IIOPProfileTemplate ptemp = (IIOPProfileTemplate)prof.getTaggedProfileTemplate();
        Iterator itr = ptemp.iteratorById(33);
        if (!itr.hasNext()) {
            if (_logger.isLoggable(Level.FINE)) {
                String msg = "IIOP:TAG_CSI_SEC_MECH_LIST tagged component not found";
                _logger.log(Level.FINE, msg);
            }
            return null;
        }
        TaggedComponent tcomp = (TaggedComponent)itr.next();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Component:" + tcomp);
        }
        if (itr.hasNext()) {
            String msg = "More than one TAG_CSI_SEC_MECH_LIST tagged component found ";
            _logger.log(Level.SEVERE, "iiop.many_tagged_component");
            throw new RuntimeException(msg);
        }
        org.omg.IOP.TaggedComponent comp = tcomp.getIOPComponent(this.orb);
        byte[] b = comp.component_data;
        EncapsInputStream in = new EncapsInputStream(this.orb, b, b.length);
        in.consumeEndian();
        CompoundSecMechList l = CompoundSecMechListHelper.read((InputStream)in);
        CompoundSecMech[] list = l.mechanism_list;
        return list;
    }

    public TLS_SEC_TRANS getSSLInformation(CompoundSecMech mech) {
        org.omg.IOP.TaggedComponent pcomp = mech.transport_mech;
        TLS_SEC_TRANS ssl = this.getSSLComponent(pcomp);
        return ssl;
    }

    private TLS_SEC_TRANS getSSLComponent(org.omg.IOP.TaggedComponent comp) {
        TLS_SEC_TRANS ssl = null;
        if (comp.tag == 34) {
            ssl = null;
        } else {
            byte[] b = comp.component_data;
            EncapsInputStream in = new EncapsInputStream(this.orb, b, b.length);
            in.consumeEndian();
            ssl = TLS_SEC_TRANSHelper.read((InputStream)in);
        }
        return ssl;
    }

    static {
        byte[] b = new byte[]{};
        NULL_TAGGED_COMPONENT = new org.omg.IOP.TaggedComponent(34, b);
        _logger = LogDomains.getLogger(CSIV2TaggedComponentInfo.class, (String)"javax.enterprise.system.core.security");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface DescriptorMaker
    extends UnaryFunction<EjbIORConfigurationDescriptor, org.omg.IOP.TaggedComponent> {
    }
}

