/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.iiop.security;

import com.sun.corba.ee.org.omg.CSIIOP.CompoundSecMech;
import com.sun.corba.ee.org.omg.GSSUP.InitialContextToken;
import com.sun.corba.ee.org.omg.GSSUP.InitialContextTokenHelper;
import com.sun.enterprise.iiop.security.ConnectionContext;
import com.sun.enterprise.iiop.security.GSSUtils;
import com.sun.enterprise.iiop.security.SecurityMechanismException;
import com.sun.enterprise.iiop.security.SecurityMechanismSelector;
import com.sun.enterprise.security.auth.login.common.PasswordCredential;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.component.Habitat;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.IOP.Codec;

public class GSSUPToken {
    private static Logger _logger = null;
    public static final String DELIMITER_REGEXP = "\\@";
    public static final String ESCAPE_CHAR_REGEXP = "\\\\\\@";
    public static final String ESCAPE_CHAR = "\\";
    public static final String DELIMITER = "@";
    public static final String DEFAULT_REALM_NAME = "default";
    private byte[] cdr_encoded_token = new byte[0];
    PasswordCredential pwdcred = null;

    public static GSSUPToken getClientSideInstance(ORB orb, Codec codec, PasswordCredential pwdcred, Habitat habitat) {
        return new GSSUPToken(orb, codec, pwdcred, habitat);
    }

    public static GSSUPToken getServerSideInstance(ORB orb, Codec codec, byte[] authtok) throws SecurityMechanismException {
        return new GSSUPToken(orb, codec, authtok);
    }

    private GSSUPToken(ORB orb, Codec codec, PasswordCredential pwdcred, Habitat habitat) {
        byte[] name_utf8 = new byte[]{};
        byte[] password_utf8 = new byte[]{};
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "IIOP: Going to construct a GSSUPToken:");
            _logger.log(Level.FINE, pwdcred.toString());
        }
        try {
            String realm;
            String _name_ = new String(pwdcred.getUser());
            int index = _name_.indexOf(DELIMITER);
            if (index != -1) {
                int escaped_index = _name_.indexOf(ESCAPE_CHAR);
                if (escaped_index == -1) {
                    _name_ = _name_.replaceAll(DELIMITER_REGEXP, ESCAPE_CHAR_REGEXP);
                } else {
                    _name_ = _name_.replaceAll(ESCAPE_CHAR_REGEXP, DELIMITER_REGEXP);
                    _name_ = _name_.replaceAll(DELIMITER_REGEXP, ESCAPE_CHAR_REGEXP);
                }
            }
            if ((realm = pwdcred.getRealm()) != null) {
                _name_ = _name_ + DELIMITER + realm;
            }
            name_utf8 = _name_.toString().getBytes("UTF8");
            password_utf8 = pwdcred.getPassword().getBytes("UTF8");
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "iiop.password_exception", e);
        }
        SecurityMechanismSelector sms = (SecurityMechanismSelector)habitat.getComponent(SecurityMechanismSelector.class);
        ConnectionContext cc = sms.getClientConnectionContext();
        CompoundSecMech mech = cc.getMechanism();
        byte[] target_name = mech.as_context_mech.target_name;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Username (UTF8) " + GSSUtils.dumpHex(name_utf8));
            _logger.fine("Password (UTF8) " + GSSUtils.dumpHex(password_utf8));
            _logger.fine("Targetname      " + GSSUtils.dumpHex(target_name));
        }
        InitialContextToken inctxToken = new InitialContextToken(name_utf8, password_utf8, target_name);
        Any a = orb.create_any();
        InitialContextTokenHelper.insert((Any)a, (InitialContextToken)inctxToken);
        try {
            this.cdr_encoded_token = codec.encode_value(a);
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "iiop.encode_exception", e);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "IIOP:Mech specific token length (CDR encoded) = " + this.cdr_encoded_token.length);
        }
    }

    private GSSUPToken(ORB orb, Codec codec, byte[] authtok) throws SecurityMechanismException {
        String name;
        byte[] name_utf8 = new byte[]{};
        byte[] password_utf8 = new byte[]{};
        byte[] target_name = new byte[]{};
        String username = "";
        String userpwd = "";
        String realm = "";
        byte[] encoded_token = new byte[]{};
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "IIOP:Going to construct a GSSUPToken:");
            _logger.log(Level.FINE, "IIOP:Getting CDR encoded GSSUP mechanism token from client authentication token");
        }
        encoded_token = GSSUtils.getMechToken(GSSUtils.GSSUP_MECH_OID, authtok);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "CDR encoded mech specific token length = " + encoded_token.length);
        }
        Any a = orb.create_any();
        try {
            a = codec.decode_value(encoded_token, InitialContextTokenHelper.type());
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "iiop.decode_exception", e);
        }
        InitialContextToken inctxToken = InitialContextTokenHelper.extract((Any)a);
        password_utf8 = inctxToken.password;
        name_utf8 = inctxToken.username;
        target_name = inctxToken.target_name;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("IIOP:Username (UTF8) " + GSSUtils.dumpHex(name_utf8));
            _logger.fine("IIOP:Password (UTF8) " + GSSUtils.dumpHex(password_utf8));
            _logger.fine("IIOP:Targetname      " + GSSUtils.dumpHex(target_name));
        }
        try {
            username = new String(name_utf8, "UTF8");
            userpwd = new String(password_utf8, "UTF8");
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "iiop.user_password_exception", e);
        }
        int index = username.indexOf(DELIMITER);
        int esc_index = username.indexOf(ESCAPE_CHAR);
        if (index == -1) {
            name = username;
        } else {
            if (index == 0 || esc_index == 0) {
                throw new SecurityMechanismException("No name_value in username");
            }
            if (esc_index != -1) {
                if (esc_index + 2 >= username.length()) {
                    name = username.replaceAll(ESCAPE_CHAR_REGEXP, DELIMITER);
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "IIOP:No Realm specified,  creating a default realm for login");
                    }
                    realm = DEFAULT_REALM_NAME;
                } else {
                    int second_at_index = username.indexOf(DELIMITER, esc_index + 3);
                    if (second_at_index == -1) {
                        name = username.replaceAll(ESCAPE_CHAR_REGEXP, DELIMITER);
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.log(Level.FINE, "IIOP:No Realm specified,  creating a default realm for login");
                        }
                        realm = DEFAULT_REALM_NAME;
                    } else {
                        name = username.substring(0, second_at_index);
                        name = name.replaceAll(ESCAPE_CHAR_REGEXP, DELIMITER);
                        realm = username.substring(second_at_index + 1);
                        if (realm == null) {
                            if (_logger.isLoggable(Level.FINE)) {
                                _logger.log(Level.FINE, "IIOP:No Realm specified,  creating a default realm for login");
                            }
                            realm = DEFAULT_REALM_NAME;
                        }
                    }
                }
            } else {
                StringTokenizer strtok = new StringTokenizer(username, DELIMITER);
                name = strtok.nextToken();
                if (strtok.hasMoreTokens() && (realm = strtok.nextToken()) == null) {
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "IIOP:No Realm specified,  creating a default realm for login");
                    }
                    realm = DEFAULT_REALM_NAME;
                }
            }
        }
        this.pwdcred = new PasswordCredential(name, userpwd, realm, target_name);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, this.pwdcred.toString());
        }
    }

    byte[] getGSSToken() throws IOException {
        if (_logger.isLoggable(Level.FINER)) {
            _logger.log(Level.FINER, "IIOP:GSSUP mech token : " + GSSUtils.dumpHex(this.cdr_encoded_token));
        }
        byte[] gsstoken = GSSUtils.createMechIndToken(GSSUtils.GSSUP_MECH_OID, this.cdr_encoded_token);
        if (_logger.isLoggable(Level.FINER)) {
            _logger.log(Level.FINER, "IIOP:GSSUP token length : " + gsstoken.length);
            _logger.log(Level.FINER, "IIOP:GSSUP token: " + GSSUtils.dumpHex(gsstoken));
        }
        return gsstoken;
    }

    PasswordCredential getPwdcred() {
        return this.pwdcred;
    }

    static {
        _logger = LogDomains.getLogger(GSSUPToken.class, (String)"javax.enterprise.system.core.security");
    }
}

