/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.enterprise.api.enabler;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.glassfish.api.Startup;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;

@Service
public class ORBConnectorStartup
implements Startup,
PostConstruct {
    private static final String ORB_UTIL_CLASS_PROPERTY = "javax.rmi.CORBA.UtilClass";
    private static final String RMIIIOP_STUB_DELEGATE_CLASS_PROPERTY = "javax.rmi.CORBA.StubClass";
    private static final String RMIIIOP_PRO_DELEGATE_CLASS_PROPERTY = "javax.rmi.CORBA.PortableRemoteObjectClass";
    private static final String OMG_ORB_CLASS_PROPERTY = "org.omg.CORBA.ORBClass";
    private static final String OMG_ORB_SINGLETON_CLASS_PROPERTY = "org.omg.CORBA.ORBSingletonClass";
    private static final String ORB_CLASS = "com.sun.corba.ee.impl.orb.ORBImpl";
    private static final String ORB_SINGLETON_CLASS = "com.sun.corba.ee.impl.orb.ORBSingleton";
    private static final String ORB_SE_CLASS = "com.sun.corba.se.impl.orb.ORBImpl";
    private static final String ORB_SE_SINGLETON_CLASS = "com.sun.corba.se.impl.orb.ORBSingleton";
    private static final String RMI_UTIL_CLASS = "com.sun.corba.ee.impl.javax.rmi.CORBA.Util";
    private static final String RMI_STUB_CLASS = "com.sun.corba.ee.impl.javax.rmi.CORBA.StubDelegateImpl";
    private static final String RMI_PRO_CLASS = "com.sun.corba.ee.impl.javax.rmi.PortableRemoteObject";

    public void postConstruct() {
        this.setORBSystemProperties();
    }

    public Startup.Lifecycle getLifecycle() {
        return Startup.Lifecycle.START;
    }

    private void setORBSystemProperties() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (System.getProperty(ORBConnectorStartup.OMG_ORB_CLASS_PROPERTY) == null) {
                    if (System.getProperty("java.vendor").equals("Sun Microsystems Inc.")) {
                        System.setProperty(ORBConnectorStartup.OMG_ORB_CLASS_PROPERTY, ORBConnectorStartup.ORB_SE_CLASS);
                    } else {
                        System.setProperty(ORBConnectorStartup.OMG_ORB_CLASS_PROPERTY, ORBConnectorStartup.ORB_CLASS);
                    }
                }
                if (System.getProperty(ORBConnectorStartup.OMG_ORB_SINGLETON_CLASS_PROPERTY) == null) {
                    if (System.getProperty("java.vendor").equals("Sun Microsystems Inc.")) {
                        System.setProperty(ORBConnectorStartup.OMG_ORB_SINGLETON_CLASS_PROPERTY, ORBConnectorStartup.ORB_SE_SINGLETON_CLASS);
                    } else {
                        System.setProperty(ORBConnectorStartup.OMG_ORB_SINGLETON_CLASS_PROPERTY, ORBConnectorStartup.ORB_SINGLETON_CLASS);
                    }
                }
                System.setProperty(ORBConnectorStartup.ORB_UTIL_CLASS_PROPERTY, ORBConnectorStartup.RMI_UTIL_CLASS);
                System.setProperty(ORBConnectorStartup.RMIIIOP_STUB_DELEGATE_CLASS_PROPERTY, ORBConnectorStartup.RMI_STUB_CLASS);
                System.setProperty(ORBConnectorStartup.RMIIIOP_PRO_DELEGATE_CLASS_PROPERTY, ORBConnectorStartup.RMI_PRO_CLASS);
                return null;
            }
        });
    }
}

