/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.enterprise.iiop.impl;

import com.sun.corba.ee.impl.folb.GroupInfoServiceBase;
import com.sun.corba.ee.spi.folb.ClusterInstanceInfo;
import com.sun.corba.ee.spi.folb.GroupInfoService;
import com.sun.corba.ee.spi.folb.GroupInfoServiceObserver;
import com.sun.corba.ee.spi.folb.SocketInfo;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.IiopListener;
import com.sun.enterprise.config.serverbeans.IiopService;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.ee.cms.core.CallBack;
import com.sun.enterprise.ee.cms.core.FailureNotificationSignal;
import com.sun.enterprise.ee.cms.core.JoinedAndReadyNotificationSignal;
import com.sun.enterprise.ee.cms.core.PlannedShutdownSignal;
import com.sun.enterprise.ee.cms.core.Signal;
import com.sun.enterprise.ee.cms.core.SignalAcquireException;
import com.sun.enterprise.ee.cms.core.SignalReleaseException;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.config.support.GlassFishConfigBean;
import org.glassfish.config.support.PropertyResolver;
import org.glassfish.gms.bootstrap.GMSAdapter;
import org.glassfish.gms.bootstrap.GMSAdapterService;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IiopFolbGmsClient
implements CallBack {
    private static final Logger _logger = LogDomains.getLogger(IiopFolbGmsClient.class, (String)"javax.enterprise.resource.corba");
    @Inject
    private Domain domain;
    @Inject(name="default-instance-name")
    private Server myServer;
    @Inject
    private Habitat habitat;
    @Inject(optional=true)
    private GMSAdapterService gmsAdapterService;
    private GMSAdapter gmsAdapter;
    private Map<String, ClusterInstanceInfo> currentMembers;
    private GroupInfoService gis;

    private void fineLog(String fmt, java.lang.Object ... args) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, fmt, args);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IiopFolbGmsClient() {
        try {
            if (this.gmsAdapterService != null) {
                this.gmsAdapter = this.gmsAdapterService.getGMSAdapter();
                this.fineLog("IiopFolbGmsClient->: {0}", this.gmsAdapter);
                this.gis = new GroupInfoServiceGMSImpl();
                this.fineLog("IiopFolbGmsClient: IIOP GIS created", new java.lang.Object[0]);
                this.currentMembers = this.getAllClusterInstanceInfo();
                this.fineLog("IiopFolbGmsClient: currentMembers = ", this.currentMembers);
                this.gmsAdapter.registerFailureNotificationListener((CallBack)this);
                this.gmsAdapter.registerJoinedAndReadyNotificationListener((CallBack)this);
                this.gmsAdapter.registerPlannedShutdownListener((CallBack)this);
                this.fineLog("IiopFolbGmsClient: GMS action factories added", new java.lang.Object[0]);
            } else {
                this.gis = new GroupInfoServiceNoGMSImpl();
            }
        }
        catch (Throwable t) {
            _logger.log(Level.SEVERE, t.getLocalizedMessage(), t);
        }
        finally {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "IiopFolbGmsClient<-: {0}", this.gmsAdapter);
            }
        }
    }

    public void setORB(ORB orb) {
        try {
            orb.register_initial_reference("FolbServerGroupInfoService", (Object)this.gis);
            this.fineLog(".initGIS: naming registration complete: {0}", this.gis);
            if (_logger.isLoggable(Level.FINE)) {
                this.gis = (GroupInfoService)orb.resolve_initial_references("FolbServerGroupInfoService");
                List lcii = this.gis.getClusterInstanceInfo(null);
                _logger.log(Level.FINE, "Results from getClusterInstanceInfo:");
                if (lcii != null) {
                    for (ClusterInstanceInfo cii : lcii) {
                        _logger.log(Level.INFO, cii.toString());
                    }
                }
            }
        }
        catch (InvalidName e) {
            this.fineLog(".initGIS: registering GIS failed: {0}", new java.lang.Object[]{e});
        }
    }

    public GroupInfoService getGroupInfoService() {
        return this.gis;
    }

    public boolean isGMSAvailable() {
        return this.gmsAdapter != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processNotification(Signal signal) {
        try {
            signal.acquire();
            this.handleSignal(signal);
        }
        catch (SignalAcquireException e) {
            _logger.log(Level.SEVERE, e.getLocalizedMessage());
        }
        catch (Throwable t) {
            _logger.log(Level.SEVERE, t.getLocalizedMessage(), t);
        }
        finally {
            try {
                signal.release();
            }
            catch (SignalReleaseException e) {
                _logger.log(Level.SEVERE, e.getLocalizedMessage());
            }
        }
    }

    private void handleSignal(Signal signal) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "IiopFolbGmsClient.handleSignal: signal from: {0}", signal.getMemberToken());
            _logger.log(Level.FINE, "IiopFolbGmsClient.handleSignal: map entryset: {0}", signal.getMemberDetails().entrySet());
        }
        if (signal instanceof PlannedShutdownSignal || signal instanceof FailureNotificationSignal) {
            this.removeMember(signal);
        } else if (signal instanceof JoinedAndReadyNotificationSignal) {
            this.addMember(signal);
        } else {
            _logger.log(Level.SEVERE, "IiopFolbGmsClient.handleSignal: unknown signal: {0}", signal.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeMember(Signal signal) {
        String instanceName = signal.getMemberToken();
        try {
            this.fineLog("IiopFolbGmsClient.removeMember->: {0}", instanceName);
            IiopFolbGmsClient iiopFolbGmsClient = this;
            synchronized (iiopFolbGmsClient) {
                if (this.currentMembers.get(instanceName) != null) {
                    this.currentMembers.remove(instanceName);
                    this.fineLog("IiopFolbGmsClient.removeMember: {0} removed - notifying listeners", instanceName);
                    this.gis.notifyObservers();
                    this.fineLog("IiopFolbGmsClient.removeMember: {0} - notification complete", instanceName);
                } else {
                    this.fineLog("IiopFolbGmsClient.removeMember: {0} not present: no action", instanceName);
                }
            }
        }
        catch (Throwable throwable) {
            this.fineLog("IiopFolbGmsClient.removeMember<-: {0}", instanceName);
            throw throwable;
        }
        this.fineLog("IiopFolbGmsClient.removeMember<-: {0}", instanceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMember(Signal signal) {
        String instanceName = signal.getMemberToken();
        try {
            this.fineLog("IiopFolbGmsClient.addMember->: {0}", instanceName);
            IiopFolbGmsClient iiopFolbGmsClient = this;
            synchronized (iiopFolbGmsClient) {
                if (this.currentMembers.get(instanceName) != null) {
                    this.fineLog("IiopFolbGmsClient.addMember: {0} already present: no action", instanceName);
                } else {
                    ClusterInstanceInfo clusterInstanceInfo = this.getClusterInstanceInfo(instanceName);
                    this.currentMembers.put(clusterInstanceInfo.name(), clusterInstanceInfo);
                    this.fineLog("IiopFolbGmsClient.addMember: {0} added - notifying listeners", instanceName);
                    this.gis.notifyObservers();
                    this.fineLog("IiopFolbGmsClient.addMember: {0} - notification complete", instanceName);
                }
            }
        }
        catch (Throwable throwable) {
            this.fineLog("IiopFolbGmsClient.addMember<-: {0}", instanceName);
            throw throwable;
        }
        this.fineLog("IiopFolbGmsClient.addMember<-: {0}", instanceName);
    }

    private int resolvePort(Server server, IiopListener listener) {
        IiopListener ilRaw = (IiopListener)GlassFishConfigBean.getRawView((ConfigBeanProxy)listener);
        PropertyResolver pr = new PropertyResolver(this.domain, server.getName());
        String port = pr.getPropertyValue(ilRaw.getPort());
        return Integer.parseInt(port);
    }

    private ClusterInstanceInfo getClusterInstanceInfo(Server server, Config config) {
        String name = server.getName();
        int weight = Integer.parseInt(server.getLbWeight());
        String host = server.getNodeAgentRef();
        IiopService iservice = config.getIiopService();
        List listeners = iservice.getIiopListener();
        ArrayList<SocketInfo> sinfos = new ArrayList<SocketInfo>();
        for (IiopListener il : listeners) {
            SocketInfo sinfo = new SocketInfo(host, il.getId(), this.resolvePort(server, il));
            sinfos.add(sinfo);
        }
        ClusterInstanceInfo result = new ClusterInstanceInfo(name, weight, sinfos);
        return result;
    }

    private Config getConfigForServer(Server server) {
        String configRef = server.getConfigRef();
        Configs configs = (Configs)this.habitat.getComponent(Configs.class);
        Config config = configs.getConfigByName(configRef);
        return config;
    }

    private ClusterInstanceInfo getClusterInstanceInfo(String instanceName) {
        Servers servers = (Servers)this.habitat.getComponent(Servers.class);
        Server server = servers.getServer(instanceName);
        Config config = this.getConfigForServer(server);
        return this.getClusterInstanceInfo(server, config);
    }

    private Map<String, ClusterInstanceInfo> getAllClusterInstanceInfo() {
        Cluster myCluster = this.myServer.getCluster();
        Config myConfig = this.getConfigForServer(this.myServer);
        HashMap<String, ClusterInstanceInfo> result = new HashMap<String, ClusterInstanceInfo>();
        for (Server server : myCluster.getInstances()) {
            ClusterInstanceInfo cii = this.getClusterInstanceInfo(server, myConfig);
            result.put(server.getName(), cii);
        }
        return result;
    }

    class GroupInfoServiceNoGMSImpl
    extends GroupInfoServiceGMSImpl {
        GroupInfoServiceNoGMSImpl() {
        }

        public boolean addObserver(GroupInfoServiceObserver x) {
            throw new RuntimeException("SHOULD NOT BE CALLED");
        }

        public void notifyObservers() {
            throw new RuntimeException("SHOULD NOT BE CALLED");
        }

        public boolean shouldAddAddressesToNonReferenceFactory(String[] x) {
            throw new RuntimeException("SHOULD NOT BE CALLED");
        }

        public boolean shouldAddMembershipLabel(String[] adapterName) {
            throw new RuntimeException("SHOULD NOT BE CALLED");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class GroupInfoServiceGMSImpl
    extends GroupInfoServiceBase {
        GroupInfoServiceGMSImpl() {
        }

        public List<ClusterInstanceInfo> internalClusterInstanceInfo() {
            return new ArrayList<ClusterInstanceInfo>(IiopFolbGmsClient.this.currentMembers.values());
        }
    }
}

