/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.cometd;

import com.sun.grizzly.comet.CometEvent;
import com.sun.grizzly.comet.CometHandler;
import com.sun.grizzly.cometd.BayeuxParser;
import com.sun.grizzly.cometd.CometdRequest;
import com.sun.grizzly.cometd.CometdResponse;
import com.sun.grizzly.cometd.bayeux.DeliverResponse;
import com.sun.grizzly.cometd.bayeux.End;
import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.util.DataStructures;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataHandler
implements CometHandler<Object[]> {
    private static final Logger logger = SelectorThread.logger();
    private CometdRequest req;
    private CometdResponse res;
    private final Collection<String> channels = DataStructures.getCLQinstance(String.class);
    private BayeuxParser bayeuxParser;
    private volatile boolean isSuspended;
    private int remotePort = -1;
    private volatile boolean ended;
    private final String clientId;

    public DataHandler(String clientId, BayeuxParser bayeuxParser) {
        this.clientId = clientId;
        this.bayeuxParser = bayeuxParser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void write(String s, CometdResponse res, boolean flush) throws IOException {
        if (this != BayeuxParser.dumyhandler) {
            DataHandler dataHandler = this;
            synchronized (dataHandler) {
                res.write(s);
                if (flush) {
                    res.flush();
                }
            }
        } else {
            res.write(s);
            if (flush) {
                res.flush();
            }
        }
    }

    public void attach(Object[] reqRes) {
        this.req = (CometdRequest)reqRes[0];
        this.res = (CometdResponse)reqRes[1];
        this.remotePort = this.req.getRemotePort();
        this.ended = false;
    }

    public void onEvent(CometEvent event) throws IOException {
        Object obj = event.attachment();
        try {
            if (obj instanceof DeliverResponse) {
                DeliverResponse deliverRes = (DeliverResponse)obj;
                if (this.getChannels().contains(deliverRes.getChannel())) {
                    this.res.write(deliverRes.toJSON());
                    this.res.flush();
                    this.ended = deliverRes.isLast();
                    if (deliverRes.isFinished()) {
                        event.getCometContext().resumeCometHandler((CometHandler)this);
                    }
                }
            } else if (obj instanceof End) {
                End end = (End)obj;
                Set<String> channels = end.getChannels();
                boolean intersect = false;
                for (String ch : channels) {
                    boolean temp = this.containsChannel(ch);
                    if (!temp) continue;
                    intersect = temp;
                    break;
                }
                if (intersect) {
                    if (!this.ended && end.getRequestPort() != this.remotePort) {
                        this.res.write("]");
                        this.res.flush();
                        this.ended = true;
                    }
                    event.getCometContext().resumeCometHandler((CometHandler)this);
                }
            }
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "DataHandler.onEvent", t);
        }
    }

    public void onInitialize(CometEvent event) throws IOException {
    }

    public void onTerminate(CometEvent event) throws IOException {
    }

    public void onInterrupt(CometEvent event) throws IOException {
    }

    public String getClientId() {
        return this.clientId;
    }

    public Collection<String> getChannels() {
        return this.channels;
    }

    public void addChannel(String channel) {
        if (this.channels.contains(channel)) {
            throw new IllegalArgumentException(channel);
        }
        this.channels.add(channel);
    }

    public boolean containsChannel(String channel) {
        return this.channels.contains(channel);
    }

    public boolean removeChannel(String channel) {
        return this.channels.remove(channel);
    }

    public boolean isSuspended() {
        return this.isSuspended;
    }

    public void setSuspended(boolean isSuspended) {
        this.isSuspended = isSuspended;
    }

    public int getRemotePort() {
        return this.remotePort;
    }
}

