/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.websockets;

import com.sun.grizzly.websockets.DataFrame;
import com.sun.grizzly.websockets.NetworkHandler;
import com.sun.grizzly.websockets.WebSocket;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum FrameType {
    TEXT{

        public boolean accept(NetworkHandler handler) throws IOException {
            return handler.peek(0);
        }

        public byte[] unframe(NetworkHandler handler) throws IOException {
            byte b;
            ByteArrayOutputStream raw = new ByteArrayOutputStream();
            handler.get();
            while ((b = handler.get()) != -1) {
                raw.write(b);
            }
            return raw.toByteArray();
        }

        public byte[] frame(byte[] data) {
            ByteArrayOutputStream out = new ByteArrayOutputStream(data.length + 2);
            out.write(0);
            out.write(data, 0, data.length);
            out.write(-1);
            return out.toByteArray();
        }

        public void respond(WebSocket socket, DataFrame frame) throws IOException {
            socket.onMessage(frame);
        }
    }
    ,
    CLOSING{

        public boolean accept(NetworkHandler handler) throws IOException {
            return handler.peek(-1, 0);
        }

        public byte[] unframe(NetworkHandler handler) throws IOException {
            return new byte[]{handler.get(), handler.get()};
        }

        public byte[] frame(byte[] data) {
            return new byte[]{-1, 0};
        }

        public void respond(WebSocket socket, DataFrame frame) throws IOException {
            socket.close();
        }
    };


    public abstract boolean accept(NetworkHandler var1) throws IOException;

    public abstract byte[] unframe(NetworkHandler var1) throws IOException;

    public abstract byte[] frame(byte[] var1);

    public abstract void respond(WebSocket var1, DataFrame var2) throws IOException;
}

