/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.websockets;

import com.sun.grizzly.websockets.DataFrame;
import com.sun.grizzly.websockets.FrameType;
import com.sun.grizzly.websockets.FramingException;
import java.io.UnsupportedEncodingException;

public class ClosingFrame
extends DataFrame {
    public static final byte[] EMPTY_BYTES = new byte[0];
    private int code;
    private String reason;

    public ClosingFrame() {
        this.code = -1;
        this.setType(FrameType.CLOSING);
    }

    public ClosingFrame(int code, String reason) {
        this.code = code;
        this.reason = reason;
        this.setType(FrameType.CLOSING);
    }

    public int getCode() {
        return this.code;
    }

    public String getReason() {
        return this.reason;
    }

    public void setPayload(byte[] bytes) {
        if (bytes.length > 0) {
            this.code = (int)ClosingFrame.convert(bytes, 0, 2);
            if (bytes.length > 2) {
                try {
                    this.reason = new String(bytes, 2, bytes.length - 2, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new FramingException(e.getMessage(), e);
                }
            }
        }
    }

    public byte[] getBinaryPayload() {
        try {
            if (this.code == -1) {
                return EMPTY_BYTES;
            }
            byte[] bytes = ClosingFrame.toArray(this.code);
            byte[] reasonBytes = this.reason == null ? EMPTY_BYTES : this.reason.getBytes("UTF-8");
            byte[] frameBytes = new byte[2 + reasonBytes.length];
            System.arraycopy(bytes, bytes.length - 2, frameBytes, 0, 2);
            System.arraycopy(reasonBytes, 0, frameBytes, 2, reasonBytes.length);
            return frameBytes;
        }
        catch (UnsupportedEncodingException e) {
            throw new FramingException(e.getMessage(), e);
        }
    }
}

