/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.websockets;

import com.sun.grizzly.arp.AsyncProcessorTask;
import com.sun.grizzly.http.ProcessorTask;
import com.sun.grizzly.util.SelectedKeyAttachmentLogic;
import com.sun.grizzly.websockets.ServerNetworkHandler;
import com.sun.grizzly.websockets.WebSocketEngine;
import com.sun.grizzly.websockets.WebSocketException;
import java.nio.channels.SelectionKey;
import java.util.logging.Level;

public class WebSocketSelectionKeyAttachment
extends SelectedKeyAttachmentLogic
implements Runnable {
    private final ServerNetworkHandler handler;
    private final ProcessorTask processorTask;
    private final AsyncProcessorTask asyncProcessorTask;

    public WebSocketSelectionKeyAttachment(ServerNetworkHandler snh, ProcessorTask task, AsyncProcessorTask asyncTask) {
        this.handler = snh;
        this.processorTask = task;
        this.asyncProcessorTask = asyncTask;
    }

    public boolean timedOut(SelectionKey key) {
        return false;
    }

    public boolean handleSelectedKey(SelectionKey key) {
        if (key.isReadable()) {
            key.interestOps(key.interestOps() & 0xFFFFFFFE);
            this.asyncProcessorTask.getThreadPool().execute(this);
        }
        return false;
    }

    public void run() {
        try {
            this.handler.readFrame();
            this.enableRead();
        }
        catch (WebSocketException e) {
            this.processorTask.setAptCancelKey(true);
            this.processorTask.terminateProcess();
            WebSocketEngine.logger.log(Level.INFO, e.getMessage(), e);
        }
    }

    public final void enableRead() {
        this.processorTask.getSelectorHandler().register(this.getSelectionKey(), 1);
    }

    public SelectionKey getSelectionKey() {
        return this.asyncProcessorTask.getAsyncExecutor().getProcessorTask().getSelectionKey();
    }

    public ServerNetworkHandler getHandler() {
        return this.handler;
    }
}

