/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.websockets;

import com.sun.grizzly.websockets.DataFrame;
import com.sun.grizzly.websockets.FrameType;
import com.sun.grizzly.websockets.FramingException;
import com.sun.grizzly.websockets.NetworkHandler;

public abstract class BaseNetworkHandler
implements NetworkHandler {
    public DataFrame unframe() {
        byte opcodes = this.get();
        boolean fin = (opcodes & 0x80) == 128;
        byte lengthCode = this.get();
        long length = lengthCode <= 125 ? (long)lengthCode : DataFrame.convert(this.get(lengthCode == 126 ? 2 : 8));
        FrameType type = FrameType.valueOf(opcodes);
        byte[] data = this.get((int)length);
        if ((long)data.length != length) {
            FramingException e = new FramingException(String.format("Data read (%s) is not the expected size (%s)", data.length, length));
            e.printStackTrace();
            throw e;
        }
        DataFrame frame = type.create();
        frame.setLast(fin);
        type.unframe(frame, data);
        return frame;
    }

    public abstract byte get();

    public abstract byte[] get(int var1);
}

