/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.websockets;

import java.net.URI;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.websockets.HandshakeException;
import org.glassfish.grizzly.websockets.SecKey;

public class ClientHandshake {
    private final SecKey key;
    private String host;
    private boolean secure;
    private int port;
    private String path;
    private URI uri;
    private String[] protocols;
    private String[] extensions;

    public ClientHandshake(URI uri, String ... protocols) {
        this.uri = uri;
        this.protocols = protocols;
        this.sanitize(this.protocols);
        this.secure = "wss".equals(uri.getScheme());
        this.host = uri.getHost();
        this.port = uri.getPort();
        this.path = uri.getPath();
        this.key = new SecKey();
    }

    public SecKey getKey() {
        return this.key;
    }

    public void validateServerResponse(HttpResponsePacket headers) throws HandshakeException {
        if (101 != headers.getStatus()) {
            throw new HandshakeException(String.format("Response code was not %s: %s", 101, headers.getStatus()));
        }
        this.checkForHeader(headers, "upgrade", "websocket");
        this.checkForHeader(headers, "connection", "upgrade");
        this.key.validateServerKey(headers.getHeader("Sec-WebSocket-Accept"));
    }

    private void checkForHeader(HttpResponsePacket headers, String header, String validValue) {
        String value = headers.getHeader(header);
        if (!validValue.equalsIgnoreCase(value)) {
            throw new HandshakeException(String.format("Invalid %s header returned: '%s'", header, value));
        }
    }

    public HttpContent composeHeaders() {
        HttpRequestPacket.Builder builder = (HttpRequestPacket.Builder)((HttpRequestPacket.Builder)((HttpRequestPacket.Builder)((HttpRequestPacket.Builder)((HttpRequestPacket.Builder)((HttpRequestPacket.Builder)HttpRequestPacket.builder().method("GET").uri(this.path).protocol("HTTP/1.1")).header("Host", this.host)).header("Connection", "Upgrade")).upgrade("WebSocket")).header("Sec-WebSocket-Key", this.getKey().toString())).header("Sec-WebSocket-Version", "6");
        if (this.protocols != null) {
            builder.header("Sec-WebSocket-Protocol", this.join(this.protocols));
        }
        if (this.extensions != null) {
            builder.header("Sec-WebSocket-Extensions", this.join(this.extensions));
        }
        return HttpContent.builder((HttpHeader)builder.build()).build();
    }

    public String[] getExtensions() {
        return this.extensions;
    }

    public void setExtensions(String[] extensions) {
        this.sanitize(extensions);
        this.extensions = extensions;
    }

    private void sanitize(String[] strings) {
        if (strings != null) {
            for (int i = 0; i < strings.length; ++i) {
                strings[i] = strings[i] == null ? null : strings[i].trim();
            }
        }
    }

    private String join(String[] values) {
        StringBuilder builder = new StringBuilder();
        for (String s : values) {
            if (builder.length() != 0) {
                builder.append("; ");
            }
            builder.append(s);
        }
        return null;
    }

    public URI getURI() {
        return this.uri;
    }
}

