/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.websockets;

import java.io.UnsupportedEncodingException;
import org.glassfish.grizzly.websockets.DataFrame;
import org.glassfish.grizzly.websockets.FramingException;
import org.glassfish.grizzly.websockets.WebSocket;

public enum FrameType {
    CONTINUATION,
    CLOSING{

        @Override
        public void respond(WebSocket socket, DataFrame frame) {
            socket.onClose(frame);
        }
    }
    ,
    PING{

        @Override
        public void respond(WebSocket socket, DataFrame frame) {
            socket.onPing(frame);
        }
    }
    ,
    PONG,
    TEXT{

        @Override
        public void unframe(DataFrame frame, byte[] data) {
            try {
                frame.setPayload(new String(data, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new FramingException(e.getMessage(), e);
            }
        }

        @Override
        public byte[] frame(DataFrame dataFrame) {
            try {
                return dataFrame.getTextPayload().getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new FramingException(e.getMessage(), e);
            }
        }

        @Override
        public void respond(WebSocket socket, DataFrame frame) {
            socket.onMessage(frame.getTextPayload());
        }
    }
    ,
    BINARY;


    public void unframe(DataFrame frame, byte[] data) {
        frame.setPayload(data);
        frame.setType(this);
    }

    public byte[] frame(DataFrame dataFrame) {
        return dataFrame.getBinaryPayload();
    }

    public void respond(WebSocket socket, DataFrame frame) {
        socket.onMessage(frame.getBinaryPayload());
    }

    public final byte setOpcode(byte b) {
        return (byte)(b | this.ordinal());
    }

    public static FrameType valueOf(byte opcodes) {
        return FrameType.values()[opcodes & 0xF];
    }
}

