/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.websockets;

import java.io.IOException;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Appendable;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.websockets.DataFrame;
import org.glassfish.grizzly.websockets.FramingException;
import org.glassfish.grizzly.websockets.HandshakeException;
import org.glassfish.grizzly.websockets.ParseResult;
import org.glassfish.grizzly.websockets.WebSocket;
import org.glassfish.grizzly.websockets.WebSocketEngine;

public class WebSocketFilter
extends BaseFilter {
    private static final Logger logger = Grizzly.logger(WebSocketFilter.class);
    private static final Random random = new Random();

    public NextAction handleConnect(FilterChainContext ctx) throws IOException {
        logger.log(Level.FINEST, "handleConnect");
        Connection connection = ctx.getConnection();
        if (!this.isWebSocketConnection(connection)) {
            return ctx.getInvokeAction();
        }
        ctx.write((Object)WebSocketEngine.getEngine().getWebSocketHolder((Connection)connection).handshake.composeHeaders());
        ctx.flush(null);
        return ctx.getInvokeAction();
    }

    public NextAction handleClose(FilterChainContext ctx) throws IOException {
        WebSocket ws;
        Connection connection = ctx.getConnection();
        if (this.isWebSocketConnection(connection) && (ws = this.getWebSocket(connection)) != null) {
            ws.close();
        }
        return ctx.getInvokeAction();
    }

    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        Connection connection = ctx.getConnection();
        HttpContent message = (HttpContent)ctx.getMessage();
        HttpHeader header = message.getHttpHeader();
        WebSocketEngine.WebSocketHolder holder = WebSocketEngine.getEngine().getWebSocketHolder(connection);
        WebSocket ws = this.getWebSocket(connection);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "handleRead websocket: {0} content-size={1} headers=\n{2}", new Object[]{ws, message.getContent().remaining(), header});
        }
        if (ws == null || !ws.isConnected()) {
            if (!this.isWebSocketConnection(connection) && !"websocket".equalsIgnoreCase(header.getUpgrade())) {
                return ctx.getInvokeAction();
            }
            return this.handleHandshake(ctx, message);
        }
        if (message.getContent().hasRemaining()) {
            Buffer buffer = message.getContent();
            message.recycle();
            try {
                while (buffer != null && buffer.hasRemaining()) {
                    DataFrame parsingFrame = holder.frame;
                    if (parsingFrame == null) {
                        parsingFrame = new DataFrame();
                    } else if (holder.buffer != null) {
                        buffer = Buffers.appendBuffers((MemoryManager)MemoryManager.DEFAULT_MEMORY_MANAGER, (Buffer)holder.buffer, (Buffer)buffer);
                        holder.buffer = null;
                        holder.frame = null;
                    }
                    ParseResult result = parsingFrame.unframe(holder.unmaskOnRead, buffer);
                    buffer = result.getRemainder();
                    boolean complete = result.isComplete();
                    result.recycle();
                    if (!complete) {
                        holder.frame = parsingFrame;
                        holder.buffer = buffer;
                        break;
                    }
                    parsingFrame.respond(holder.webSocket);
                }
            }
            catch (FramingException e) {
                if (e.getCode() != -1) {
                    holder.webSocket.close(e.getCode(), e.getMessage());
                }
                holder.webSocket.close();
            }
        }
        return ctx.getStopAction();
    }

    public NextAction handleWrite(FilterChainContext ctx) throws IOException {
        WebSocket websocket = this.getWebSocket(ctx.getConnection());
        if (websocket != null) {
            DataFrame frame = (DataFrame)ctx.getMessage();
            byte[] bytes = frame.frame();
            if (!WebSocketEngine.getEngine().getWebSocketHolder((Connection)ctx.getConnection()).unmaskOnRead) {
                byte[] masked = new byte[bytes.length + 4];
                byte[] mask = WebSocketFilter.generateMask();
                System.arraycopy(mask, 0, masked, 0, 4);
                for (int i = 0; i < bytes.length; ++i) {
                    masked[i + 4] = (byte)(bytes[i] ^ mask[i % 4]);
                }
                bytes = masked;
            }
            ctx.setMessage((Object)Buffers.wrap((MemoryManager)ctx.getMemoryManager(), (byte[])bytes));
        }
        return ctx.getInvokeAction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] generateMask() {
        byte[] maskBytes = new byte[4];
        Random random = WebSocketFilter.random;
        synchronized (random) {
            WebSocketFilter.random.nextBytes(maskBytes);
        }
        return maskBytes;
    }

    private NextAction handleHandshake(FilterChainContext ctx, HttpContent content) throws IOException {
        return content.getHttpHeader().isRequest() ? this.handleServerHandshake(ctx, content) : this.handleClientHandShake(ctx, content);
    }

    private NextAction handleClientHandShake(FilterChainContext ctx, HttpContent content) {
        HttpResponsePacket response = (HttpResponsePacket)content.getHttpHeader();
        WebSocketEngine.WebSocketHolder holder = WebSocketEngine.getEngine().getWebSocketHolder(ctx.getConnection());
        holder.unmaskOnRead = false;
        if (response.getStatus() != 101) {
            throw new HandshakeException(1002, String.format("Invalid response code returned (%s) with message: %s", response.getStatus(), response.getReasonPhrase()));
        }
        holder.handshake.validateServerResponse(response);
        holder.webSocket.onConnect();
        return ctx.getStopAction((Appendable)content);
    }

    private NextAction handleServerHandshake(FilterChainContext ctx, HttpContent requestContent) throws IOException {
        HttpRequestPacket request = (HttpRequestPacket)requestContent.getHttpHeader();
        try {
            WebSocketEngine.getEngine().upgrade(ctx, request);
        }
        catch (HandshakeException e) {
            ctx.write((Object)this.composeHandshakeError(request, e));
        }
        ctx.flush(null);
        return ctx.getStopAction();
    }

    private WebSocket getWebSocket(Connection connection) {
        return WebSocketEngine.getEngine().getWebSocket(connection);
    }

    private boolean isWebSocketConnection(Connection connection) {
        return WebSocketEngine.getEngine().isWebSocket(connection);
    }

    private HttpResponsePacket composeHandshakeError(HttpRequestPacket request, HandshakeException e) {
        HttpResponsePacket response = request.getResponse();
        response.setStatus(e.getCode());
        response.setReasonPhrase(e.getMessage());
        return response;
    }
}

