/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.http;

import com.sun.grizzly.Context;
import com.sun.grizzly.Controller;
import com.sun.grizzly.ProtocolFilter;
import com.sun.grizzly.http.HttpWorkerThread;
import com.sun.grizzly.http.KeepAliveStats;
import com.sun.grizzly.http.KeepAliveThreadAttachment;
import com.sun.grizzly.http.ProcessorTask;
import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.http.algorithms.NoParsingAlgorithm;
import com.sun.grizzly.util.InputReader;
import com.sun.grizzly.util.Interceptor;
import com.sun.grizzly.util.StreamAlgorithm;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultProtocolFilter
implements ProtocolFilter {
    protected Class algorithmClass;
    protected int port;
    protected static final Logger logger = SelectorThread.logger();

    public DefaultProtocolFilter(Class algorithmClass, int port) {
        this.algorithmClass = algorithmClass;
        this.port = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(Context ctx) throws IOException {
        StreamAlgorithm streamAlgorithm;
        HttpWorkerThread workerThread = (HttpWorkerThread)((Object)Thread.currentThread());
        SelectorThread selectorThread = SelectorThread.getSelector(this.port);
        ByteBuffer byteBuffer = workerThread.getByteBuffer();
        InputReader inputStream = workerThread.getInputStream();
        if (inputStream == null) {
            inputStream = new InputReader();
            workerThread.setInputStream(inputStream);
        }
        if ((streamAlgorithm = workerThread.getStreamAlgorithm()) == null) {
            try {
                streamAlgorithm = (StreamAlgorithm)this.algorithmClass.newInstance();
            }
            catch (InstantiationException ex) {
                logger.log(Level.WARNING, "Unable to instantiate Algorithm: " + this.algorithmClass.getName());
            }
            catch (IllegalAccessException ex) {
                logger.log(Level.WARNING, "Unable to instantiate Algorithm: " + this.algorithmClass.getName());
            }
            finally {
                if (streamAlgorithm == null) {
                    streamAlgorithm = new NoParsingAlgorithm();
                }
            }
            streamAlgorithm.setPort(this.port);
            workerThread.setStreamAlgorithm(streamAlgorithm);
        }
        SelectionKey key = ctx.getSelectionKey();
        this.configureInputBuffer(inputStream, ctx, workerThread);
        SocketChannel socketChannel = (SocketChannel)key.channel();
        streamAlgorithm.setChannel((Object)socketChannel);
        byteBuffer = streamAlgorithm.preParse(byteBuffer);
        boolean keepAlive = false;
        ProcessorTask processorTask = workerThread.getProcessorTask();
        if (streamAlgorithm.parse(byteBuffer)) {
            if (processorTask == null) {
                processorTask = selectorThread.getProcessorTask();
                workerThread.setProcessorTask(processorTask);
            }
            KeepAliveThreadAttachment k = (KeepAliveThreadAttachment)workerThread.getAttachment();
            k.setTimeout(System.currentTimeMillis());
            KeepAliveStats ks = selectorThread.getKeepAliveStats();
            k.setKeepAliveStats(ks);
            ctx.getSelectionKey().attach((Object)k);
            int count = k.increaseKeepAliveCount();
            if (count > selectorThread.getMaxKeepAliveRequests() && ks != null) {
                ks.incrementCountRefusals();
                processorTask.setDropConnection(true);
            } else {
                processorTask.setDropConnection(false);
            }
            this.configureProcessorTask(processorTask, ctx, streamAlgorithm.getHandler());
            try {
                keepAlive = processorTask.process((InputStream)inputStream, null);
            }
            catch (Throwable ex) {
                logger.log(Level.INFO, "ProcessorTask exception", ex);
                keepAlive = false;
            }
        } else {
            if (ctx.getProtocol() == Controller.Protocol.TCP) {
                ctx.getSelectionKey().attach(null);
            } else {
                workerThread.getAttachment().setTimeout(Long.MIN_VALUE);
            }
            keepAlive = true;
        }
        Object ra = workerThread.getAttachment().getAttribute("suspend");
        if (ra != null) {
            workerThread.setInputStream(new InputReader());
            workerThread.setByteBuffer(null);
            workerThread.setProcessorTask(null);
            ctx.setKeyRegistrationState(Context.KeyRegistrationState.REGISTER);
            return true;
        }
        if (processorTask != null) {
            processorTask.recycle();
        }
        if (keepAlive) {
            ctx.setKeyRegistrationState(Context.KeyRegistrationState.REGISTER);
        } else {
            ctx.setKeyRegistrationState(Context.KeyRegistrationState.CANCEL);
        }
        streamAlgorithm.postParse(byteBuffer);
        byteBuffer.clear();
        if (selectorThread.isRcmSupported()) {
            ctx.removeAttribute("bbInputStream");
            ctx.removeAttribute("byteBuffer");
            ctx.removeAttribute("invokeNextFilter");
        }
        return true;
    }

    public boolean postExecute(Context ctx) throws IOException {
        return true;
    }

    protected void configureProcessorTask(ProcessorTask processorTask, Context context, Interceptor handler) {
        SelectionKey key = context.getSelectionKey();
        processorTask.setSelectorHandler(context.getSelectorHandler());
        processorTask.setSelectionKey(key);
        processorTask.setSocket(((SocketChannel)key.channel()).socket());
        if (processorTask.getHandler() == null) {
            processorTask.setHandler(handler);
        }
    }

    protected void configureInputBuffer(InputReader inputStream, Context context, HttpWorkerThread workerThread) {
        inputStream.setSelectionKey(context.getSelectionKey());
        inputStream.setByteBuffer(workerThread.getByteBuffer());
        inputStream.setSecure(this.isSecure());
    }

    protected boolean isSecure() {
        return false;
    }
}

