/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.tcp;

import com.sun.grizzly.tcp.ActionCode;
import com.sun.grizzly.tcp.ActionHook;
import com.sun.grizzly.tcp.CompletionHandler;
import com.sun.grizzly.tcp.NotesManagerImpl;
import com.sun.grizzly.tcp.OutputBuffer;
import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.tcp.ResponseFilter;
import com.sun.grizzly.tcp.SuspendResponseUtils;
import com.sun.grizzly.tcp.http11.InternalOutputBuffer;
import com.sun.grizzly.tcp.http11.filters.VoidOutputFilter;
import com.sun.grizzly.util.LoggerUtils;
import com.sun.grizzly.util.SelectionKeyAttachment;
import com.sun.grizzly.util.ThreadAttachment;
import com.sun.grizzly.util.buf.ByteChunk;
import com.sun.grizzly.util.http.MimeHeaders;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Locale;
import java.util.concurrent.Semaphore;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Response<A> {
    private static Locale DEFAULT_LOCALE = Locale.getDefault();
    private Semaphore lock = new Semaphore(1);
    public static final String SUSPENDED = "suspend";
    protected int status = 200;
    protected String message = null;
    protected MimeHeaders headers = new MimeHeaders();
    protected OutputBuffer outputBuffer;
    private NotesManagerImpl notesManager = new NotesManagerImpl();
    protected boolean commited = false;
    public ActionHook hook;
    protected String contentType = null;
    protected String contentLanguage = null;
    protected String characterEncoding;
    private String quotedCharsetValue = this.characterEncoding = "ISO-8859-1";
    protected long contentLength = -1L;
    private Locale locale = DEFAULT_LOCALE;
    private long bytesWritten = 0L;
    protected Exception errorException = null;
    protected boolean charsetSet = false;
    protected String errorURI = null;
    protected Request req;
    private SocketChannel channel;
    private volatile boolean isSuspended = false;
    private ResponseAttachment ra;
    public static final boolean discardDisconnectEvent = Boolean.getBoolean("com.sun.grizzly.discardDisconnect");

    public Request getRequest() {
        return this.req;
    }

    public void setRequest(Request req) {
        this.req = req;
    }

    public OutputBuffer getOutputBuffer() {
        return this.outputBuffer;
    }

    public void setOutputBuffer(OutputBuffer outputBuffer) {
        this.outputBuffer = outputBuffer;
    }

    public MimeHeaders getMimeHeaders() {
        return this.headers;
    }

    public ActionHook getHook() {
        return this.hook;
    }

    public void setHook(ActionHook hook) {
        this.hook = hook;
    }

    public final void setNote(int pos, Object value) {
        this.notesManager.setNote(pos, value);
    }

    public final Object getNote(int pos) {
        return this.notesManager.getNote(pos);
    }

    public NotesManagerImpl getNotesManager() {
        return this.notesManager;
    }

    public void setNotesManager(NotesManagerImpl notesManager) {
        this.notesManager = notesManager;
    }

    public void action(ActionCode actionCode, Object param) {
        if (this.hook != null) {
            if (param == null) {
                this.hook.action(actionCode, this);
            } else {
                this.hook.action(actionCode, param);
            }
        }
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean isCommitted() {
        return this.commited;
    }

    public void setCommitted(boolean v) {
        this.commited = v;
    }

    public void setErrorException(Exception ex) {
        this.errorException = ex;
    }

    public Exception getErrorException() {
        return this.errorException;
    }

    public boolean isExceptionPresent() {
        return this.errorException != null;
    }

    public void setErrorURI(String uri) {
        this.errorURI = uri;
    }

    public String getErrorURI() {
        return this.errorURI;
    }

    public void reset() throws IllegalStateException {
        this.contentType = null;
        this.locale = DEFAULT_LOCALE;
        this.contentLanguage = null;
        this.quotedCharsetValue = this.characterEncoding = "ISO-8859-1";
        this.contentLength = -1L;
        this.charsetSet = false;
        this.status = 200;
        this.message = null;
        this.headers.clear();
        this.isSuspended = false;
        if (this.commited) {
            throw new IllegalStateException();
        }
        this.action(ActionCode.ACTION_RESET, this);
    }

    public void discardUpstreamWrites() throws IllegalStateException {
        this.action(ActionCode.ACTION_DISCARD_UPSTREAM_WRITE, this);
    }

    public void flush() throws IOException {
        this.action(ActionCode.ACTION_CLIENT_FLUSH, this);
    }

    public void finish() throws IOException {
        this.action(ActionCode.ACTION_CLOSE, this);
    }

    public void acknowledge() throws IOException {
        this.action(ActionCode.ACTION_ACK, this);
    }

    public boolean containsHeader(String name) {
        return this.headers.getHeader(name) != null;
    }

    public void setHeader(String name, String value) {
        char cc = name.charAt(0);
        if ((cc == 'C' || cc == 'c') && this.checkSpecialHeader(name, value)) {
            return;
        }
        this.headers.setValue(name).setString(value);
    }

    public void addHeader(String name, String value) {
        char cc = name.charAt(0);
        if ((cc == 'C' || cc == 'c') && this.checkSpecialHeader(name, value)) {
            return;
        }
        this.headers.addValue(name).setString(value);
    }

    private boolean checkSpecialHeader(String name, String value) {
        if (name.equalsIgnoreCase("Content-Type")) {
            this.setContentType(value);
            return true;
        }
        if (name.equalsIgnoreCase("Content-Length")) {
            try {
                int cL = Integer.parseInt(value);
                this.setContentLength(cL);
                return true;
            }
            catch (NumberFormatException ex) {
                return false;
            }
        }
        if (name.equalsIgnoreCase("Content-Language")) {
            // empty if block
        }
        return false;
    }

    public void sendHeaders() throws IOException {
        this.action(ActionCode.ACTION_COMMIT, this);
        this.commited = true;
    }

    public void flushHeaders() throws IOException {
        this.action(ActionCode.ACTION_CLOSE, this);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        if (locale == null) {
            return;
        }
        this.locale = locale;
        this.contentLanguage = locale.getLanguage();
        if (this.contentLanguage != null && this.contentLanguage.length() > 0) {
            String country = locale.getCountry();
            StringBuilder value = new StringBuilder(this.contentLanguage);
            if (country != null && country.length() > 0) {
                value.append('-');
                value.append(country);
            }
            this.contentLanguage = value.toString();
        }
    }

    public String getContentLanguage() {
        return this.contentLanguage;
    }

    public void setCharacterEncoding(String charset) {
        if (this.isCommitted()) {
            return;
        }
        if (charset == null) {
            return;
        }
        this.characterEncoding = charset;
        this.quotedCharsetValue = charset;
        this.charsetSet = true;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setContentType(String type) {
        int semicolonIndex = -1;
        if (type == null) {
            this.contentType = null;
            return;
        }
        boolean hasCharset = false;
        int len = type.length();
        int index = type.indexOf(59);
        while (index != -1) {
            semicolonIndex = index++;
            while (index < len && Character.isSpace(type.charAt(index))) {
                ++index;
            }
            if (index + 8 < len && type.charAt(index) == 'c' && type.charAt(index + 1) == 'h' && type.charAt(index + 2) == 'a' && type.charAt(index + 3) == 'r' && type.charAt(index + 4) == 's' && type.charAt(index + 5) == 'e' && type.charAt(index + 6) == 't' && type.charAt(index + 7) == '=') {
                hasCharset = true;
                break;
            }
            index = type.indexOf(59, index);
        }
        if (!hasCharset) {
            this.contentType = type;
            return;
        }
        this.contentType = type.substring(0, semicolonIndex);
        String tail = type.substring(index + 8);
        int nextParam = tail.indexOf(59);
        String charsetValue = null;
        if (nextParam != -1) {
            this.contentType = this.contentType + tail.substring(nextParam);
            charsetValue = tail.substring(0, nextParam);
        } else {
            charsetValue = tail;
        }
        if (charsetValue != null && charsetValue.length() > 0) {
            this.charsetSet = true;
            this.quotedCharsetValue = charsetValue;
            this.characterEncoding = charsetValue.replace('\"', ' ').trim();
        }
    }

    public String getContentType() {
        String ret = this.contentType;
        if (ret != null && this.quotedCharsetValue != null && this.charsetSet) {
            ret = ret + ";charset=" + this.quotedCharsetValue;
        }
        return ret;
    }

    public void setContentLength(int contentLength) {
        this.contentLength = contentLength;
    }

    public int getContentLength() {
        return (int)this.contentLength;
    }

    public void setContentLengthLong(long contentLength) {
        this.contentLength = contentLength;
    }

    public long getContentLengthLong() {
        return this.contentLength;
    }

    public void doWrite(ByteChunk chunk) throws IOException {
        if (this.isSuspended) {
            this.action(ActionCode.RESET_SUSPEND_TIMEOUT, this);
        }
        this.outputBuffer.doWrite(chunk, this);
        this.bytesWritten += (long)chunk.getLength();
    }

    public void recycle() {
        this.channel = null;
        this.contentType = null;
        this.contentLanguage = null;
        this.locale = DEFAULT_LOCALE;
        this.quotedCharsetValue = this.characterEncoding = "ISO-8859-1";
        this.charsetSet = false;
        this.contentLength = -1L;
        this.status = 200;
        this.message = null;
        this.commited = false;
        this.errorException = null;
        this.errorURI = null;
        this.headers.clear();
        this.isSuspended = false;
        this.ra = null;
    }

    public long getBytesWritten() {
        return this.bytesWritten;
    }

    public void setBytesWritten(long bytesWritten) {
        this.bytesWritten = bytesWritten;
    }

    public void removeSessionCookies() {
        this.headers.removeHeader("Set-Cookie", "^JSESSIONID(?:SSO)?=.*");
    }

    public void setChannel(SocketChannel channel) {
        this.channel = channel;
    }

    public SocketChannel getChannel() {
        return this.channel;
    }

    public void resume() {
        if (this.lock.tryAcquire()) {
            if (!this.isSuspended) {
                throw new IllegalStateException("Not Suspended");
            }
            boolean isReallySuspended = this.ra.isAttached();
            this.req.action(ActionCode.CANCEL_SUSPENDED_RESPONSE, null);
            if (isReallySuspended) {
                this.ra.resume();
                this.req.action(ActionCode.ACTION_FINISH_RESPONSE, null);
            } else {
                this.ra.invokeCompletionHandler();
            }
        } else {
            throw new IllegalStateException("Not Suspended");
        }
        this.isSuspended = false;
        this.ra = null;
        this.lock.release();
    }

    public void cancel() {
        if (this.lock.tryAcquire()) {
            if (!this.isSuspended) {
                throw new IllegalStateException("Not Suspended");
            }
        } else {
            throw new IllegalStateException("Not Suspended");
        }
        this.req.action(ActionCode.CANCEL_SUSPENDED_RESPONSE, null);
        this.ra.timeout(false);
        this.req.action(ActionCode.ACTION_FINISH_RESPONSE, null);
        this.isSuspended = false;
        this.lock.release();
    }

    public boolean isSuspended() {
        return this.isSuspended;
    }

    public void suspend() {
        this.suspend(Long.MAX_VALUE);
    }

    public void suspend(long timeout) {
        this.suspend(timeout, null, null);
    }

    public void suspend(long timeout, A attachment, CompletionHandler<? super A> competionHandler) {
        this.suspend(timeout, attachment, competionHandler, null);
    }

    public void suspend(long timeout, A attachment, CompletionHandler<? super A> competionHandler, ResponseAttachment<A> ra) {
        if (this.isSuspended) {
            throw new IllegalStateException("Already Suspended");
        }
        this.isSuspended = true;
        if (ra == null) {
            ra = new ResponseAttachment<A>(timeout, attachment, competionHandler, this);
        }
        if (competionHandler == null) {
            competionHandler = new CompletionHandler(){

                public void resumed(Object attachment) {
                    if (LoggerUtils.getLogger().isLoggable(Level.FINE)) {
                        LoggerUtils.getLogger().fine(Response.this + " resumed" + attachment);
                    }
                }

                public void cancelled(Object attachment) {
                    if (LoggerUtils.getLogger().isLoggable(Level.FINE)) {
                        LoggerUtils.getLogger().fine(Response.this + " cancelled" + attachment);
                    }
                }
            };
            ((ResponseAttachment)ra).completionHandler = competionHandler;
        }
        this.ra = ra;
    }

    public ResponseAttachment getResponseAttachment() {
        return this.ra;
    }

    public void addResponseFilter(final ResponseFilter responseFilter) {
        if (!(this.outputBuffer instanceof InternalOutputBuffer)) {
            throw new IllegalStateException("Not Supported");
        }
        ((InternalOutputBuffer)this.outputBuffer).addLastOutputFilter(new VoidOutputFilter(){

            public int doWrite(ByteChunk chunk, Response res) throws IOException {
                responseFilter.filter(chunk);
                this.buffer.doWrite(chunk, res);
                return chunk.getLength();
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ResponseAttachment<A>
    implements SelectionKeyAttachment.KeySelectionListener,
    SelectionKeyAttachment.TimeOutListener {
        private volatile CompletionHandler<? super A> completionHandler;
        private final A attachment;
        private final Response response;
        private volatile long idleTimeoutDelay;
        private volatile boolean isAttached;
        protected volatile ThreadAttachment threadAttachment;

        protected ResponseAttachment(long idleTimeoutDelay, A attachment, CompletionHandler<? super A> completionHandler, Response response) {
            this.idleTimeoutDelay = idleTimeoutDelay;
            this.attachment = attachment;
            this.completionHandler = completionHandler;
            this.response = response;
        }

        public boolean isAttached() {
            return this.isAttached;
        }

        public void markAttached(boolean isAttached) {
            this.isAttached = isAttached;
        }

        public A getAttachment() {
            return this.attachment;
        }

        public CompletionHandler<? super A> getCompletionHandler() {
            return this.completionHandler;
        }

        public void resetTimeout() {
            ThreadAttachment localThreadAttachment = this.threadAttachment;
            if (localThreadAttachment != null) {
                localThreadAttachment.setTimeout(System.currentTimeMillis());
            }
        }

        public long getTimeout() {
            ThreadAttachment localThreadAttachment = this.threadAttachment;
            if (localThreadAttachment != null) {
                return localThreadAttachment.getTimeout();
            }
            return Long.MIN_VALUE;
        }

        public long getIdleTimeoutDelay() {
            return this.idleTimeoutDelay;
        }

        public void setIdleTimeoutDelay(long idleTimeoutDelay) {
            this.idleTimeoutDelay = idleTimeoutDelay;
        }

        void setThreadAttachment(ThreadAttachment threadAttachment) {
            this.threadAttachment = threadAttachment;
        }

        public void invokeCompletionHandler() {
            this.completionHandler.resumed(this.attachment);
        }

        public void resume() {
            block2: {
                this.invokeCompletionHandler();
                try {
                    this.response.sendHeaders();
                    this.response.flush();
                    this.response.finish();
                }
                catch (IOException ex) {
                    if (!LoggerUtils.getLogger().isLoggable(Level.FINE)) break block2;
                    LoggerUtils.getLogger().log(Level.FINEST, "resume", ex);
                }
            }
        }

        @Override
        public boolean onTimeOut(SelectionKey key) {
            SuspendResponseUtils.detach(key);
            this.run();
            return false;
        }

        public void run() {
            this.timeout(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onKeySelected(SelectionKey selectionKey) {
            if (!selectionKey.isValid() || discardDisconnectEvent) {
                selectionKey.cancel();
                return;
            }
            boolean connectionClosed = true;
            try {
                connectionClosed = ((SocketChannel)selectionKey.channel()).read(ByteBuffer.allocate(1)) == -1;
            }
            catch (IOException ex) {
                if (LoggerUtils.getLogger().isLoggable(Level.FINE)) {
                    LoggerUtils.getLogger().log(Level.FINEST, "handleSelectionKey", ex);
                }
            }
            finally {
                if (connectionClosed) {
                    this.completionHandler.cancelled(this.attachment);
                    selectionKey.cancel();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void timeout(boolean forceClose) {
            try {
                this.completionHandler.cancelled(this.attachment);
            }
            finally {
                if (forceClose && !this.response.isCommitted()) {
                    try {
                        this.response.sendHeaders();
                        this.response.flush();
                        this.response.finish();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

