/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.http;

import com.sun.grizzly.tcp.http11.OutputFilter;
import com.sun.grizzly.tcp.http11.filters.GzipOutputFilter;
import com.sun.grizzly.tcp.http11.filters.LzmaOutputFilter;
import com.sun.grizzly.util.buf.MessageBytes;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompressionFiltersProvider {
    private static final CompressionFiltersProvider instance = new CompressionFiltersProvider();
    private final TreeMap<Key, OutputFilter> outputFilters;
    private final AtomicInteger counter = new AtomicInteger();

    private CompressionFiltersProvider() {
        this.outputFilters = new TreeMap(new Comparator<Key>(){

            @Override
            public int compare(Key key1, Key key2) {
                return key1.id - key2.id;
            }
        });
        GzipOutputFilter gzipOutputFilter = new GzipOutputFilter();
        this.outputFilters.put(new Key(this.counter.getAndIncrement(), "gzip"), (OutputFilter)gzipOutputFilter);
        this.outputFilters.put(new Key(this.counter.getAndIncrement(), "deflate"), (OutputFilter)gzipOutputFilter);
        this.registerOutputFilter((OutputFilter)new LzmaOutputFilter());
    }

    public static CompressionFiltersProvider provider() {
        return instance;
    }

    public void registerOutputFilter(OutputFilter outputFilter) {
        this.outputFilters.put(new Key(this.counter.getAndIncrement(), outputFilter.getEncodingName().toString()), outputFilter);
    }

    public Collection<OutputFilter> getOutputFilters() {
        return this.outputFilters.values();
    }

    public boolean supportsOutput(String encoding) {
        return this.getOutputFilter(encoding) != null;
    }

    public boolean supportsOutput(MessageBytes encoding) {
        return this.getOutputFilter(encoding) != null;
    }

    public OutputFilter getOutputFilter(String encoding) {
        for (Map.Entry<Key, OutputFilter> entry : this.outputFilters.entrySet()) {
            if (encoding.indexOf(entry.getKey().encoding) == -1) continue;
            return entry.getValue();
        }
        return null;
    }

    public OutputFilter getOutputFilter(MessageBytes encoding) {
        for (Map.Entry<Key, OutputFilter> entry : this.outputFilters.entrySet()) {
            if (encoding.indexOf(entry.getKey().encoding) == -1) continue;
            return entry.getValue();
        }
        return null;
    }

    private static class Key {
        private final int id;
        private final String encoding;

        public Key(int id, String encoding) {
            this.id = id;
            this.encoding = encoding;
        }

        public int hashCode() {
            return this.id;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            return this.id == other.id;
        }
    }
}

