/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly;

import com.sun.grizzly.AbstractConnectorHandler;
import com.sun.grizzly.CallbackHandler;
import com.sun.grizzly.Controller;
import com.sun.grizzly.ControllerStateListenerAdapter;
import com.sun.grizzly.DefaultCallbackHandler;
import com.sun.grizzly.TCPSelectorHandler;
import com.sun.grizzly.util.InputReader;
import com.sun.grizzly.util.LogMessages;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCPConnectorHandler
extends AbstractConnectorHandler<TCPSelectorHandler, CallbackHandler> {
    private static final int DEFAULT_CONNECTION_TIMEOUT = 30000;
    private volatile CountDownLatch isConnectedLatch;
    private boolean isStandalone = false;
    protected boolean tcpNoDelay = true;
    protected boolean reuseAddress = true;
    protected int linger = -1;
    protected int connectionTimeout = 30000;

    public TCPConnectorHandler() {
        this.protocol(Controller.Protocol.TCP);
    }

    @Override
    public void connect(SocketAddress remoteAddress, SocketAddress localAddress, CallbackHandler callbackHandler, TCPSelectorHandler selectorHandler) throws IOException {
        if (this.isConnected) {
            throw new AlreadyConnectedException();
        }
        if (this.controller == null) {
            throw new IllegalStateException("Controller cannot be null");
        }
        if (selectorHandler == null) {
            throw new IllegalStateException("SelectorHandler cannot be null");
        }
        this.selectorHandler = selectorHandler;
        if (callbackHandler == null) {
            callbackHandler = new DefaultCallbackHandler(this);
        } else {
            this.callbackHandler = callbackHandler;
        }
        this.isConnectedLatch = new CountDownLatch(1);
        selectorHandler.connect(remoteAddress, localAddress, callbackHandler);
        this.inputStream = new InputReader();
        try {
            this.isConnectedLatch.await(this.connectionTimeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    @Override
    public void connect(SocketAddress remoteAddress, SocketAddress localAddress) throws IOException {
        if (this.isConnected) {
            throw new AlreadyConnectedException();
        }
        if (this.controller == null) {
            this.isStandalone = true;
            this.controller = new Controller();
            this.controller.setSelectorHandler(new TCPSelectorHandler(true));
            final CountDownLatch latch = new CountDownLatch(1);
            this.controller.addStateListener(new ControllerStateListenerAdapter(){

                public void onReady() {
                    latch.countDown();
                }

                public void onException(Throwable e) {
                    latch.countDown();
                }
            });
            this.callbackHandler = new DefaultCallbackHandler(this, false);
            this.controller.executeUsingKernelExecutor();
            try {
                latch.await();
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
        if (null == this.callbackHandler) {
            this.callbackHandler = new DefaultCallbackHandler(this);
        }
        this.connect(remoteAddress, localAddress, this.callbackHandler);
    }

    @Override
    public void close() throws IOException {
        if (this.underlyingChannel != null) {
            if (this.selectorHandler != null) {
                SelectionKey key = ((TCPSelectorHandler)this.selectorHandler).keyFor(this.underlyingChannel);
                if (key == null) {
                    return;
                }
                ((TCPSelectorHandler)this.selectorHandler).getSelectionKeyHandler().cancel(key);
            } else {
                this.underlyingChannel.close();
            }
        }
        if (this.controller != null && this.isStandalone) {
            this.controller.stop();
            this.controller = null;
        }
        this.isStandalone = false;
        this.isConnected = false;
        this.connectionTimeout = 30000;
    }

    @Override
    public void finishConnect(SelectionKey key) throws IOException {
        try {
            if (Controller.logger().isLoggable(Level.FINE)) {
                Controller.logger().log(Level.FINE, "Finish connect");
            }
            SocketChannel socketChannel = (SocketChannel)key.channel();
            this.underlyingChannel = socketChannel;
            socketChannel.finishConnect();
            this.isConnected = socketChannel.isConnected();
            this.configureChannel(socketChannel);
            if (Controller.logger().isLoggable(Level.FINE)) {
                Controller.logger().log(Level.FINE, "isConnected: " + this.isConnected);
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            this.isConnectedLatch.countDown();
        }
    }

    public void configureChannel(SelectableChannel channel) throws IOException {
        Socket socket = ((SocketChannel)channel).socket();
        try {
            if (this.linger >= 0) {
                socket.setSoLinger(true, this.linger);
            }
        }
        catch (SocketException ex) {
            Controller.logger().log(Level.WARNING, LogMessages.WARNING_GRIZZLY_CONNECTOR_HANDLER_LINGER_EXCEPTION(), ex);
        }
        try {
            socket.setTcpNoDelay(this.tcpNoDelay);
        }
        catch (SocketException ex) {
            Controller.logger().log(Level.WARNING, LogMessages.WARNING_GRIZZLY_CONNECTOR_HANDLER_TCPNODELAY_EXCEPTION(), ex);
        }
        try {
            socket.setReuseAddress(this.reuseAddress);
        }
        catch (SocketException ex) {
            Controller.logger().log(Level.WARNING, LogMessages.WARNING_GRIZZLY_CONNECTOR_HANDLER_REUSEADDRESS_EXCEPTION(), ex);
        }
    }

    @Override
    public final Controller.Protocol protocol() {
        return Controller.Protocol.TCP;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public int getLinger() {
        return this.linger;
    }

    public void setLinger(int linger) {
        this.linger = linger;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public boolean isReuseAddress() {
        return this.reuseAddress;
    }

    public void setReuseAddress(boolean reuseAddress) {
        this.reuseAddress = reuseAddress;
    }
}

