/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.layout.template;

import com.sun.jsftemplating.layout.SyntaxException;
import com.sun.jsftemplating.layout.descriptors.handler.OutputTypeManager;
import com.sun.jsftemplating.layout.template.NameValuePair;
import com.sun.jsftemplating.util.IncludeInputStream;
import com.sun.jsftemplating.util.LogUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateParser {
    public static final String SIMPLE_WHITE_SPACE = " \t\r\n";
    private URL _url = null;
    private InputStream _inputStream = null;
    private transient BufferedReader _reader = null;
    private transient Stack<Character> _stack = null;

    public TemplateParser(URL url) {
        this._url = url;
    }

    public TemplateParser(InputStream stream) {
        this._inputStream = stream;
    }

    public URL getURL() {
        return this._url;
    }

    public InputStream getInputStream() throws IOException {
        if (this._inputStream == null && this._url != null) {
            this._inputStream = this.getURL().openStream();
        }
        return this._inputStream;
    }

    public void open() throws IOException {
        if (this._reader != null) {
            this.close();
        }
        this._reader = new BufferedReader(new InputStreamReader(new IncludeInputStream(new BufferedInputStream(this.getInputStream()))));
        this._stack = new Stack();
    }

    public void close() {
        block3: {
            try {
                if (this._reader != null) {
                    this._reader.close();
                }
            }
            catch (Exception ex) {
                if (!LogUtil.configEnabled(this)) break block3;
                LogUtil.config("Exception while closing stream for url: '" + this.getURL() + "'.", ex);
            }
        }
    }

    public int nextChar() throws IOException {
        if (!this._stack.empty()) {
            return this._stack.pop().charValue();
        }
        return this._reader.read();
    }

    public void unread(int ch) {
        this._stack.push(new Character((char)ch));
    }

    public NameValuePair getNVP(String defName) throws IOException {
        return this.getNVP(defName, true);
    }

    public NameValuePair getNVP(String defName, boolean requireQuotes) throws IOException {
        return this.getNVP(defName, requireQuotes, "_.");
    }

    public NameValuePair getNVP(String defName, boolean requireQuotes, String otherChars) throws IOException {
        String name = this.readToken(otherChars);
        Object value = null;
        if (name.length() == 0 && defName != null) {
            name = defName;
            this.unread(61);
        }
        this.skipCommentsAndWhiteSpace(SIMPLE_WHITE_SPACE);
        int next = this.nextChar();
        if (next != 61 && next != 58) {
            if (!requireQuotes && !name.equals(defName)) {
                value = name;
                name = defName;
                this.unread(next);
                this.unread(102);
            } else {
                throw new SyntaxException("'=' or ':' missing for Name Value Pair: '" + name + "'!");
            }
        }
        this.skipCommentsAndWhiteSpace(SIMPLE_WHITE_SPACE);
        String target = null;
        int endingChar = -1;
        next = this.nextChar();
        switch (next) {
            case 62: {
                if (!requireQuotes) {
                    this.unread(next);
                    value = "";
                    break;
                }
                this.skipCommentsAndWhiteSpace(SIMPLE_WHITE_SPACE);
                next = this.nextChar();
                if (next != 36) {
                    throw new SyntaxException("'$' missing for Name Value Pair named: '" + name + "=>'!  This NVP appears to be a mapping expression, " + "therefor requires a format similar to:\n\t" + name + " => $attribute{attKey}\nor:\n\t" + name + " => $application{applicationKey}\nor:\n\t" + name + " => $session{sessionKey}\nor:\n\t" + name + " => $pageSession{pageSessionKey}");
                }
                target = this.readToken();
                OutputTypeManager otm = OutputTypeManager.getInstance();
                if (otm.getOutputType(null, target) == null) {
                    throw new SyntaxException("Invalid OutputType ('" + target + "') for Name Value " + "Pair named: '" + name + "=>$" + target + "{...}'!  " + "This NVP appears to be a mapping expression, " + "therefor requires a format similar to:\n\t" + name + " => $attribute{attKey}\nor:\n\t" + name + " => $application{applicationKey}\nor:\n\t" + name + " => $session{sessionKey}\nor:\n\t" + name + " => $pageSession{pageSessionKey}");
                }
                this.skipCommentsAndWhiteSpace(SIMPLE_WHITE_SPACE);
                next = this.nextChar();
                if (next != 123) {
                    throw new SyntaxException("'{' missing for Name Value Pair: '" + name + "=>$" + target + "'!  The format must resemble the following:\n\t" + name + " => $" + target + "{key}");
                }
                endingChar = 125;
                break;
            }
            case 123: {
                value = this.parseList(125);
                break;
            }
            case 91: {
                value = this.parseList(93).toArray();
                break;
            }
            case 34: 
            case 39: {
                endingChar = next;
                break;
            }
            case 102: {
                if (value != null && value.toString().length() > 0) {
                    next = this.nextChar();
                }
            }
            default: {
                if (!requireQuotes) {
                    this.unread(next);
                    String strVal = this.readUntil(62, true);
                    this.unread(62);
                    if (strVal.endsWith("/")) {
                        strVal = strVal.substring(0, strVal.length() - 1).trim();
                        this.unread(47);
                    }
                    value = value == null ? strVal : value.toString() + strVal;
                    break;
                }
                throw new SyntaxException("Name Value Pair named '" + name + "' is missing single or double quotes enclosing " + "its value.  It must follow one of these formats:\n\t" + name + "=\"value\"\nor:\n\t" + name + "='value'");
            }
        }
        if (endingChar != -1) {
            value = this.readUntil(endingChar, false);
        }
        return new NameValuePair(name, value, target);
    }

    protected List<String> parseList(int endChar) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        this.skipCommentsAndWhiteSpace(SIMPLE_WHITE_SPACE);
        int next = this.nextChar();
        while (next != endChar) {
            if (next != 39 && next != 34) {
                throw new IllegalArgumentException("A List or array is missing a single or double quotes enclosing one or more of its values.  It must follow:\n\tname={\"value\", ...}\nor:\n\tname={'value',...}\n\n[]'s may be used in place of {}'s to specify an array instead of a List.");
            }
            list.add(this.readUntil(next, false));
            this.skipCommentsAndWhiteSpace(" \t\r\n,:;");
            next = this.nextChar();
        }
        return list;
    }

    public String readToken() throws IOException {
        return this.readToken("_:.");
    }

    public String readToken(String otherChars) throws IOException {
        if (otherChars == null) {
            otherChars = "";
        }
        StringBuffer buf = new StringBuffer();
        int next = this.nextChar();
        while (Character.isLetterOrDigit(next) || otherChars.indexOf(next) != -1) {
            buf.append((char)next);
            next = this.nextChar();
        }
        this.unread(next);
        return buf.toString();
    }

    public String readUntil(int endingChar, boolean skipComments) throws IOException {
        if (skipComments) {
            this.skipCommentsAndWhiteSpace("");
        }
        int next = this.nextChar();
        StringBuffer buf = new StringBuffer();
        while (next != endingChar && next != -1) {
            switch (next) {
                case 34: 
                case 39: {
                    if (skipComments && next != endingChar) {
                        buf.append((char)next);
                        buf.append(this.readUntil(next, false));
                        buf.append((char)next);
                        break;
                    }
                    buf.append((char)next);
                    break;
                }
                case 35: 
                case 47: 
                case 60: {
                    if (skipComments) {
                        this.unread(next);
                        this.skipCommentsAndWhiteSpace("");
                        int tmpch = this.nextChar();
                        if (next == tmpch) {
                            buf.append((char)next);
                            break;
                        }
                        this.unread(tmpch);
                        break;
                    }
                    buf.append((char)next);
                    break;
                }
                case 92: {
                    next = this.nextChar();
                    if (next == 110) {
                        buf.append('\n');
                        break;
                    }
                    if (next != 9) {
                        buf.append('\t');
                        break;
                    }
                    if (next == 10) break;
                    buf.append((char)next);
                    break;
                }
                default: {
                    buf.append((char)next);
                }
            }
            next = this.nextChar();
        }
        return buf.toString();
    }

    public String readUntil(String endingStr, boolean skipComments) throws IOException {
        int cnt;
        if (endingStr == null || endingStr.length() == 0) {
            return "";
        }
        char[] arr = endingStr.toCharArray();
        int arrlen = arr.length;
        StringBuffer buf = new StringBuffer("");
        int ch = this.nextChar();
        int idx = 1;
        do {
            this.unread(ch);
            for (cnt = idx - 1; cnt > 0; --cnt) {
                this.unread(arr[cnt]);
            }
            buf.append(this.readUntil(arr[0], skipComments));
            buf.append(arr[0]);
            for (idx = 1; idx < arrlen && (ch = this.nextChar()) == arr[idx]; ++idx) {
            }
        } while (ch != -1 && idx < arrlen);
        for (cnt = 1; cnt < idx; ++cnt) {
            buf.append(arr[cnt]);
        }
        if (arrlen != idx) {
            throw new SyntaxException("Unable to find: '" + endingStr + "'.  Read to EOF and gave up.  Read: \n" + buf.toString());
        }
        return buf.toString();
    }

    public void skipWhiteSpace(String skipChars) throws IOException {
        int next = this.nextChar();
        while (next != -1 && skipChars.indexOf(next) != -1) {
            next = this.nextChar();
        }
        this.unread(next);
    }

    public void skipCommentsAndWhiteSpace(String skipChars) throws IOException {
        int ch = 0;
        block6: while (ch != -1) {
            ch = this.nextChar();
            switch (ch) {
                case 35: {
                    this.readLine();
                    continue block6;
                }
                case 47: {
                    ch = this.nextChar();
                    if (ch == 47) {
                        this.readLine();
                        continue block6;
                    }
                    if (ch == 42) {
                        this.readUntil("*/", false);
                        continue block6;
                    }
                    this.unread(ch);
                    this.unread(47);
                    ch = -1;
                    continue block6;
                }
                case 60: {
                    ch = this.nextChar();
                    if (ch == 33) {
                        ch = this.nextChar();
                        if (ch == 45) {
                            ch = this.nextChar();
                            if (ch == 45) {
                                this.readUntil("-->", false);
                                continue block6;
                            }
                            this.unread(ch);
                            this.unread(45);
                            this.unread(33);
                            this.unread(60);
                            throw new IllegalArgumentException("Invalid comment!  Expected comment to begin with \"<!--\", but found: " + this.readLine());
                        }
                        this.unread(ch);
                        this.unread(33);
                        this.unread(60);
                        ch = -1;
                        continue block6;
                    }
                    this.unread(ch);
                    this.unread(60);
                    ch = -1;
                    continue block6;
                }
                case -1: {
                    continue block6;
                }
            }
            if (skipChars.indexOf(ch) != -1) continue;
            this.unread(ch);
            ch = -1;
        }
    }

    public String readLine() throws IOException {
        StringBuffer buf = new StringBuffer();
        int ch = -1;
        while (!this._stack.empty()) {
            ch = this._stack.pop().charValue();
            if (ch == 13 || ch == 10) {
                if (!(this._stack.empty() || (ch = (int)this._stack.peek().charValue()) != 13 && ch != 10)) {
                    this._stack.pop().charValue();
                }
                return buf.toString();
            }
            buf.append((char)ch);
        }
        buf.append(this._reader.readLine());
        int idx = buf.indexOf("\\n");
        while (idx != -1) {
            buf.replace(idx, idx + 2, "\n");
            idx = buf.indexOf("\\n", idx + 1);
        }
        int lastChar = buf.length() - 1;
        if (lastChar >= 0 && buf.charAt(lastChar) == '\\') {
            buf.deleteCharAt(lastChar);
            buf.append(this.readLine());
        }
        return buf.toString();
    }
}

