/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mojarra.scales.util;

import com.sun.mojarra.scales.util.StaticResourcePhaseListener;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScalesUtil {
    private static final String INVOCATION_PATH = "com.sun.mojarra.scales.INVOCATION_PATH";
    private static String[] passthruAttributes = new String[]{"accept", "accesskey", "alt", "bgcolor", "border", "cellpadding", "cellspacing", "charset", "cols", "coords", "dir", "enctype", "frame", "height", "hreflang", "lang", "longdesc", "maxlength", "onblur", "onchange", "onclick", "ondblclick", "onfocus", "onkeydown", "onkeypress", "onkeyup", "onload", "onmousedown", "onmousemove", "onmouseout", "onmouseover", "onmouseup", "onreset", "onselect", "onsubmit", "onunload", "rel", "rev", "rows", "rules", "shape", "size", "style", "summary", "tabindex", "target", "title", "usemap", "width"};

    private ScalesUtil() {
    }

    public static String getFacesMapping(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("The FacesContext was null.");
        }
        ExternalContext extContext = context.getExternalContext();
        String mapping = (String)extContext.getRequestMap().get(INVOCATION_PATH);
        if (mapping == null) {
            Object request = extContext.getRequest();
            String servletPath = null;
            String pathInfo = null;
            if (request instanceof HttpServletRequest) {
                servletPath = extContext.getRequestServletPath();
                pathInfo = extContext.getRequestPathInfo();
            }
            mapping = ScalesUtil.getMappingForRequest(servletPath, pathInfo);
        }
        if (mapping != null) {
            extContext.getRequestMap().put(INVOCATION_PATH, mapping);
        }
        return mapping;
    }

    public static ValueExpression createValueExpression(String valueRef, Class type) {
        FacesContext fc = FacesContext.getCurrentInstance();
        ELContext elc = fc.getELContext();
        return fc.getApplication().getExpressionFactory().createValueExpression(elc, valueRef, Object.class);
    }

    public static boolean isPrefixMapped(String mapping) {
        return mapping.charAt(0) == '/';
    }

    public static void renderPassThruAttributes(ResponseWriter writer, UIComponent component) throws IOException {
        ScalesUtil.renderPassThruAttributes(writer, component, null);
    }

    public static void renderPassThruAttributes(ResponseWriter writer, UIComponent component, String[] excludes) throws IOException {
        int i = 0;
        int len = passthruAttributes.length;
        int jLen = null != excludes ? excludes.length : 0;
        Object value = null;
        boolean skip = false;
        for (i = 0; i < len; ++i) {
            skip = false;
            if (null != excludes) {
                for (int j = 0; j < jLen; ++j) {
                    if (null == excludes[j] || !excludes[j].equals(passthruAttributes[i])) continue;
                    skip = true;
                    break;
                }
            }
            if (skip || (value = (Object)component.getAttributes().get(passthruAttributes[i])) == null || !ScalesUtil.shouldRenderAttribute(value)) continue;
            if (!(value instanceof String)) {
                value = value.toString();
            }
            writer.writeAttribute(passthruAttributes[i], value, passthruAttributes[i]);
        }
    }

    public static String getMappingForRequest(String servletPath, String pathInfo) {
        if (servletPath == null) {
            return null;
        }
        if (servletPath.length() == 0) {
            return "/*";
        }
        if (pathInfo != null) {
            return servletPath;
        }
        if (servletPath.indexOf(46) < 0) {
            return servletPath;
        }
        return servletPath.substring(servletPath.lastIndexOf(46));
    }

    protected static boolean shouldRenderAttribute(Object attributeVal) {
        if (attributeVal instanceof Boolean && ((Boolean)attributeVal).booleanValue() == Boolean.FALSE.booleanValue()) {
            return false;
        }
        if (attributeVal instanceof Integer && (Integer)attributeVal == Integer.MIN_VALUE) {
            return false;
        }
        if (attributeVal instanceof Double && (Double)attributeVal == Double.MIN_VALUE) {
            return false;
        }
        if (attributeVal instanceof Character && ((Character)attributeVal).charValue() == '\u0000') {
            return false;
        }
        if (attributeVal instanceof Float && ((Float)attributeVal).floatValue() == Float.MIN_VALUE) {
            return false;
        }
        if (attributeVal instanceof Short && (Short)attributeVal == Short.MIN_VALUE) {
            return false;
        }
        if (attributeVal instanceof Byte && (Byte)attributeVal == -128) {
            return false;
        }
        return !(attributeVal instanceof Long) || (Long)attributeVal != Long.MIN_VALUE;
    }

    public static void appendToConfig(StringBuilder config, String key, Object value, boolean quote, boolean needsComma) {
        config.append(needsComma ? "," : "").append(key).append(":");
        if (quote) {
            config.append("'");
        }
        config.append(value.toString());
        if (quote) {
            config.append("'");
        }
    }

    public static void appendToConfigIfNotNull(StringBuilder config, String key, Object value, boolean quote, boolean needsComma) {
        if (value != null) {
            ScalesUtil.appendToConfig(config, key, value, quote, needsComma);
        }
    }

    public static ResourceBundle getBundle(String baseName, String localeName, Class fallback) {
        ResourceBundle bundle = null;
        try {
            if (localeName == null) {
                localeName = "en_US";
            }
            Locale locale = new Locale("en", "US");
            String language = localeName;
            String country = null;
            String variant = null;
            int countryIndex = language.indexOf("_");
            if (countryIndex > -1) {
                language = localeName.substring(0, countryIndex);
                int variantIndex = localeName.indexOf("-");
                if (variantIndex > -1) {
                    country = localeName.substring(countryIndex + 1, variantIndex);
                    variant = localeName.substring(variantIndex + 1);
                    locale = new Locale(language, country, variant);
                } else {
                    country = localeName.substring(countryIndex + 1);
                    locale = new Locale(language, country);
                }
            } else {
                locale = new Locale(localeName);
            }
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (loader == null && fallback != null) {
                loader = fallback.getClass().getClassLoader();
            }
            bundle = ResourceBundle.getBundle(baseName, locale, loader);
        }
        catch (MissingResourceException ex) {
            Logger.getLogger(fallback.getName()).warning("Can't find bundle: " + baseName);
            ex.printStackTrace();
        }
        return bundle;
    }

    @Deprecated
    public static <V> V getPropertyValue(UIComponent comp, V field, String attributeName, V defaultValue) {
        if (field != null) {
            return field;
        }
        ValueExpression ve = comp.getValueExpression(attributeName);
        return (V)(ve != null ? ve.getValue(FacesContext.getCurrentInstance().getELContext()) : defaultValue);
    }

    public static String createResourceUrl(FacesContext context, String path) {
        return StaticResourcePhaseListener.createResourceUrl(context, path);
    }

    public static String getStaticResourceUrl(FacesContext fc, String path) {
        String url = fc.getExternalContext().getRequestContextPath() + ScalesUtil.createResourceUrl(fc, path);
        return url;
    }

    public static String formatDate(Date date, String format, Boolean useDefault) {
        String formattedDate = "";
        if (date != null || useDefault.booleanValue()) {
            if (date == null) {
                date = new Date();
            }
            formattedDate = date != null ? new SimpleDateFormat(format).format(date) : new SimpleDateFormat(format).format(new Date());
        }
        return formattedDate;
    }
}

