/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mojarra.scales.component;

import com.sun.mojarra.scales.component.Links;
import com.sun.mojarra.scales.util.CssUtil;
import com.sun.mojarra.scales.util.RenderingHelper;
import com.sun.mojarra.scales.util.ScalesUtil;
import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class ColorPicker
extends UIInput {
    public static final String COMPONENT_FAMILY = "com.sun.mojarra.scales.component.ColorPicker";
    public static final String RENDERER_TYPE = "com.sun.mojarra.scales.component.ColorPicker";
    public static final String COMPONENT_TYPE = "com.sun.mojarra.scales.component.ColorPicker";
    private boolean showControls = true;
    private boolean showHexControls = true;
    private boolean showHexSummary = true;
    private boolean showHsvControls = false;
    private boolean showRgbControls = true;
    private boolean showWebSafe = true;
    private String backgroundColor = "#eeeeee";
    private String style = "";
    private String styleClass = "";
    private Object[] _state = null;

    public ColorPicker() {
        this.setRendererType("com.sun.mojarra.scales.component.ColorPicker");
        FacesContext context = FacesContext.getCurrentInstance();
        if (context != null) {
            String baseUrl = context.getExternalContext().getRequestContextPath();
            Links.addCss("SCALES_EXTERNAL_STYLESHEETS", baseUrl + ScalesUtil.createResourceUrl(context, "/yui/assets/skins/sam/colorpicker.css"));
            Links.addScript("SCALES_EXTERNAL_SCRIPTS", baseUrl + ScalesUtil.createResourceUrl(context, "/yui/slider/slider-min.js"));
            Links.addScript("SCALES_EXTERNAL_SCRIPTS", baseUrl + ScalesUtil.createResourceUrl(context, "/yui/colorpicker/colorpicker-min.js"));
            CssUtil.linkColorPickerOverrides(context);
        }
    }

    public String getFamily() {
        return "com.sun.mojarra.scales.component.ColorPicker";
    }

    public Object saveState(FacesContext context) {
        if (this._state == null) {
            this._state = new Object[10];
        }
        this._state[0] = super.saveState(context);
        this._state[1] = this.showControls;
        this._state[2] = this.showHexControls;
        this._state[3] = this.showHexSummary;
        this._state[4] = this.showHsvControls;
        this._state[5] = this.showRgbControls;
        this._state[6] = this.showWebSafe;
        this._state[7] = this.backgroundColor;
        this._state[8] = this.style;
        this._state[9] = this.styleClass;
        return this._state;
    }

    public void restoreState(FacesContext context, Object state) {
        this._state = (Object[])state;
        super.restoreState(context, this._state[0]);
        this.showControls = (Boolean)this._state[1];
        this.showHexControls = (Boolean)this._state[2];
        this.showHexSummary = (Boolean)this._state[3];
        this.showHsvControls = (Boolean)this._state[4];
        this.showRgbControls = (Boolean)this._state[5];
        this.showWebSafe = (Boolean)this._state[6];
        this.backgroundColor = (String)this._state[7];
        this.style = (String)this._state[8];
        this.styleClass = (String)this._state[9];
    }

    public void encodeBegin(FacesContext context) throws IOException {
        super.encodeBegin(context);
        if (!this.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        String clientId = this.getClientId(context);
        Map attrs = this.getAttributes();
        writer.startElement("span", (UIComponent)this);
        writer.writeAttribute("class", attrs.get("styleClass"), "class");
        writer.writeAttribute("style", attrs.get("style"), "style");
        RenderingHelper.outputElement(writer, (UIComponent)this, "div", new String[][]{{"id", clientId}, {"class", (String)attrs.get("styleClass")}, {"style", "position: relative; padding: 6px; background-color: #" + (String)attrs.get("backgroundColor") + "; width: 420px; height:220px; " + (String)attrs.get("style") + "}"}});
        RenderingHelper.writeOnDomReady(writer, "scales.createColorPicker('" + clientId + "', {" + this.buildConfig(context) + "});");
    }

    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public boolean isShowControls() {
        return this.showControls;
    }

    public void setShowControls(boolean showControls) {
        this.showControls = showControls;
    }

    public boolean isShowHexControls() {
        return this.showHexControls;
    }

    public void setShowHexControls(boolean showHexControls) {
        this.showHexControls = showHexControls;
    }

    public boolean isShowHexSummary() {
        return this.showHexSummary;
    }

    public void setShowHexSummary(boolean showHexSummary) {
        this.showHexSummary = showHexSummary;
    }

    public boolean isShowHsvControls() {
        return this.showHsvControls;
    }

    public void setShowHsvControls(boolean showHsvControls) {
        this.showHsvControls = showHsvControls;
    }

    public boolean isShowRgbControls() {
        return this.showRgbControls;
    }

    public void setShowRgbControls(boolean showRgbControls) {
        this.showRgbControls = showRgbControls;
    }

    public boolean isShowWebSafe() {
        return this.showWebSafe;
    }

    public void setShowWebSafe(boolean showWebSafe) {
        this.showWebSafe = showWebSafe;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getStyleClass() {
        return this.styleClass;
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    protected String buildConfig(FacesContext context) {
        StringBuilder builder = new StringBuilder();
        Map attrs = this.getAttributes();
        String baseUrl = ScalesUtil.getStaticResourceUrl(context, "");
        String value = (String)attrs.get("value");
        ScalesUtil.appendToConfig(builder, "showcontrols", (Boolean)attrs.get("showControls"), false, false);
        ScalesUtil.appendToConfig(builder, "showhexcontrols", (Boolean)attrs.get("showHexControls"), false, true);
        ScalesUtil.appendToConfig(builder, "showhexsummary", (Boolean)attrs.get("showHexSummary"), false, true);
        ScalesUtil.appendToConfig(builder, "showhsvcontrols", (Boolean)attrs.get("showHsvControls"), false, true);
        ScalesUtil.appendToConfig(builder, "showrgbcontrols", (Boolean)attrs.get("showRgbControls"), false, true);
        ScalesUtil.appendToConfig(builder, "showwebsafe", (Boolean)attrs.get("showWebSafe"), false, true);
        ScalesUtil.appendToConfig(builder, "images", "{PICKER_THUMB: '" + baseUrl + "yui/colorpicker/assets/picker_thumb.png',HUE_THUMB: '" + baseUrl + "yui/colorpicker/assets/hue_thumb.png'}", false, true);
        if (value != null) {
            this.addRgbToConfig(builder, value);
        }
        return builder.toString();
    }

    public void decode(FacesContext facesContext) {
        Map requestMap = facesContext.getExternalContext().getRequestParameterMap();
        this.setSubmittedValue((String)requestMap.get("yui-picker-hex"));
    }

    protected void addRgbToConfig(StringBuilder builder, String color) {
        String blue;
        String green;
        String red;
        if (color == null) {
            return;
        }
        if (color.startsWith("#")) {
            color = color.substring(1);
        }
        if (color.length() == 3) {
            red = color.substring(0, 1) + color.substring(0, 1);
            green = color.substring(1, 2) + color.substring(1, 2);
            blue = color.substring(2, 3) + color.substring(2, 3);
        } else {
            red = color.substring(0, 2);
            green = color.substring(2, 4);
            blue = color.substring(4, 6);
        }
        ScalesUtil.appendToConfig(builder, "red", Integer.parseInt(red, 16), false, true);
        ScalesUtil.appendToConfig(builder, "green", Integer.parseInt(green, 16), false, true);
        ScalesUtil.appendToConfig(builder, "blue", Integer.parseInt(blue, 16), false, true);
    }
}

