/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mojarra.scales.renderer;

import com.sun.mojarra.scales.component.FileDownload;
import com.sun.mojarra.scales.renderer.AbstractRenderer;
import com.sun.mojarra.scales.util.ScalesUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.servlet.http.HttpServletRequest;

public class FileDownloadRenderer
extends AbstractRenderer {
    protected Object oldBinding = null;

    public boolean getRendersChildren() {
        return false;
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (context == null) {
            throw new NullPointerException("param 'context' is null");
        }
        if (component == null) {
            throw new NullPointerException("param 'component' is null");
        }
        if (!component.isRendered()) {
            return;
        }
        FileDownload dl = (FileDownload)component;
        super.encodeBegin(context, component);
        Map attrs = dl.getAttributes();
        if (attrs.get("urlVar") != null || component.getChildCount() > 0) {
            this.setElValue(context, dl);
        }
        if ("download".equals(attrs.get("method"))) {
            this.renderLink(context, dl);
        }
    }

    protected void setElValue(FacesContext context, FileDownload comp) {
        ValueExpression ve = ScalesUtil.createValueExpression("#{" + (String)comp.getAttributes().get("urlVar") + "}", FileDownload.class);
        ve.setValue(context.getELContext(), (Object)this.generateUri(context, comp));
    }

    protected void resetElValue(FacesContext context, FileDownload comp) {
        ValueExpression ve = ScalesUtil.createValueExpression("#{" + (String)comp.getAttributes().get("urlVar") + "}", FileDownload.class);
        ve.setValue(context.getELContext(), null);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (context == null) {
            throw new NullPointerException("param 'context' is null");
        }
        if (component == null) {
            throw new NullPointerException("param 'component' is null");
        }
        if (!component.isRendered()) {
            return;
        }
        FileDownload dl = (FileDownload)component;
        Map attrs = dl.getAttributes();
        if ("inline".equals((String)attrs.get("method"))) {
            this.renderInline(context, dl);
        } else if ("download".equals((String)attrs.get("method"))) {
            ResponseWriter writer = context.getResponseWriter();
            writer.endElement("a");
        }
        HttpServletRequest request = (HttpServletRequest)context.getExternalContext().getRequest();
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("filename", (String)attrs.get("fileName"));
        data.put("method", (String)attrs.get("method"));
        data.put("data", (String)attrs.get("data"));
        data.put("mimetype", (String)attrs.get("mimeType"));
        request.getSession().setAttribute("HtmlDownload-" + dl.getClientId(context), data);
        this.resetElValue(context, dl);
        super.encodeEnd(context, component);
    }

    protected void renderInline(FacesContext context, FileDownload comp) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Map attrs = comp.getAttributes();
        String uri = context.getExternalContext().getRequestContextPath() + this.generateUri(context, comp);
        if (Boolean.TRUE.equals((Boolean)attrs.get("iframe"))) {
            writer.startElement("iframe", (UIComponent)comp);
            writer.writeURIAttribute("src", (Object)uri, "src");
            ScalesUtil.renderPassThruAttributes(writer, (UIComponent)comp);
            writer.endElement("iframe");
        } else {
            writer.startElement("object", (UIComponent)comp);
            writer.writeURIAttribute("data", (Object)uri, "data");
            writer.writeAttribute("type", (Object)((String)attrs.get("mimeType")), "type");
            ScalesUtil.renderPassThruAttributes(writer, (UIComponent)comp);
            writer.endElement("object");
        }
    }

    protected void renderLink(FacesContext context, FileDownload comp) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("a", (UIComponent)comp);
        writer.writeURIAttribute("href", (Object)(context.getExternalContext().getRequestContextPath() + this.generateUri(context, comp)), "data");
        ScalesUtil.renderPassThruAttributes(writer, (UIComponent)comp);
        if (comp.getChildCount() <= 0) {
            writer.writeText((Object)((String)comp.getAttributes().get("text")), null);
        }
    }

    protected String generateUri(FacesContext context, FileDownload comp) {
        StringBuilder url = new StringBuilder();
        url.append(ScalesUtil.createResourceUrl(context, comp.getClientId(context))).append("&appResource=true");
        for (UIComponent child : comp.getChildren()) {
            if (!(child instanceof UIParameter)) continue;
            UIParameter param = (UIParameter)child;
            String name = param.getName();
            String value = "";
            try {
                value = URLEncoder.encode(param.getValue().toString(), "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                Logger.getLogger(FileDownloadRenderer.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (name == null || "".equals(name)) continue;
            url.append("&").append(name).append("=").append(value);
        }
        return url.toString();
    }
}

