/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.glassfish.admin.amx.core.AMXProxy;
import org.glassfish.admin.amx.intf.config.Config;
import org.glassfish.admin.amx.intf.config.HttpService;
import org.glassfish.admin.amx.intf.config.VirtualServer;
import org.glassfish.admin.amx.intf.config.grizzly.NetworkConfig;
import org.glassfish.admin.amx.intf.config.grizzly.NetworkListener;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.V3AMX;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class V3AMXUtil {
    public static Integer getAdminPort() {
        String port = (String)V3AMX.getAttrsMap("v3:pp=/domain/configs/config[server-config]/network-config/network-listeners,type=network-listener,name=admin-listener").get("Port");
        if (port.startsWith("$")) {
            port = "4848";
        }
        return Integer.valueOf(port);
    }

    public static String getHttpPortNumber(String serverName, String configName) {
        StringBuffer ports = new StringBuffer();
        try {
            Config config = V3AMX.getServerConfig(configName);
            Map nls = ((NetworkConfig)config.getNetworkConfig().as(NetworkConfig.class)).getNetworkListeners().getNetworkListener();
            for (NetworkListener listener : nls.values()) {
                String port = (String)listener.attributesMap().get("Port");
                ports = ports.append("," + port);
            }
            if (ports.length() > 0) {
                ports.deleteCharAt(0);
            }
            return ports.toString();
        }
        catch (Exception ex) {
            return "";
        }
    }

    public static String getPortForApplication(String appName) {
        try {
            String vsId;
            String objectNameStr = "v3:pp=/domain/servers,type=server,name=server";
            AMXProxy server = V3AMX.objectNameToProxy(objectNameStr);
            AMXProxy appRef = (AMXProxy)server.childrenMap("application-ref").get(appName);
            NetworkListener listener = null;
            listener = appRef == null ? V3AMXUtil.getListener() : ((vsId = (String)appRef.attributesMap().get("VirtualServers")) == null || vsId.length() == 0 ? V3AMXUtil.getListener() : V3AMXUtil.getListener(vsId));
            if (listener == null) {
                return null;
            }
            String port = (String)listener.attributesMap().get("Port");
            String security = (String)listener.findProtocol().attributesMap().get("SecurityEnabled");
            return "true".equals(security) ? "-" + port : port;
        }
        catch (Exception ex) {
            GuiUtil.getLogger().warning(ex.getMessage());
            return "";
        }
    }

    private static NetworkListener getListener() {
        Map vsMap = V3AMX.getServerConfig("server-config").getHttpService().getVirtualServer();
        return V3AMXUtil.getOneVsWithNetworkListener(new ArrayList<String>(vsMap.keySet()));
    }

    private static NetworkListener getListener(String vsIds) {
        return V3AMXUtil.getOneVsWithNetworkListener(GuiUtil.parseStringList(vsIds, ","));
    }

    private static NetworkListener getOneVsWithNetworkListener(List<String> vsList) {
        if (vsList == null || vsList.size() == 0) {
            return null;
        }
        NetworkListener secureListener = null;
        HttpService hConfig = V3AMX.getServerConfig("server-config").getHttpService();
        Map vsMap = V3AMX.getServerConfig("server-config").getHttpService().getVirtualServer();
        for (String vsName : vsList) {
            VirtualServer vs;
            String listener;
            if (vsName.equals("__asadmin") || GuiUtil.isEmpty(listener = (String)(vs = (VirtualServer)vsMap.get(vsName)).attributesMap().get("NetworkListeners"))) continue;
            List hpList = GuiUtil.parseStringList(listener, ",");
            for (String one : hpList) {
                NetworkListener oneListener = (NetworkListener)((NetworkConfig)V3AMX.getServerConfig("server-config").getNetworkConfig().as(NetworkConfig.class)).getNetworkListeners().getNetworkListener().get(one);
                if (!"true".equals(oneListener.attributesMap().get("Enabled"))) continue;
                String security = (String)oneListener.findProtocol().attributesMap().get("SecurityEnabled");
                if ("true".equals(security)) {
                    secureListener = oneListener;
                    continue;
                }
                return oneListener;
            }
        }
        return secureListener;
    }
}

