/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.security.admingui.handlers;

import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.servlet.http.HttpServletRequest;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.V3AMX;

public class FileUserHandler {
    public static void saveUser(HandlerContext handlerCtx) {
        try {
            String realmName = (String)handlerCtx.getInputValue("Realm");
            String grouplist = (String)handlerCtx.getInputValue("GroupList");
            String[] groups = GuiUtil.stringToArray((String)grouplist, (String)",");
            String password = (String)handlerCtx.getInputValue("Password");
            String userid = (String)handlerCtx.getInputValue("UserId");
            V3AMX.getInstance().getRealmsMgr().updateUser(realmName, userid, userid, password, groups);
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    public static void addUser(HandlerContext handlerCtx) {
        try {
            String realmName = (String)handlerCtx.getInputValue("Realm");
            String grouplist = (String)handlerCtx.getInputValue("GroupList");
            String[] groups = GuiUtil.stringToArray((String)grouplist, (String)",");
            String password = (String)handlerCtx.getInputValue("Password");
            String userid = (String)handlerCtx.getInputValue("UserId");
            V3AMX.getInstance().getRealmsMgr().addUser(realmName, userid, password, groups);
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    public static void getUserInfo(HandlerContext handlerCtx) {
        String realmName = (String)handlerCtx.getInputValue("Realm");
        String userName = (String)handlerCtx.getInputValue("User");
        handlerCtx.setOutputValue("GroupList", (Object)FileUserHandler.getGroupNames(realmName, userName));
    }

    public static void getFileUsers(HandlerContext handlerCtx) {
        String realmName = (String)handlerCtx.getInputValue("Realm");
        ArrayList result = new ArrayList();
        try {
            String[] userNames = V3AMX.getInstance().getRealmsMgr().getUserNames(realmName);
            if (userNames != null) {
                HashMap<String, Object> map = null;
                for (int i = 0; i < userNames.length; ++i) {
                    map = new HashMap<String, Object>();
                    map.put("users", userNames[i]);
                    map.put("groups", FileUserHandler.getGroupNames(realmName, userNames[i]));
                    map.put("selected", false);
                    result.add(map);
                }
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
        handlerCtx.setOutputValue("result", result);
    }

    public static void removeUser(HandlerContext handlerCtx) {
        String realmName = (String)handlerCtx.getInputValue("Realm");
        try {
            List obj;
            List selectedRows = obj = (List)handlerCtx.getInputValue("selectedRows");
            for (Map oneRow : selectedRows) {
                String user = (String)oneRow.get("users");
                V3AMX.getInstance().getRealmsMgr().removeUser(realmName, user);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    public static void checkCurrentUser(HandlerContext handlerCtx) {
        boolean endSession = true;
        String realmName = (String)handlerCtx.getInputValue("Realm");
        if (realmName.equals("admin-realm")) {
            String[] userNames = V3AMX.getInstance().getRealmsMgr().getUserNames(realmName);
            if (userNames == null || userNames.length == 0) {
                endSession = true;
            } else {
                String currentLoginUser = (String)GuiUtil.getSessionValue((String)"userName");
                for (int i = 0; i < userNames.length; ++i) {
                    if (!userNames[i].equals(currentLoginUser)) continue;
                    endSession = false;
                    break;
                }
            }
        }
        if (endSession) {
            ExternalContext extContext = handlerCtx.getFacesContext().getExternalContext();
            HttpServletRequest request = (HttpServletRequest)extContext.getRequest();
            request.getSession().invalidate();
        }
        handlerCtx.setOutputValue("endSession", (Object)endSession);
    }

    public static void hasManageUserButton(HandlerContext handlerCtx) {
        String realmName = (String)handlerCtx.getInputValue("realmName");
        handlerCtx.setOutputValue("result", (Object)V3AMX.getInstance().getRealmsMgr().supportsUserManagement(realmName));
    }

    private static String getGroupNames(String realmName, String userName) {
        try {
            return GuiUtil.arrayToString((String[])V3AMX.getInstance().getRealmsMgr().getGroupNames(realmName, userName), (String)",");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
    }
}

