/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.util;

import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintWriter;
import java.net.URI;
import java.util.Map;
import java.util.Properties;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.V3AMX;
import org.glassfish.deployment.client.DFDeploymentStatus;
import org.glassfish.deployment.client.DFProgressObject;
import org.glassfish.deployment.client.DeploymentFacility;

public class DeployUtil {
    public static void deploy(String[] targets, Properties deploymentProps, String location, HandlerContext handlerCtx) throws Exception {
        deploymentProps.setProperty("force", "false");
        deploymentProps.setProperty("upload", "false");
        boolean status = DeployUtil.invokeDeploymentFacility(targets, deploymentProps, location, handlerCtx);
        if (status) {
            // empty if block
        }
    }

    public static boolean invokeDeploymentFacility(String[] targets, Properties props, String archivePath, HandlerContext handlerCtx) throws Exception {
        if (archivePath == null) {
            GuiUtil.handleError(handlerCtx, GuiUtil.getMessage("msg.deploy.nullArchiveError"));
        }
        if (targets == null) {
            String defaultTarget = V3AMX.getInstance().isEE() ? "domain" : "server";
            targets = new String[]{defaultTarget};
        }
        File filePath = new File(archivePath);
        URI source = filePath.toURI();
        DeploymentFacility df = GuiUtil.getDeploymentFacility();
        DFProgressObject progressObject = null;
        progressObject = df.deploy(df.createTargets(targets), source, null, (Map)props);
        progressObject.waitFor();
        DFDeploymentStatus status = progressObject.getCompletedStatus();
        boolean ret = DeployUtil.checkDeployStatus(status, handlerCtx, true);
        return ret;
    }

    public static boolean checkDeployStatus(DFDeploymentStatus status, HandlerContext handlerCtx, boolean stopProcessing) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(bos);
        DFDeploymentStatus.parseDeploymentStatus((DFDeploymentStatus)status, (PrintWriter)pw);
        byte[] statusBytes = bos.toByteArray();
        String statusString = new String(statusBytes);
        if (status != null && status.getStatus() == DFDeploymentStatus.Status.FAILURE) {
            if (stopProcessing) {
                GuiUtil.handleError(handlerCtx, statusString);
            } else {
                GuiUtil.prepareAlert(handlerCtx, "error", GuiUtil.getMessage("msg.Error"), statusString);
            }
            return false;
        }
        if (status != null && status.getStatus() == DFDeploymentStatus.Status.WARNING) {
            GuiUtil.prepareAlert(handlerCtx, "warning", GuiUtil.getMessage("deploy.warning"), statusString);
            return false;
        }
        return true;
    }

    public static void handleAppRefs(String appName, String[] targetNames, HandlerContext handlerCtx, boolean addFlag, Boolean enableFlag) {
        if (targetNames != null && targetNames.length > 0) {
            DeploymentFacility df = GuiUtil.getDeploymentFacility();
            DFProgressObject progressObject = null;
            Properties dProps = new Properties();
            if (enableFlag != null) {
                dProps.setProperty("enabled", enableFlag.toString());
            }
            progressObject = addFlag ? df.createAppRef(df.createTargets(targetNames), appName, (Map)dProps) : df.deleteAppRef(df.createTargets(targetNames), appName, (Map)dProps);
            DFDeploymentStatus status = df.waitFor(progressObject);
            DeployUtil.checkDeployStatus(status, handlerCtx, true);
        }
    }
}

