/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.handlers;

import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.glassfish.admin.amx.intf.config.Config;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.V3AMX;

public class LoggingHandlers {
    private static final List<String> levels = new ArrayList<String>();

    public static void getLoggerLevels(HandlerContext handlerCtx) {
        String configName = (String)handlerCtx.getInputValue("configName");
        ArrayList result = new ArrayList();
        Config config = (Config)V3AMX.getInstance().getConfigs().childrenMap(Config.class).get(configName);
        HashMap<String, String> loggerLevels = new HashMap<String, String>();
        loggerLevels.put("org.abc.level", "INFO");
        loggerLevels.put("org.def.level", "WARNING");
        loggerLevels.put("org.sss.level", "SEVERE");
        loggerLevels.put("org.abfffc", "INFO");
        loggerLevels.put("org.abasdc.level", "SEVERE");
        for (String oneLogger : loggerLevels.keySet()) {
            if (!oneLogger.endsWith(".level")) continue;
            HashMap<String, Object> oneRow = new HashMap<String, Object>();
            oneRow.put("loggerName", oneLogger);
            oneRow.put("level", loggerLevels.get(oneLogger));
            oneRow.put("selected", false);
            result.add(oneRow);
        }
        handlerCtx.setOutputValue("loggerList", result);
    }

    public static void changeLoggerLevels(HandlerContext handlerCtx) {
        List obj;
        String newLogLevel = (String)handlerCtx.getInputValue("newLogLevel");
        List allRows = obj = (List)handlerCtx.getInputValue("allRows");
        if (GuiUtil.isEmpty((String)newLogLevel)) {
            handlerCtx.setOutputValue("newList", (Object)allRows);
            return;
        }
        for (Map oneRow : allRows) {
            boolean selected = (Boolean)oneRow.get("selected");
            if (!selected) continue;
            oneRow.put("level", newLogLevel);
        }
        handlerCtx.setOutputValue("newList", (Object)allRows);
    }

    public static void updateLoggerLevels(HandlerContext handlerCtx) {
        String configName = (String)handlerCtx.getInputValue("configName");
        List allRows = (List)handlerCtx.getInputValue("allRows");
        HashMap props = new HashMap();
        for (Map oneRow : allRows) {
            props.put(oneRow.get("loggerName"), oneRow.get("level"));
        }
        Config config = (Config)V3AMX.getInstance().getConfigs().childrenMap(Config.class).get(configName);
    }

    public static void getValidLogLevels(HandlerContext handlerCtx) {
        handlerCtx.setOutputValue("loggerList", levels);
    }

    static {
        levels.add("OFF");
        levels.add("SEVERE");
        levels.add("WARNING");
        levels.add("INFO");
        levels.add("CONFIG");
        levels.add("FINE");
        levels.add("FINER");
        levels.add("FINEST");
    }
}

