/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.util;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.context.FacesContext;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.servlet.ServletContext;
import org.glassfish.admin.amx.base.ConnectorRuntimeAPIProvider;
import org.glassfish.admin.amx.base.DomainRoot;
import org.glassfish.admin.amx.base.Realms;
import org.glassfish.admin.amx.base.Runtime;
import org.glassfish.admin.amx.config.AMXConfigProxy;
import org.glassfish.admin.amx.core.AMXProxy;
import org.glassfish.admin.amx.core.proxy.ProxyFactory;
import org.glassfish.admin.amx.intf.config.AMXConfigHelper;
import org.glassfish.admin.amx.intf.config.Application;
import org.glassfish.admin.amx.intf.config.ApplicationRef;
import org.glassfish.admin.amx.intf.config.Applications;
import org.glassfish.admin.amx.intf.config.Config;
import org.glassfish.admin.amx.intf.config.ConfigTools;
import org.glassfish.admin.amx.intf.config.Configs;
import org.glassfish.admin.amx.intf.config.Domain;
import org.glassfish.admin.amx.intf.config.PropertiesAccess;
import org.glassfish.admin.amx.intf.config.Property;
import org.glassfish.admin.amx.intf.config.Server;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.api.amx.AMXBooter;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class V3AMX {
    private static V3AMX v3amx;
    private final DomainRoot domainRoot;
    private final Domain domain;
    private final ProxyFactory proxyFactory;
    private final MBeanServerConnection mbeanServer;
    private static final List skipAttr;
    private static final String PROPERTY_NAME = "Name";
    private static final String PROPERTY_VALUE = "Value";
    private static final String PROPERTY_DESC = "Description";

    private V3AMX(DomainRoot dd, MBeanServerConnection msc) {
        this.proxyFactory = ProxyFactory.getInstance((MBeanServerConnection)msc);
        this.domainRoot = dd;
        this.domain = (Domain)this.domainRoot.getDomain().as(Domain.class);
        this.mbeanServer = msc;
    }

    public static synchronized V3AMX getInstance() {
        if (v3amx == null) {
            ServletContext servletCtx = (ServletContext)FacesContext.getCurrentInstance().getExternalContext().getContext();
            Habitat habitat = (Habitat)servletCtx.getAttribute("org.glassfish.servlet.habitat");
            MBeanServer mbs = (MBeanServer)habitat.getComponent(MBeanServer.class);
            if (mbs == null) {
                mbs = ManagementFactory.getPlatformMBeanServer();
            }
            if (mbs == null) {
                System.out.println("!!!!!!!!!!!!!!  Cannot get to MBeanServer");
            }
            AMXBooter.bootAMX((MBeanServerConnection)mbs);
            DomainRoot domainRoot = ProxyFactory.getInstance((MBeanServer)mbs).getDomainRootProxy();
            v3amx = new V3AMX(domainRoot, mbs);
        }
        return v3amx;
    }

    public Domain getDomain() {
        return this.domain;
    }

    public DomainRoot getDomainRoot() {
        return this.domainRoot;
    }

    public Configs getConfigs() {
        return this.domain.getConfigs();
    }

    public ProxyFactory getProxyFactory() {
        return this.proxyFactory;
    }

    public AMXProxy getProxy(ObjectName objName) {
        return this.proxyFactory.getProxy(objName);
    }

    public MBeanServerConnection getMbeanServerConnection() {
        return this.mbeanServer;
    }

    public Realms getRealmsMgr() {
        return this.domainRoot.getExt().getRealms();
    }

    public Runtime getRuntime() {
        return this.domainRoot.getExt().getRuntime();
    }

    public ConnectorRuntimeAPIProvider getConnectorRuntime() {
        return this.domainRoot.getExt().getConnectorRuntimeAPIProvider();
    }

    public Applications getApplications() {
        return this.domain.getApplications();
    }

    public Application getApplication(String appName) {
        return (Application)this.getApplications().childrenMap(Application.class).get(appName);
    }

    public ApplicationRef getApplicationRef(String server, String appName) {
        return (ApplicationRef)((Server)this.getDomain().getServers().getServer().get(server)).getApplicationRef().get(appName);
    }

    public Config getConfig(String configName) {
        return (Config)this.domain.getConfigs().getConfig().get(configName);
    }

    public AMXProxy getAdminListener() {
        return (AMXProxy)this.getConfig("server-config").getNetworkConfig().child("network-listeners").childrenMap("network-listener").get("admin-listener");
    }

    public boolean isEE() {
        return false;
    }

    public boolean supportCluster() {
        return false;
    }

    public static Config getServerConfig(String configName) {
        if (configName == null || configName.equals("")) {
            configName = "server-config";
        }
        return (Config)V3AMX.getInstance().getConfigs().getConfig().get(configName);
    }

    public static void setAttribute(String objectName, Attribute attributeName) {
        try {
            V3AMX.setAttribute(new ObjectName(objectName), attributeName);
        }
        catch (MalformedObjectNameException ex) {
            GuiUtil.getLogger().severe("MalformedObjectNameException: " + objectName);
            throw new RuntimeException(ex);
        }
    }

    public static void setAttribute(ObjectName objectName, Attribute attributeName) {
        try {
            V3AMX.getInstance().getMbeanServerConnection().setAttribute(objectName, attributeName);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void setAttributes(Object name, Map<String, Object> attrMap) {
        try {
            ObjectName objectName = null;
            objectName = name instanceof String ? new ObjectName((String)name) : (ObjectName)name;
            AttributeList attrList = new AttributeList();
            V3AMX.removeElement(attrMap);
            for (String key : attrMap.keySet()) {
                Object val;
                if (skipAttr.contains(key) || (val = attrMap.get(key)) != null && !(val instanceof String) && !(val instanceof Boolean)) continue;
                Attribute attr = new Attribute(key, val == null ? (String)val : val.toString());
                attrList.add(attr);
            }
            V3AMX.setAttributes(objectName, attrList);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void setAttributes(ObjectName objectName, AttributeList attrList) {
        try {
            V3AMX.getInstance().getMbeanServerConnection().setAttributes(objectName, attrList);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Map getAttrsMap(Object objectNameStr) {
        ObjectName amxObjectName = null;
        try {
            amxObjectName = objectNameStr instanceof ObjectName ? (ObjectName)objectNameStr : new ObjectName((String)objectNameStr);
            AMXProxy amx = V3AMX.getInstance().getProxyFactory().getProxy(amxObjectName);
            AMXConfigHelper helper = new AMXConfigHelper((AMXConfigProxy)amx);
            Map attrs = helper.simpleAttributesMap();
            return attrs;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return new HashMap();
        }
    }

    public static Object getAttribute(Object objectNameStr, String key) {
        ObjectName amxObjectName = null;
        try {
            amxObjectName = objectNameStr instanceof ObjectName ? (ObjectName)objectNameStr : new ObjectName((String)objectNameStr);
            AMXProxy amx = V3AMX.getInstance().getProxyFactory().getProxy(amxObjectName);
            return amx.attributesMap().get(key);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static void setPropertyValue(AMXConfigProxy config, String propName, String propValue) {
        Map pMap = ((PropertiesAccess)config).getProperty();
        if (pMap.containsKey(propName)) {
            if (GuiUtil.isEmpty(propValue)) {
                config.removeChild("property", propName);
            } else {
                Property cp = (Property)((PropertiesAccess)config).getProperty().get(propName);
                if (!cp.getValue().equals(propValue)) {
                    cp.setValue(propValue);
                }
            }
        } else if (!GuiUtil.isEmpty(propValue)) {
            HashMap<String, String> attrs = new HashMap<String, String>();
            attrs.put(PROPERTY_NAME, propName);
            attrs.put(PROPERTY_VALUE, propValue);
            config.createChild("property", attrs);
        }
    }

    public static void setProperties(String objectNameStr, List<Map<String, String>> propertyList, boolean sysProp) {
        try {
            ObjectName objectName = new ObjectName(objectNameStr);
            ArrayList newList = new ArrayList();
            HashSet<String> propertyNames = new HashSet<String>();
            ConfigTools configTools = (ConfigTools)V3AMX.getInstance().getDomainRoot().getExt().child(ConfigTools.class);
            if (propertyList.size() == 0) {
                if (sysProp) {
                    configTools.clearSystemProperties(objectName);
                } else {
                    configTools.clearProperties(objectName);
                }
            } else {
                for (Map<String, String> oneRow : propertyList) {
                    HashMap<String, String> newRow = new HashMap<String, String>();
                    String name = oneRow.get(PROPERTY_NAME);
                    if (GuiUtil.isEmpty(name)) continue;
                    if (propertyNames.contains(name)) {
                        throw new RuntimeException(GuiUtil.getMessage("msg.duplicatePropTableKey", new Object[]{name}));
                    }
                    propertyNames.add(name);
                    String value = oneRow.get(PROPERTY_VALUE);
                    if (GuiUtil.isEmpty(value)) {
                        value = "";
                    }
                    newRow.put(PROPERTY_NAME, name);
                    newRow.put(PROPERTY_VALUE, value);
                    String desc = oneRow.get(PROPERTY_DESC);
                    if (!GuiUtil.isEmpty(desc)) {
                        newRow.put(PROPERTY_DESC, desc);
                    }
                    newList.add(newRow);
                }
                if (sysProp) {
                    configTools.setSystemProperties(objectName, newList, true);
                } else {
                    configTools.setProperties(objectName, newList, true);
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void updateProperties(AMXConfigProxy config, Map<String, String> newProps, List ignore) {
        Map oldProps = ((PropertiesAccess)config).getProperty();
        if (ignore == null) {
            ignore = new ArrayList();
        }
        for (Object key : oldProps.keySet()) {
            if (ignore.contains(key) || newProps.containsKey(key)) continue;
            config.removeChild("property", (String)key);
        }
        Map pMap = ((PropertiesAccess)config).getProperty();
        for (String propName : newProps.keySet()) {
            String propValue = newProps.get(propName);
            if (pMap.containsKey(propName)) {
                ((Property)pMap.get(propName)).setValue(propValue);
                continue;
            }
            HashMap<String, String> attrs = new HashMap<String, String>();
            attrs.put(PROPERTY_NAME, propName);
            attrs.put(PROPERTY_VALUE, propValue);
            config.createChild("property", attrs);
        }
    }

    public static List getChildrenMapForTableList(AMXProxy amx, String childType, List skipList) {
        boolean hasSkip = true;
        if (skipList == null) {
            hasSkip = false;
        }
        ArrayList result = new ArrayList();
        if (amx != null) {
            Map children = amx.childrenMap(childType);
            for (AMXProxy oneChild : children.values()) {
                try {
                    AMXConfigHelper helper = new AMXConfigHelper((AMXConfigProxy)oneChild);
                    Map attrs = helper.simpleAttributesMap();
                    HashMap<String, Object> oneRow = new HashMap<String, Object>();
                    if (hasSkip && skipList.contains(oneChild.getName())) continue;
                    oneRow.put("selected", false);
                    for (String attrName : attrs.keySet()) {
                        oneRow.put(attrName, V3AMX.getA(attrs, attrName));
                    }
                    result.add(oneRow);
                }
                catch (Exception ex) {
                    GuiUtil.getLogger().info("getChildrenMapForTableList():  ");
                    GuiUtil.getLogger().info("Proxy = " + amx.objectName().toString() + "; childType=" + childType + ", skipList=" + skipList);
                    ex.printStackTrace();
                }
            }
        }
        return result;
    }

    public static List getNonSkipPropertiesMap(AMXConfigProxy amx, List skipList) {
        boolean noSkip = false;
        if (skipList == null || skipList.size() == 0) {
            noSkip = true;
        }
        Map children = amx.childrenMap("property");
        ArrayList result = new ArrayList();
        for (AMXProxy oneChild : children.values()) {
            HashMap<String, Object> oneRow = new HashMap<String, Object>();
            oneRow.put("selected", false);
            String name = oneChild.getName();
            if (noSkip || skipList.contains(name)) continue;
            oneRow.put(PROPERTY_NAME, name);
            oneRow.put(PROPERTY_VALUE, oneChild.attributesMap().get(PROPERTY_VALUE));
            Object desc = oneChild.attributesMap().get(PROPERTY_DESC);
            oneRow.put(PROPERTY_DESC, desc == null ? "" : desc);
        }
        return result;
    }

    public static String getPropValue(AMXProxy amx, String key) {
        Map props = amx.childrenMap("property");
        if (props.containsKey(key)) {
            return (String)((AMXProxy)props.get(key)).attributesMap().get(PROPERTY_VALUE);
        }
        return null;
    }

    public static String getPropValue(Map<String, Property> propMap, String key) {
        if (propMap.containsKey(key)) {
            return (String)propMap.get(key).attributesMap().get(PROPERTY_VALUE);
        }
        return null;
    }

    public static Map convertToPropertiesOptionMap(Map<String, String> props, Map<String, String> convertedMap) {
        if (convertedMap == null) {
            convertedMap = new HashMap<String, String>();
        }
        if (props == null) {
            return convertedMap;
        }
        Set<String> keySet = props.keySet();
        for (String key : keySet) {
            if (GuiUtil.isEmpty(props.get(key))) continue;
            convertedMap.put("property." + key, props.get(key));
        }
        return convertedMap;
    }

    public static void removeElement(Map<String, Object> attrs) {
        Set<Map.Entry<String, Object>> attrSet = attrs.entrySet();
        Iterator<Map.Entry<String, Object>> iter = attrSet.iterator();
        while (iter.hasNext()) {
            Map.Entry<String, Object> oneEntry = iter.next();
            Object val = oneEntry.getValue();
            if (!(val instanceof ObjectName) && !(val instanceof ObjectName[])) continue;
            iter.remove();
        }
    }

    public static void removeSpecifiedAttr(Map<String, Object> attrs, List removeList) {
        if (removeList == null || removeList.size() <= 0) {
            return;
        }
        Set<Map.Entry<String, Object>> attrSet = attrs.entrySet();
        Iterator<Map.Entry<String, Object>> iter = attrSet.iterator();
        while (iter.hasNext()) {
            Map.Entry<String, Object> oneEntry = iter.next();
            if (!removeList.contains(oneEntry.getKey())) continue;
            iter.remove();
        }
    }

    public static AMXProxy objectNameToProxy(String objectNameStr) {
        try {
            AMXProxy amx = V3AMX.getInstance().getProxyFactory().getProxy(new ObjectName(objectNameStr));
            return amx;
        }
        catch (Exception ex) {
            System.out.println("Cannot find object: " + objectNameStr);
            return null;
        }
    }

    private static String getA(Map<String, Object> attrs, String key) {
        Object val = attrs.get(key);
        return val == null ? "" : val.toString();
    }

    static {
        skipAttr = new ArrayList();
        skipAttr.add("Parent");
        skipAttr.add(PROPERTY_NAME);
        skipAttr.add("Children");
    }
}

