/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.handlers;

import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.glassfish.admin.amx.logging.Logging;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.V3AMX;

public class LoggingHandlers {
    private static final List<String> levels = new ArrayList<String>();

    public static void getLoggerLevels(HandlerContext handlerCtx) {
        ArrayList result = new ArrayList();
        Logging logging = V3AMX.getInstance().getDomainRoot().getLogging();
        Map loggerLevels = logging.getLoggingProperties();
        for (String oneLogger : loggerLevels.keySet()) {
            if (!oneLogger.endsWith(".level") || oneLogger.equals(".level")) continue;
            HashMap<String, Object> oneRow = new HashMap<String, Object>();
            oneRow.put("loggerName", oneLogger.substring(0, oneLogger.lastIndexOf(".level")));
            oneRow.put("level", loggerLevels.get(oneLogger));
            oneRow.put("selected", false);
            result.add(oneRow);
        }
        handlerCtx.setOutputValue("loggerList", result);
    }

    public static void changeLoggerLevels(HandlerContext handlerCtx) {
        List obj;
        String newLogLevel = (String)handlerCtx.getInputValue("newLogLevel");
        List allRows = obj = (List)handlerCtx.getInputValue("allRows");
        if (GuiUtil.isEmpty((String)newLogLevel)) {
            handlerCtx.setOutputValue("newList", (Object)allRows);
            return;
        }
        for (Map oneRow : allRows) {
            boolean selected = (Boolean)oneRow.get("selected");
            if (!selected) continue;
            oneRow.put("level", newLogLevel);
            oneRow.put("selected", false);
        }
        handlerCtx.setOutputValue("newList", (Object)allRows);
    }

    public static void updateLoggerLevels(HandlerContext handlerCtx) {
        List allRows = (List)handlerCtx.getInputValue("allRows");
        HashMap props = new HashMap();
        for (Map oneRow : allRows) {
            props.put((String)oneRow.get("loggerName") + ".level", oneRow.get("level"));
        }
        Logging logging = V3AMX.getInstance().getDomainRoot().getLogging();
        logging.updateLoggingProperties(props);
    }

    public static void getLoggingAttributes(HandlerContext handlerCtx) {
        HashMap attrs = new HashMap();
        Logging logging = V3AMX.getInstance().getDomainRoot().getLogging();
        Map longAttrs = logging.getLoggingAttributes();
        for (String oneAttr : longAttrs.keySet()) {
            attrs.put(oneAttr.substring(oneAttr.lastIndexOf(".") + 1), longAttrs.get(oneAttr));
        }
        handlerCtx.setOutputValue("attrs", attrs);
    }

    public static void saveLoggingAttributes(HandlerContext handlerCtx) {
        Map attrs = (Map)handlerCtx.getInputValue("attrs");
        if (attrs.get("logtoConsole") == null) {
            attrs.put("logtoConsole", "false");
        }
        if (attrs.get("useSystemLogging") == null) {
            attrs.put("useSystemLogging", "false");
        }
        Logging logging = V3AMX.getInstance().getDomainRoot().getLogging();
        Map longAttrs = logging.getLoggingAttributes();
        Iterator i$ = longAttrs.keySet().iterator();
        while (i$.hasNext()) {
            String oneAttr;
            String shortAttr = (oneAttr = (String)i$.next()).substring(oneAttr.lastIndexOf(".") + 1);
            String newValue = (String)attrs.get(shortAttr);
            longAttrs.put(oneAttr, newValue == null ? "" : newValue);
        }
        logging.updateLoggingAttributes(longAttrs);
    }

    public static void getValidLogLevels(HandlerContext handlerCtx) {
        handlerCtx.setOutputValue("loggerList", levels);
    }

    static {
        levels.add("OFF");
        levels.add("SEVERE");
        levels.add("WARNING");
        levels.add("INFO");
        levels.add("CONFIG");
        levels.add("FINE");
        levels.add("FINER");
        levels.add("FINEST");
    }
}

