/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mojarra.scales.component;

import com.sun.mojarra.scales.component.Links;
import com.sun.mojarra.scales.util.RenderingHelper;
import com.sun.mojarra.scales.util.ScalesUtil;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class YuiChart
extends UIOutput {
    public static final String COMPONENT_FAMILY = "com.sun.mojarra.scales.YuiChart";
    public static final String RENDERER_TYPE = "com.sun.mojarra.scales.YuiChart";
    private Object[] _state;
    protected String type;
    protected String horizontalField;
    protected String verticalField;
    protected String horizontalAxis;
    protected String verticalAxis;
    protected String labelFunction;
    protected String categoryField;
    protected String dataField;
    protected String seriesDef;
    protected String width;
    protected String height;
    protected String style;

    public YuiChart() {
        this.setRendererType("com.sun.mojarra.scales.YuiChart");
        FacesContext context = FacesContext.getCurrentInstance();
        if (context != null) {
            String baseUrl = context.getExternalContext().getRequestContextPath();
            Links.addScript("SCALES_EXTERNAL_SCRIPTS", baseUrl + ScalesUtil.createResourceUrl(context, "/yui/datasource/datasource-min.js"));
            Links.addScript("SCALES_EXTERNAL_SCRIPTS", baseUrl + ScalesUtil.createResourceUrl(context, "/yui/json/json-min.js"));
            Links.addScript("SCALES_EXTERNAL_SCRIPTS", baseUrl + ScalesUtil.createResourceUrl(context, "/yui/charts/charts-min.js"));
            Links.addScript("SCALES_DOM_READY_SCRIPTS", "YAHOO.widget.Chart.SWFURL = '" + baseUrl + ScalesUtil.createResourceUrl(context, "/yui/charts/assets/charts.swf") + "';");
        }
    }

    public String getFamily() {
        return "com.sun.mojarra.scales.YuiChart";
    }

    public void encodeBegin(FacesContext context) throws IOException {
        super.encodeBegin(context);
        if (!this.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        String clientId = this.getClientId(context);
        writer.startElement("div", (UIComponent)this);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("style", (Object)("height: " + this.getHeight() + "; width: " + this.getWidth() + " " + this.getStyle()), "style");
        writer.write("Unable to load Flash content. The chart Control requires Flash Player 9.0.45 or higher.");
        writer.endElement("div");
        RenderingHelper.writeOnDomReady(writer, "scales.createChart('" + clientId + "', '" + this.getType().toLowerCase() + "', " + this.buildConfig() + ");");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String buildConfig() {
        Object chartValue = this.getValue();
        StringBuilder data = new StringBuilder();
        String sep = "";
        Set keys = null;
        if (!(chartValue instanceof List)) throw new IllegalArgumentException("The Chart value must be a List of Map! Found: " + (chartValue == null ? "(null)" : chartValue.getClass().getName()));
        List list = (List)chartValue;
        if (!(list.get(0) instanceof Map)) throw new IllegalArgumentException("The Chart value must be a List of Map! Found List of: " + (list.get(0) == null ? "(null)" : list.get(0).getClass().getName()));
        List mapList = list;
        for (Map map : mapList) {
            keys = map.keySet();
            String sep2 = "";
            Iterator iter = keys.iterator();
            data.append(sep).append("{");
            while (iter.hasNext()) {
                Object key = iter.next();
                String value = (String)map.get(key);
                String quote = Character.isDigit(value.charAt(0)) ? "" : "\"";
                data.append(sep2).append(key.toString()).append(": ").append(quote).append(map.get(key)).append(quote);
                sep2 = ",";
            }
            data.append("}");
            sep = ",";
        }
        StringBuilder params = new StringBuilder();
        params.append("{").append(this.prepareChartConfig()).append("}, [").append(data.toString()).append("],[").append(this.buildSeriesDef(keys)).append("]");
        return params.toString();
    }

    private String prepareChartConfig() {
        StringBuilder config = new StringBuilder();
        String chartType = this.getType().toLowerCase();
        if ("column".equals(chartType)) {
            config.append("xField: \"").append(this.getHorizontalField()).append("\", yField:\"").append(this.getVerticalField()).append("\"");
        } else if ("stackedcolumn".equals(chartType)) {
            config.append("xField: \"").append(this.getHorizontalField()).append("\", yField:\"").append(this.getVerticalField()).append("\"");
        } else if ("line".equals(chartType)) {
            config.append("xField: \"").append(this.getHorizontalField()).append("\"");
        } else if ("pie".equals(chartType)) {
            config.append("categoryField:\"").append(this.getCategoryField()).append("\", dataField:\"").append(this.getDataField()).append("\"");
            this.appendField(config, this.getLabelFunction(), "labelFunction");
        } else if ("bar".equals(chartType)) {
            config.append("yField:\"").append(this.getVerticalField()).append("\"");
        } else if ("stackedbar".equals(chartType)) {
            config.append("yField:\"").append(this.getVerticalField()).append("\"");
        }
        this.appendField(config, this.getSeriesDef(), "series");
        this.appendField(config, this.getHorizontalAxis(), "xAxis");
        this.appendField(config, this.getVerticalAxis(), "yAxis");
        return config.toString();
    }

    protected void appendField(StringBuilder sb, String field, String fieldName) {
        if (field != null && !"".equals(field)) {
            sb.append(", ").append(fieldName).append(": ").append(field);
        }
    }

    protected String buildSeriesDef(Set keys) {
        StringBuilder sb = new StringBuilder();
        String sep = "";
        if (keys != null) {
            for (Object key : keys) {
                sb.append(sep).append("\"").append(key.toString()).append("\"");
                sep = ",";
            }
        }
        return sb.toString();
    }

    public String getCategoryField() {
        return ScalesUtil.getPropertyValue((UIComponent)this, this.categoryField, "categoryField", null);
    }

    public void setCategoryField(String categoryField) {
        this.categoryField = categoryField;
    }

    public String getDataField() {
        return ScalesUtil.getPropertyValue((UIComponent)this, this.dataField, "dataField", null);
    }

    public void setDataField(String dataField) {
        this.dataField = dataField;
    }

    public String getHeight() {
        return ScalesUtil.getPropertyValue((UIComponent)this, this.height, "height", "250px");
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public String getHorizontalAxis() {
        return ScalesUtil.getPropertyValue((UIComponent)this, this.horizontalAxis, "horizontalAxis", "");
    }

    public void setHorizontalAxis(String horizontalAxis) {
        this.horizontalAxis = horizontalAxis;
    }

    public String getHorizontalField() {
        return ScalesUtil.getPropertyValue((UIComponent)this, this.horizontalField, "horizontalField", null);
    }

    public void setHorizontalField(String horizontalField) {
        this.horizontalField = horizontalField;
    }

    public String getLabelFunction() {
        return ScalesUtil.getPropertyValue((UIComponent)this, this.labelFunction, "labelFunction", "");
    }

    public void setLabelFunction(String labelFunction) {
        this.labelFunction = labelFunction;
    }

    public String getSeriesDef() {
        return ScalesUtil.getPropertyValue((UIComponent)this, this.seriesDef, "seriesDef", "[{}]");
    }

    public void setSeriesDef(String seriesDef) {
        this.seriesDef = seriesDef;
    }

    public String getStyle() {
        return ScalesUtil.getPropertyValue((UIComponent)this, this.style, "style", "");
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getType() {
        return ScalesUtil.getPropertyValue((UIComponent)this, this.type, "type", "line");
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getVerticalAxis() {
        return ScalesUtil.getPropertyValue((UIComponent)this, this.verticalAxis, "verticalAxis", "");
    }

    public void setVerticalAxis(String verticalAxis) {
        this.verticalAxis = verticalAxis;
    }

    public String getVerticalField() {
        return ScalesUtil.getPropertyValue((UIComponent)this, this.verticalField, "verticalField", null);
    }

    public void setVerticalField(String verticalField) {
        this.verticalField = verticalField;
    }

    public String getWidth() {
        return ScalesUtil.getPropertyValue((UIComponent)this, this.width, "width", "500px");
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public void restoreState(FacesContext _context, Object _state) {
        this._state = (Object[])_state;
        super.restoreState(_context, this._state[0]);
        this.type = (String)this._state[1];
        this.horizontalField = (String)this._state[1];
        this.verticalField = (String)this._state[2];
        this.horizontalAxis = (String)this._state[3];
        this.verticalAxis = (String)this._state[4];
        this.labelFunction = (String)this._state[5];
        this.categoryField = (String)this._state[6];
        this.dataField = (String)this._state[7];
        this.seriesDef = (String)this._state[8];
        this.width = (String)this._state[9];
        this.height = (String)this._state[10];
        this.style = (String)this._state[11];
    }

    public Object saveState(FacesContext _context) {
        if (this._state == null) {
            this._state = new Object[12];
        }
        this._state[0] = super.saveState(_context);
        this._state[1] = this.horizontalField;
        this._state[2] = this.verticalField;
        this._state[3] = this.horizontalAxis;
        this._state[4] = this.verticalAxis;
        this._state[5] = this.labelFunction;
        this._state[6] = this.categoryField;
        this._state[7] = this.dataField;
        this._state[8] = this.seriesDef;
        this._state[9] = this.width;
        this._state[10] = this.height;
        this._state[11] = this.style;
        return this._state;
    }
}

