/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.impl;

import com.sun.java.help.impl.ViewAwareComponent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.help.HelpSet;
import javax.help.JHelpContentViewer;
import javax.help.Map;
import javax.help.Popup;
import javax.help.SecondaryWindow;
import javax.help.TextHelpModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;

public class JHSecondaryViewer
extends JButton
implements ActionListener,
ViewAwareComponent {
    private View myView;
    private HelpSet hs;
    private SimpleAttributeSet textAttribs;
    private URL base;
    private HTMLDocument doc;
    public static String POPUP = "javax.help.Popup";
    public static String SECONDARY_WINDOW = "javax.help.SecondaryWindow";
    public static String LINK_BUTTON = "javax.help.LinkButton";
    public static String LINK_LABEL = "javax.help.LinkLabel";
    private static final String buttonPropertyPrefix = "Button.";
    private static final String editorPropertyPrefix = "EditorPane.";
    private static final Cursor handCursor = Cursor.getPredefinedCursor(12);
    private static Component container;
    private Cursor origCursor;
    private int viewerHeight = 0;
    private int viewerWidth = 0;
    private int viewerX = 0;
    private int viewerY = 0;
    private String viewerName = "";
    private int viewerActivator = 0;
    private int viewerStyle = 0;
    private Icon viewerIcon;
    private String content = "";
    private Map.ID ident;
    private static final boolean debug = false;

    public JHSecondaryViewer() {
        this.setText(">");
        this.setMargin(new Insets(0, 0, 0, 0));
        this.createLinkButton();
        this.addActionListener(this);
        this.origCursor = this.getCursor();
        this.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
                JHSecondaryViewer.this.setCursor(handCursor);
            }

            public void mouseExited(MouseEvent e) {
                JHSecondaryViewer.this.setCursor(JHSecondaryViewer.this.origCursor);
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }
        });
    }

    public void setViewData(View v) {
        TextHelpModel thm;
        Container c;
        this.myView = v;
        this.doc = (HTMLDocument)this.myView.getDocument();
        this.base = this.doc.getBase();
        Font font = this.getFont();
        this.textAttribs = new SimpleAttributeSet();
        this.textAttribs.removeAttribute(StyleConstants.FontSize);
        this.textAttribs.removeAttribute(StyleConstants.Bold);
        this.textAttribs.removeAttribute(StyleConstants.Italic);
        this.textAttribs.addAttribute(StyleConstants.FontFamily, font.getName());
        this.textAttribs.addAttribute(StyleConstants.FontSize, new Integer(font.getSize()));
        this.textAttribs.addAttribute(StyleConstants.Bold, new Boolean(font.isBold()));
        this.textAttribs.addAttribute(StyleConstants.Italic, new Boolean(font.isItalic()));
        container = this.myView.getContainer();
        for (c = container; c != null && !(c instanceof JHelpContentViewer); c = c.getParent()) {
        }
        if (c != null && (thm = ((JHelpContentViewer)c).getModel()) != null) {
            this.hs = thm.getHelpSet();
        }
    }

    public void setContent(String content) {
        JHSecondaryViewer.debug("setContent");
        this.content = content;
        this.ident = null;
    }

    public String getContent() {
        if (this.ident != null) {
            Map map = this.hs.getCombinedMap();
            try {
                URL url = map.getURLFromID(this.ident);
                return url.toExternalForm();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.content;
    }

    public void setId(String id) {
        JHSecondaryViewer.debug("setID");
        this.ident = Map.ID.create(id, this.hs);
        this.content = "";
    }

    public String getId() {
        return this.ident.id;
    }

    public void setViewerName(String name) {
        JHSecondaryViewer.debug("setViewerName");
        this.viewerName = name;
    }

    public String getViewerName() {
        return this.viewerName;
    }

    public void setViewerActivator(String activator) {
        JHSecondaryViewer.debug("setViewerActivator");
        if (activator.compareTo(LINK_BUTTON) == 0 && this.viewerActivator != 0) {
            this.viewerActivator = 0;
            this.createLinkButton();
        } else if (activator.compareTo(LINK_LABEL) == 0 && this.viewerActivator != 1) {
            this.viewerActivator = 1;
            this.createLinkLabel();
        }
    }

    public String getViewerActivator() {
        switch (this.viewerActivator) {
            case 0: {
                return LINK_BUTTON;
            }
            case 1: {
                return LINK_LABEL;
            }
        }
        return "unknownStyle";
    }

    private void createLinkButton() {
        LookAndFeel.installBorder(this, "Button.border");
        this.setBorderPainted(true);
        this.setFocusPainted(true);
        this.setAlignmentY(0.5f);
        this.setContentAreaFilled(true);
        this.setBackground(UIManager.getColor("Button.background"));
        if (this.textAttribs != null && this.textAttribs.isDefined(StyleConstants.Foreground)) {
            this.setForeground((Color)this.textAttribs.getAttribute(StyleConstants.Foreground));
        } else {
            this.setForeground(UIManager.getColor("Button.foreground"));
        }
        this.invalidate();
    }

    private void createLinkLabel() {
        this.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.setBorderPainted(false);
        this.setFocusPainted(false);
        this.setAlignmentY(this.getPreferredLabelAlignment());
        this.setContentAreaFilled(false);
        this.setBackground(UIManager.getColor("EditorPane.background"));
        if (this.textAttribs != null && this.textAttribs.isDefined(StyleConstants.Foreground)) {
            this.setForeground((Color)this.textAttribs.getAttribute(StyleConstants.Foreground));
        } else {
            this.setForeground(Color.blue);
        }
        this.invalidate();
    }

    private float getPreferredLabelAlignment() {
        Icon icon = this.getIcon();
        String text = this.getText();
        Font font = this.getFont();
        FontMetrics fm = this.getToolkit().getFontMetrics(font);
        Rectangle iconR = new Rectangle();
        Rectangle textR = new Rectangle();
        Rectangle viewR = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
        SwingUtilities.layoutCompoundLabel(this, fm, text, icon, this.getVerticalAlignment(), this.getHorizontalAlignment(), this.getVerticalTextPosition(), this.getHorizontalTextPosition(), viewR, iconR, textR, text == null ? 0 : ((BasicButtonUI)this.ui).getDefaultTextIconGap(this));
        Rectangle r = iconR.union(textR);
        Insets insets = this.getInsets();
        r.height += insets.top + insets.bottom;
        if (r.height % 2 == 0) {
            ++r.height;
        }
        float offAmt = fm.getMaxAscent() + insets.top;
        return offAmt / (float)r.height;
    }

    public void setViewerStyle(String style) {
        JHSecondaryViewer.debug("setViewerStyle");
        if (style.compareTo(SECONDARY_WINDOW) == 0) {
            this.viewerStyle = 0;
        } else if (style.compareTo(POPUP) == 0) {
            this.viewerStyle = 1;
        }
    }

    public String getViewerStyle() {
        switch (this.viewerStyle) {
            case 0: {
                return SECONDARY_WINDOW;
            }
            case 1: {
                return POPUP;
            }
        }
        return "unknownStyle";
    }

    public void setViewerLocation(String location) {
        JHSecondaryViewer.debug("setViewerLocation");
        int comma = location.indexOf(",");
        if (comma != -1) {
            String x = location.substring(0, comma).trim();
            String y = location.substring(comma + 1).trim();
            if (x != null && y != null) {
                this.viewerX = Integer.parseInt(x);
                this.viewerY = Integer.parseInt(y);
            }
        }
    }

    public String getViewerLocation() {
        String retval = Integer.toString(this.viewerX) + "," + Integer.toString(this.viewerY);
        switch (this.viewerStyle) {
            case 0: {
                Point p;
                SecondaryWindow sw = SecondaryWindow.getPresentation(this.viewerName);
                if (sw == null || (p = sw.getLocation()) == null) break;
                retval = Integer.toString(p.x) + "," + Integer.toString(p.y);
                break;
            }
        }
        return retval;
    }

    public void setViewerSize(String size) {
        JHSecondaryViewer.debug("setViewerSize");
        int comma = size.indexOf(",");
        if (comma != -1) {
            String width = size.substring(0, comma).trim();
            String height = size.substring(comma + 1).trim();
            if (width != null && height != null) {
                this.viewerWidth = Integer.parseInt(width);
                this.viewerHeight = Integer.parseInt(height);
            }
        }
    }

    public String getViewerSize() {
        String retval = "";
        if (this.viewerWidth != 0) {
            retval = Integer.toString(this.viewerWidth) + "," + Integer.toString(this.viewerHeight);
        }
        switch (this.viewerStyle) {
            case 0: {
                Dimension size;
                SecondaryWindow sw = SecondaryWindow.getPresentation(this.viewerName);
                if (sw == null || (size = sw.getSize()) == null) break;
                retval = Integer.toString(size.width) + "," + Integer.toString(size.height);
                break;
            }
        }
        return retval;
    }

    public void setIconByName(String name) {
        JHSecondaryViewer.debug("setIconByName");
        ImageIcon ig = null;
        URL url = null;
        try {
            url = new URL(this.base, name);
        }
        catch (MalformedURLException ex1) {
            return;
        }
        ig = new ImageIcon(url);
        if (ig != null) {
            this.setIcon(ig);
            String text = this.getText();
            if (text.compareTo(">") == 0) {
                this.setText("");
            }
        }
    }

    public void setIconByID(String name) {
        JHSecondaryViewer.debug("setIconByID");
        ImageIcon ig = null;
        URL url = null;
        Map map = this.hs.getCombinedMap();
        try {
            url = map.getURLFromID(Map.ID.create(name, this.hs));
        }
        catch (MalformedURLException e2) {
            return;
        }
        ig = new ImageIcon(url);
        if (ig != null) {
            this.setIcon(ig);
            String text = this.getText();
            if (text.compareTo(">") == 0) {
                this.setText("");
            }
        }
    }

    public void setTextFontFamily(String family) {
        this.textAttribs.removeAttribute(StyleConstants.FontFamily);
        this.textAttribs.addAttribute(StyleConstants.FontFamily, family);
        this.setFont(this.getAttributeSetFont(this.textAttribs));
        Font font = this.getFont();
    }

    public String getTextFontFamily() {
        return StyleConstants.getFontFamily(this.textAttribs);
    }

    public void setTextFontSize(String size) {
        int newsize;
        StyleSheet css = this.doc.getStyleSheet();
        try {
            if (size.equals("xx-small")) {
                newsize = (int)css.getPointSize(0);
            } else if (size.equals("x-small")) {
                newsize = (int)css.getPointSize(1);
            } else if (size.equals("small")) {
                newsize = (int)css.getPointSize(2);
            } else if (size.equals("medium")) {
                newsize = (int)css.getPointSize(3);
            } else if (size.equals("large")) {
                newsize = (int)css.getPointSize(4);
            } else if (size.equals("x-large")) {
                newsize = (int)css.getPointSize(5);
            } else if (size.equals("xx-large")) {
                newsize = (int)css.getPointSize(6);
            } else if (size.equals("bigger")) {
                newsize = (int)css.getPointSize("+1");
            } else if (size.equals("smaller")) {
                newsize = (int)css.getPointSize("-1");
            } else if (size.endsWith("pt")) {
                String sz = size.substring(0, size.length() - 2);
                newsize = Integer.parseInt(sz);
            } else {
                newsize = (int)css.getPointSize(size);
            }
        }
        catch (NumberFormatException nfe) {
            return;
        }
        if (newsize == 0) {
            return;
        }
        this.textAttribs.removeAttribute(StyleConstants.FontSize);
        this.textAttribs.addAttribute(StyleConstants.FontSize, new Integer(newsize));
        this.setFont(this.getAttributeSetFont(this.textAttribs));
        Font font = this.getFont();
    }

    public String getTextFontSize() {
        return Integer.toString(StyleConstants.getFontSize(this.textAttribs));
    }

    public void setTextFontWeight(String weight) {
        boolean isBold = false;
        isBold = weight.compareTo("bold") == 0;
        this.textAttribs.removeAttribute(StyleConstants.Bold);
        this.textAttribs.addAttribute(StyleConstants.Bold, new Boolean(isBold));
        this.setFont(this.getAttributeSetFont(this.textAttribs));
        Font font = this.getFont();
    }

    public String getTextFontWeight() {
        if (StyleConstants.isBold(this.textAttribs)) {
            return "bold";
        }
        return "plain";
    }

    public void setTextFontStyle(String style) {
        boolean isItalic = false;
        isItalic = style.compareTo("italic") == 0;
        this.textAttribs.removeAttribute(StyleConstants.Italic);
        this.textAttribs.addAttribute(StyleConstants.Italic, new Boolean(isItalic));
        this.setFont(this.getAttributeSetFont(this.textAttribs));
        Font font = this.getFont();
    }

    public String getTextFontStyle() {
        if (StyleConstants.isItalic(this.textAttribs)) {
            return "italic";
        }
        return "plain";
    }

    public void setTextColor(String name) {
        Color color = null;
        if (name.compareTo("black") == 0) {
            color = Color.black;
        } else if (name.compareTo("blue") == 0) {
            color = Color.blue;
        } else if (name.compareTo("cyan") == 0) {
            color = Color.cyan;
        } else if (name.compareTo("darkGray") == 0) {
            color = Color.darkGray;
        } else if (name.compareTo("gray") == 0) {
            color = Color.gray;
        } else if (name.compareTo("green") == 0) {
            color = Color.green;
        } else if (name.compareTo("lightGray") == 0) {
            color = Color.lightGray;
        } else if (name.compareTo("magenta") == 0) {
            color = Color.magenta;
        } else if (name.compareTo("orange") == 0) {
            color = Color.orange;
        } else if (name.compareTo("pink") == 0) {
            color = Color.pink;
        } else if (name.compareTo("red") == 0) {
            color = Color.red;
        } else if (name.compareTo("white") == 0) {
            color = Color.white;
        } else if (name.compareTo("yellow") == 0) {
            color = Color.yellow;
        }
        if (color == null) {
            return;
        }
        this.textAttribs.removeAttribute(StyleConstants.Foreground);
        this.textAttribs.addAttribute(StyleConstants.Foreground, color);
        this.setForeground(color);
    }

    public String getTextColor() {
        Color color = this.getForeground();
        return color.toString();
    }

    private Font getAttributeSetFont(AttributeSet attr) {
        int style = 0;
        if (StyleConstants.isBold(attr)) {
            style |= 1;
        }
        if (StyleConstants.isItalic(attr)) {
            style |= 2;
        }
        String family = StyleConstants.getFontFamily(attr);
        int size = StyleConstants.getFontSize(attr);
        if (StyleConstants.isSuperscript(attr) || StyleConstants.isSubscript(attr)) {
            size -= 2;
        }
        return this.doc.getStyleSheet().getFont(family, style, size);
    }

    public void actionPerformed(ActionEvent e) {
        JHSecondaryViewer.debug("actionPerformed");
        switch (this.viewerStyle) {
            case 0: {
                if (this.hs == null) break;
                SecondaryWindow sw = (SecondaryWindow)SecondaryWindow.getPresentation(this.hs, this.viewerName);
                if (this.ident != null) {
                    JHSecondaryViewer.debug("ident=" + this.ident);
                    try {
                        sw.setCurrentID(this.ident);
                    }
                    catch (Exception ex) {
                        JHSecondaryViewer.debug("error setting CurrentID");
                    }
                } else if (this.content != null) {
                    JHSecondaryViewer.debug("content=" + this.content);
                    try {
                        URL url = new URL(this.base, this.content);
                        sw.setCurrentURL(url);
                    }
                    catch (Exception ex) {
                        JHSecondaryViewer.debug("error setting URL");
                    }
                }
                if (this.viewerX != -1) {
                    sw.setLocation(new Point(this.viewerX, this.viewerY));
                }
                if (this.viewerWidth != 0) {
                    sw.setSize(new Dimension(this.viewerWidth, this.viewerHeight));
                }
                sw.setDisplayed(true);
                break;
            }
            case 1: {
                if (this.hs == null) break;
                Popup popup = (Popup)Popup.getPresentation(this.hs, this.viewerName);
                if (this.ident != null) {
                    JHSecondaryViewer.debug("ident=" + this.ident);
                    try {
                        popup.setCurrentID(this.ident);
                    }
                    catch (Exception ex) {
                        JHSecondaryViewer.debug("error setting CurrentID");
                    }
                } else if (this.content != null) {
                    JHSecondaryViewer.debug("content=" + this.content);
                    try {
                        URL url = new URL(this.base, this.content);
                        popup.setCurrentURL(url);
                    }
                    catch (Exception ex) {
                        JHSecondaryViewer.debug("error setting URL");
                    }
                }
                if (this.viewerWidth != 0) {
                    popup.setSize(new Dimension(this.viewerWidth, this.viewerHeight));
                }
                popup.setInvoker(this);
                popup.setDisplayed(true);
                break;
            }
            default: {
                System.out.println("Unknown viewerStyle");
            }
        }
    }

    private static void debug(String str) {
    }
}

