/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import com.sun.java.help.search.Block;
import com.sun.java.help.search.BlockFactory;
import com.sun.java.help.search.BlockManagerParameters;
import com.sun.java.help.search.BlockProcessor;
import com.sun.java.help.search.RAFFile;
import com.sun.java.help.search.RAFFileFactory;
import java.io.IOException;

class BlockManager {
    private static RAFFileFactory factory = RAFFileFactory.create();
    private RAFFile file;
    private long blockSize;
    private boolean update;
    private final int nBlocksLimit = 64;
    private int blockTableSize;
    private BlockDescriptor[] blockTab;
    private int nBlocks = 0;
    private int oldest = 0;
    private int newest = 0;
    private BlockFactory bfactory = null;
    private static final int INCR = 256;
    private Block dummy;
    private boolean debug = false;

    public BlockManager(BlockManagerParameters params, boolean update, BlockFactory bfactory) throws IOException {
        this.bfactory = bfactory;
        this.update = update;
        this.blockSize = params.getBlockSize();
        this.debug(params.getURL().toString());
        this.file = factory.get(params.getURL(), update);
        this.debug(this.file.toString());
        this.dummy = bfactory.makeBlock();
        if (this.file.length() == 0L && update) {
            this.dummy.setBlockNumber(0);
            this.writeBlock(this.dummy);
        }
        this.blockTableSize = (int)(this.file.length() / this.blockSize);
        this.blockTab = new BlockDescriptor[this.blockTableSize];
        this.mapBlock(0, new BlockDescriptor(), bfactory.makeBlock());
    }

    public void lockBlock(int blNum) {
        this.blockTab[blNum].lock = true;
    }

    public void unlockBlock(int blNum) {
        this.blockTab[blNum].lock = false;
    }

    public void setModified(int blNum) {
        this.blockTab[blNum].modf = true;
    }

    public void close() throws IOException {
        if (this.update) {
            for (int i = 0; i < this.blockTableSize; ++i) {
                if (this.blockTab[i] == null || !this.blockTab[i].modf) continue;
                this.writeBlock(this.blockTab[i].block);
            }
        }
        this.file.close();
    }

    public Block accessBlock(int blockNumber) throws Exception {
        if (this.blockTab[blockNumber] != null) {
            this.moveToFront(blockNumber);
        } else if (this.nBlocks < 64) {
            this.mapBlock(blockNumber, new BlockDescriptor(), this.bfactory.makeBlock());
        } else {
            this.remapSomeBlock(blockNumber);
        }
        return this.blockTab[blockNumber].block;
    }

    public Block getNewBlock() throws Exception {
        int number = (int)(this.file.length() / this.blockSize);
        if (number > this.blockTableSize - 1) {
            BlockDescriptor[] newArray = new BlockDescriptor[this.blockTableSize + 256];
            System.arraycopy(this.blockTab, 0, newArray, 0, this.blockTableSize);
            this.blockTab = newArray;
            this.blockTableSize += 256;
        }
        if (this.nBlocks < 64) {
            Block bl = this.bfactory.makeBlock();
            bl.setBlockNumber(number);
            this.writeBlock(bl);
            this.addDescriptor(bl, number, new BlockDescriptor());
        } else {
            this.dummy.setBlockNumber(number);
            this.writeBlock(this.dummy);
            this.remapSomeBlock(number);
        }
        return this.blockTab[number].block;
    }

    private void mapBlock(int blockNumber, BlockDescriptor desc, Block block) throws IOException {
        this.file.seek(this.blockSize * (long)blockNumber);
        Block.readIn(this.file, block);
        this.addDescriptor(block, blockNumber, desc);
    }

    private void addDescriptor(Block block, int blockNumber, BlockDescriptor desc) {
        this.blockTab[blockNumber] = desc;
        desc.block = block;
        desc.prev = this.newest;
        this.blockTab[this.newest].next = blockNumber;
        this.newest = blockNumber;
        ++this.nBlocks;
    }

    private void remapSomeBlock(int blockNumber) throws Exception {
        int index = this.oldest;
        while (this.blockTab[index].lock && index != this.newest) {
            index = this.blockTab[index].next;
        }
        if (this.blockTab[index].lock) {
            throw new Exception("everything locked");
        }
        if (this.blockTab[index].modf) {
            this.writeBlock(this.blockTab[index].block);
        }
        --this.nBlocks;
        Block reused = this.blockTab[index].block;
        if (index == this.oldest) {
            this.oldest = this.blockTab[index].next;
        } else if (index == this.newest) {
            this.newest = this.blockTab[index].prev;
        } else {
            this.blockTab[this.blockTab[index].next].prev = this.blockTab[index].prev;
            this.blockTab[this.blockTab[index].prev].next = this.blockTab[index].next;
        }
        this.blockTab[index].reset();
        this.mapBlock(blockNumber, this.blockTab[index], reused);
        this.blockTab[index] = null;
    }

    private void moveToFront(int index) {
        if (index == this.oldest) {
            this.oldest = this.blockTab[index].next;
            this.blockTab[index].prev = this.newest;
            this.blockTab[this.newest].next = index;
            this.newest = index;
        } else if (index != this.newest) {
            this.blockTab[this.blockTab[index].next].prev = this.blockTab[index].prev;
            this.blockTab[this.blockTab[index].prev].next = this.blockTab[index].next;
            this.blockTab[index].prev = this.newest;
            this.blockTab[this.newest].next = index;
            this.newest = index;
        }
    }

    public void writeBlock(Block bl) throws IOException {
        this.file.seek(this.blockSize * (long)bl.number);
        bl.writeOut(this.file);
    }

    public void mapBlocks(BlockProcessor processor) throws IOException {
        long nBlocks = this.file.length() / this.blockSize;
        Block block = this.bfactory.makeBlock();
        this.file.seek(0L);
        int i = 0;
        while ((long)i < nBlocks) {
            processor.process(Block.readIn(this.file, block));
            ++i;
        }
    }

    private void debug(String msg) {
        if (this.debug) {
            System.err.println("Block Manager: " + msg);
        }
    }

    private class BlockDescriptor {
        public Block block = null;
        public boolean lock = false;
        public boolean modf = false;
        public int prev = 0;
        public int next = 0;

        private BlockDescriptor() {
        }

        public void reset() {
            this.modf = false;
            this.lock = false;
            this.block = null;
        }
    }
}

