/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import com.sun.java.help.search.MemoryRAFFile;
import com.sun.java.help.search.RAFFile;
import com.sun.java.help.search.TemporaryRAFFile;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public final class RAFFileFactoryOn12 {
    private static int BUF_SIZE = 2048;
    private static final boolean debug = false;

    public static RAFFile get(final URLConnection connection) throws IOException {
        RAFFile topBack = null;
        RAFFileFactoryOn12.debug("get on " + connection);
        final Permission permission = connection.getPermission();
        int dictLength = connection.getContentLength();
        try {
            topBack = (RAFFile)AccessController.doPrivileged(new PrivilegedExceptionAction(){
                RAFFile back = null;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() throws IOException {
                    InputStream in = null;
                    OutputStream out = null;
                    try {
                        File tmpFile = File.createTempFile("dict_cache", null);
                        tmpFile.deleteOnExit();
                        if (tmpFile != null) {
                            in = connection.getInputStream();
                            out = new FileOutputStream(tmpFile);
                            int read = 0;
                            byte[] buf = new byte[BUF_SIZE];
                            while ((read = in.read(buf)) != -1) {
                                out.write(buf, 0, read);
                            }
                            this.back = new TemporaryRAFFile(tmpFile, permission);
                        } else {
                            this.back = new MemoryRAFFile(connection);
                        }
                    }
                    finally {
                        if (in != null) {
                            in.close();
                        }
                        if (out != null) {
                            out.close();
                        }
                    }
                    return this.back;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            topBack = new MemoryRAFFile(connection);
        }
        catch (SecurityException se) {
            topBack = new MemoryRAFFile(connection);
        }
        return topBack;
    }

    private static void debug(String msg) {
    }
}

