/*
 * Decompiled with CFR 0.152.
 */
package javax.help;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import javax.help.BadIDException;
import javax.help.HelpSet;

public interface Map {
    public boolean isValidID(String var1, HelpSet var2);

    public Enumeration getAllIDs();

    public URL getURLFromID(ID var1) throws MalformedURLException;

    public boolean isID(URL var1);

    public ID getIDFromURL(URL var1);

    public ID getClosestID(URL var1);

    public Enumeration getIDs(URL var1);

    public static final class ID
    implements Serializable {
        public String id;
        public HelpSet hs;

        public static ID create(String id, HelpSet hs) throws BadIDException {
            if (hs == null || id == null) {
                return null;
            }
            Map map = hs.getCombinedMap();
            if (!map.isValidID(id, hs)) {
                throw new BadIDException("Not valid ID: " + id, map, id, hs);
            }
            return new ID(id, hs);
        }

        private ID(String id, HelpSet hs) throws BadIDException {
            this.id = id;
            this.hs = hs;
        }

        public HelpSet getHelpSet() {
            return this.hs;
        }

        public String getIDString() {
            return this.id;
        }

        public URL getURL() throws MalformedURLException {
            if (this.hs == null || this.id == null) {
                return null;
            }
            return this.hs.getCombinedMap().getURLFromID(this);
        }

        public boolean equals(Object o) {
            if (o instanceof ID) {
                ID id2 = (ID)o;
                return id2.id.equals(this.id) && id2.hs.equals(this.hs);
            }
            return false;
        }

        public String toString() {
            return "ID: " + this.id + ", " + this.hs;
        }
    }
}

