/*
 * Decompiled with CFR 0.152.
 */
package javax.help;

import java.lang.reflect.Method;
import java.text.Collator;
import java.util.Locale;
import javax.help.HelpSet;
import javax.help.Map;
import javax.help.TreeItem;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class MergeHelpUtilities {
    private static boolean debug = false;

    public static void mergeNodes(String masterMergeType, DefaultMutableTreeNode masterNode, DefaultMutableTreeNode slaveNode) {
        if (slaveNode.isLeaf()) {
            return;
        }
        String mergeType = MergeHelpUtilities.getMergeType(masterNode);
        if (mergeType == null) {
            mergeType = masterMergeType;
        }
        Class[] types = new Class[]{TreeNode.class, TreeNode.class};
        Object[] args = new Object[]{masterNode, slaveNode};
        try {
            Class<?> klass = Class.forName(mergeType);
            Method m = klass.getDeclaredMethod("mergeNodes", types);
            m.invoke(null, args);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException("Could not find or execute mergeNodes for " + mergeType);
        }
    }

    public static void mergeNodeChildren(String masterMergeType, DefaultMutableTreeNode node) {
        if (node.isLeaf()) {
            return;
        }
        String mergeType = MergeHelpUtilities.getMergeType(node);
        if (mergeType == null) {
            mergeType = masterMergeType;
        }
        Class[] types = new Class[]{TreeNode.class};
        Object[] args = new Object[]{node};
        try {
            Class<?> klass = Class.forName(mergeType);
            Method m = klass.getDeclaredMethod("mergeNodeChildren", types);
            m.invoke(null, args);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException("Could not find or execute mergeNodeChildren for " + mergeType);
        }
    }

    private static String getMergeType(DefaultMutableTreeNode node) {
        TreeItem item = (TreeItem)node.getUserObject();
        if (item == null) {
            return null;
        }
        return item.getMergeType();
    }

    public static String getNodeName(DefaultMutableTreeNode node) {
        if (node == null) {
            return null;
        }
        TreeItem item = (TreeItem)node.getUserObject();
        if (item == null) {
            return null;
        }
        return item.getName();
    }

    public static DefaultMutableTreeNode getChildWithName(DefaultMutableTreeNode parent, String name) {
        DefaultMutableTreeNode childAtI = null;
        DefaultMutableTreeNode result = null;
        for (int i = 0; i < parent.getChildCount(); ++i) {
            childAtI = (DefaultMutableTreeNode)parent.getChildAt(i);
            if (!MergeHelpUtilities.getNodeName(childAtI).equals(name)) continue;
            result = childAtI;
            break;
        }
        return result;
    }

    public static Locale getLocale(DefaultMutableTreeNode node) {
        Locale locale = null;
        TreeItem item = (TreeItem)node.getUserObject();
        if (item != null) {
            locale = item.getLocale();
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    public static int compareNames(DefaultMutableTreeNode master, DefaultMutableTreeNode slave) {
        String slaveName;
        TreeItem masterItem = (TreeItem)master.getUserObject();
        MergeHelpUtilities.debug("haveEqualName - master:" + masterItem);
        TreeItem slaveItem = (TreeItem)slave.getUserObject();
        MergeHelpUtilities.debug("haveEqualName - slave:" + slaveItem);
        String masterName = masterItem.getName();
        if (masterName == null) {
            masterName = " ";
        }
        if ((slaveName = slaveItem.getName()) == null) {
            slaveName = " ";
        }
        Collator collator = Collator.getInstance(MergeHelpUtilities.getLocale(master));
        return collator.compare(masterName, slaveName);
    }

    public static boolean haveEqualID(DefaultMutableTreeNode master, DefaultMutableTreeNode slave) {
        TreeItem masterItem = (TreeItem)master.getUserObject();
        TreeItem slaveItem = (TreeItem)slave.getUserObject();
        if (masterItem.getID() == null) {
            return slaveItem.getID() == null;
        }
        if (slaveItem.getID() == null) {
            return false;
        }
        Map.ID masterMapID = masterItem.getID();
        Map.ID slaveMapID = slaveItem.getID();
        if (masterMapID.id == null) {
            return slaveMapID.id == null;
        }
        if (slaveMapID.id == null) {
            return false;
        }
        return masterMapID.id.equals(slaveMapID.id);
    }

    public static void markNodes(DefaultMutableTreeNode master, DefaultMutableTreeNode slave) {
        MergeHelpUtilities.debug("MarkNodes");
        TreeItem masterItem = (TreeItem)master.getUserObject();
        TreeItem slaveItem = (TreeItem)slave.getUserObject();
        HelpSet masterHS = masterItem.getHelpSet();
        HelpSet slaveHS = slaveItem.getHelpSet();
        if (masterItem.getName() != null) {
            masterItem.setName(masterItem.getName() + "(" + masterHS.getTitle() + ")");
        } else {
            masterItem.setName(masterItem.getName() + "(" + masterHS.getTitle() + ")");
        }
        if (slaveItem.getName() != null) {
            slaveItem.setName(slaveItem.getName() + "(" + slaveHS.getTitle() + ")");
        } else {
            slaveItem.setName(slaveItem.getName() + "(" + slaveHS.getTitle() + ")");
        }
    }

    private static void debug(String msg) {
        if (debug) {
            System.out.println("MergeHelpUtilities :" + msg);
        }
    }
}

