/*
 * Decompiled with CFR 0.152.
 */
package javax.help;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Method;
import java.util.Vector;
import javax.help.HelpSet;
import javax.help.JHelpContentViewer;
import javax.help.Presentation;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

public class Popup
extends Presentation
implements ActionListener {
    private JHelpContentViewer jheditor;
    private Component invoker = null;
    private JWindow window = null;
    private Vector grabbed = null;
    private PopupComponentAdapter pca = null;
    private PopupKeyAdapter pka = null;
    private PopupMouseAdapter pma = null;
    private PopupMouseWheelListener pmwl = null;
    private PopupWindowAdapter pwa = null;
    private Rectangle internalBounds = null;
    private static final String SHOW = "show";
    private static final String CANCEL = "cancel";
    private static boolean on1dot4 = false;
    static Popup currentPopup;
    private static final boolean debug = false;

    private Popup(HelpSet hs) {
        this.setHelpSet(hs);
    }

    public static Presentation getPresentation(HelpSet hs, String name) {
        Popup thePopup = new Popup(hs);
        if (hs != null) {
            HelpSet.Presentation presentation = null;
            if (name != null) {
                presentation = hs.getPresentation(name);
            }
            if (presentation == null) {
                presentation = hs.getDefaultPresentation();
            }
            thePopup.setHelpSetPresentation(presentation);
        }
        return thePopup;
    }

    public Component getInvoker() {
        return this.invoker;
    }

    public void setInvoker(Component invoker) {
        this.invoker = invoker;
        if (invoker instanceof JMenuItem) {
            while (!(this.invoker instanceof JMenu)) {
                this.invoker = this.invoker.getParent();
                if (!(this.invoker instanceof JPopupMenu)) continue;
                this.invoker = ((JPopupMenu)this.invoker).getInvoker();
            }
        }
        if (this.invoker == null) {
            throw new IllegalArgumentException("invoker");
        }
    }

    public Rectangle getInvokerInternalBounds() {
        return this.internalBounds;
    }

    public void setInvokerInternalBounds(Rectangle bounds) {
        this.internalBounds = bounds;
    }

    private JWindow getWindow() {
        return this.window;
    }

    public void setDisplayed(boolean b) {
        JRootPane root;
        Container top = this.getTopMostContainer();
        if (this.window == null && !b) {
            return;
        }
        if (this.window == null) {
            this.window = new JWindow((Window)this.getTopMostContainer());
            this.jheditor = new JHelpContentViewer(this.getHelpModel());
            this.window.getRootPane().setBorder(BorderFactory.createLineBorder(Color.black, 2));
            this.window.getContentPane().add((Component)this.jheditor, "Center");
        }
        if (this.grabbed == null) {
            this.grabbed = new Vector();
            this.pca = new PopupComponentAdapter();
            this.pma = new PopupMouseAdapter();
            this.pwa = new PopupWindowAdapter();
            this.pka = new PopupKeyAdapter();
            if (on1dot4) {
                this.pmwl = new PopupMouseWheelListener();
            }
        } else {
            this.grabbed.clear();
        }
        this.grabContainer(top);
        this.window.addWindowListener(this.pwa);
        if (on1dot4) {
            try {
                Class[] types = new Class[]{Class.forName("java.awt.event.WindowFocusListener")};
                Object[] args = new Object[]{this.pwa};
                Method m = this.window.getClass().getMethod("addWindowFocusListener", types);
                m.invoke((Object)this.window, args);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if ((root = this.getRootPane()) != null) {
            root.registerKeyboardAction(this, CANCEL, KeyStroke.getKeyStroke(27, 0), 1);
        } else if (top != null) {
            top.addKeyListener(this.pka);
        }
        this.window.getRootPane().registerKeyboardAction(this, CANCEL, KeyStroke.getKeyStroke(27, 0), 1);
        if (b) {
            this.showPopup();
        } else {
            this.cancelPopup();
        }
    }

    public boolean isDisplayed() {
        return this.window != null;
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command == CANCEL) {
            this.cancelPopup();
        }
    }

    private void showPopup() {
        if (currentPopup != null && SwingUtilities.getAncestorOfClass(JWindow.class, this.invoker) == currentPopup.getWindow()) {
            this.setInvoker(currentPopup.getInvoker());
        }
        Rectangle popupBounds = this.computePopupBounds(this.getSize());
        this.jheditor.setPreferredSize(new Dimension(popupBounds.width, popupBounds.height));
        this.window.setBounds(popupBounds.x, popupBounds.y, popupBounds.width, popupBounds.height);
        this.window.pack();
        this.window.show();
        currentPopup = this;
    }

    private Rectangle computePopupBounds(Dimension popupSize) {
        Rectangle absBounds;
        Point p;
        boolean inModalDialog = this.inModalDialog();
        if (inModalDialog) {
            Dialog dlg = this.getDialog();
            if (dlg instanceof JDialog) {
                JRootPane rp = ((JDialog)dlg).getRootPane();
                p = rp.getLocationOnScreen();
                absBounds = rp.getBounds();
                absBounds.x = p.x;
                absBounds.y = p.y;
            } else {
                absBounds = dlg.getBounds();
            }
        } else {
            Dimension scrSize = Toolkit.getDefaultToolkit().getScreenSize();
            absBounds = new Rectangle(0, 0, scrSize.width, scrSize.height);
        }
        if (this.internalBounds == null) {
            this.internalBounds = this.invoker.getBounds();
        }
        Popup.debug("\nabsBounds=" + absBounds + "\ninternalBounds=" + this.internalBounds + "\n");
        p = new Point(this.internalBounds.x, this.internalBounds.y + this.internalBounds.height);
        SwingUtilities.convertPointToScreen(p, this.invoker);
        Rectangle br = new Rectangle(p.x, p.y, popupSize.width, popupSize.height);
        Popup.debug("below/right " + br + "\n");
        if (SwingUtilities.isRectangleContainingRectangle(absBounds, br)) {
            return br;
        }
        Rectangle bradjust = new Rectangle(br);
        bradjust.setLocation(br.x + this.internalBounds.width - br.width, br.y);
        Popup.debug("below/right adjust " + bradjust + "\n");
        if (SwingUtilities.isRectangleContainingRectangle(absBounds, bradjust)) {
            return bradjust;
        }
        Rectangle ar = new Rectangle(br.x, br.y - (br.height + this.internalBounds.height), br.width, br.height);
        Popup.debug("above/right " + ar + "\n");
        if (SwingUtilities.isRectangleContainingRectangle(absBounds, ar)) {
            return ar;
        }
        Rectangle aradjust = new Rectangle(ar);
        aradjust.setLocation(ar.x + this.internalBounds.width - ar.width, aradjust.y);
        Popup.debug("above/right adjust " + aradjust + "\n");
        if (SwingUtilities.isRectangleContainingRectangle(absBounds, aradjust)) {
            return aradjust;
        }
        p = new Point(this.internalBounds.x + this.internalBounds.width, this.internalBounds.y);
        SwingUtilities.convertPointToScreen(p, this.invoker);
        Rectangle rb = new Rectangle(p.x, p.y, popupSize.width, popupSize.height);
        Popup.debug("right/below " + rb + "\n");
        if (SwingUtilities.isRectangleContainingRectangle(absBounds, rb)) {
            return rb;
        }
        Rectangle rbadjust = new Rectangle(rb);
        rbadjust.setLocation(rbadjust.x, rb.y + this.internalBounds.height - rb.height);
        Popup.debug("right/below adjust " + rbadjust + "\n");
        if (SwingUtilities.isRectangleContainingRectangle(absBounds, rbadjust)) {
            return rbadjust;
        }
        Rectangle lb = new Rectangle(rb.x - (rb.width + this.internalBounds.width), rb.y, rb.width, rb.height);
        Popup.debug("left/below " + lb + "\n");
        if (SwingUtilities.isRectangleContainingRectangle(absBounds, lb)) {
            return lb;
        }
        Rectangle lbadjust = new Rectangle(lb);
        lbadjust.setLocation(lbadjust.x, lb.y + this.internalBounds.height - lb.height);
        Popup.debug("left/below adjust " + lbadjust + "\n");
        if (SwingUtilities.isRectangleContainingRectangle(absBounds, lbadjust)) {
            return lbadjust;
        }
        Rectangle cover = new Rectangle(0, 0, popupSize.width, popupSize.height);
        Popup.debug("upper left hand corner " + cover + "\n");
        if (SwingUtilities.isRectangleContainingRectangle(absBounds, cover)) {
            return cover;
        }
        SwingUtilities.computeIntersection(absBounds.x, absBounds.y, absBounds.width, absBounds.height, cover);
        return cover;
    }

    private Container getTopMostContainer() {
        Container p;
        if (this.invoker == null) {
            return null;
        }
        Container container = p = this.invoker instanceof Container ? (Container)this.invoker : this.invoker.getParent();
        while (p != null) {
            Component comp;
            if (p instanceof JPopupMenu && (comp = ((JPopupMenu)p).getInvoker()) instanceof Container) {
                p = (Container)comp;
            }
            if (p instanceof Window || p instanceof Applet) {
                return p;
            }
            p = p.getParent();
        }
        return null;
    }

    private JRootPane getRootPane() {
        Container parent = null;
        JRootPane pane = null;
        if (this.invoker == null || !(this.invoker instanceof JComponent)) {
            return null;
        }
        pane = ((JComponent)this.invoker).getRootPane();
        if (pane != null) {
            return pane;
        }
        Container container = parent = this.invoker instanceof Container ? (Container)this.invoker : this.invoker.getParent();
        while (!(parent == null || parent instanceof JDialog || parent instanceof JWindow || parent instanceof JFrame)) {
            Component comp;
            if (parent instanceof JPopupMenu && (comp = ((JPopupMenu)parent).getInvoker()) instanceof Container) {
                parent = (Container)comp;
            }
            parent = parent.getParent();
        }
        if (parent instanceof JFrame) {
            pane = ((JFrame)parent).getRootPane();
        } else if (parent instanceof JWindow) {
            pane = ((JWindow)parent).getRootPane();
        } else if (parent instanceof JDialog) {
            pane = ((JDialog)parent).getRootPane();
        }
        return pane;
    }

    private Dialog getDialog() {
        Container parent;
        if (this.invoker == null) {
            return null;
        }
        Container container = parent = this.invoker instanceof Container ? (Container)this.invoker : this.invoker.getParent();
        while (parent != null && !(parent instanceof Dialog)) {
            parent = parent.getParent();
        }
        if (parent instanceof Dialog) {
            return (Dialog)parent;
        }
        return null;
    }

    private boolean inModalDialog() {
        return this.getDialog() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void grabContainer(Container c) {
        if (c instanceof Window) {
            ((Window)c).addWindowListener(this.pwa);
            ((Window)c).addComponentListener(this.pca);
            this.grabbed.addElement(c);
        }
        Object object = c.getTreeLock();
        synchronized (object) {
            int ncomponents = c.getComponentCount();
            Component[] component = c.getComponents();
            for (int i = 0; i < ncomponents; ++i) {
                Component comp = component[i];
                if (!comp.isVisible()) continue;
                comp.addMouseListener(this.pma);
                comp.addMouseMotionListener(this.pma);
                if (on1dot4) {
                    try {
                        Class[] types = new Class[]{Class.forName("java.awt.event.MouseWheelListener")};
                        Object[] args = new Object[]{this.pmwl};
                        Method m = this.window.getClass().getMethod("addMouseWheelListener", types);
                        m.invoke((Object)comp, args);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                this.grabbed.addElement(comp);
                if (!(comp instanceof Container)) continue;
                Container cont = (Container)comp;
                this.grabContainer(cont);
            }
        }
    }

    void ungrabContainers() {
        int c = this.grabbed.size();
        for (int i = 0; i < c; ++i) {
            Component cpn = (Component)this.grabbed.elementAt(i);
            if (cpn instanceof Window) {
                ((Window)cpn).removeWindowListener(this.pwa);
                ((Window)cpn).removeComponentListener(this.pca);
                continue;
            }
            cpn.removeMouseListener(this.pma);
            cpn.removeMouseMotionListener(this.pma);
            if (!on1dot4) continue;
            try {
                Class[] types = new Class[]{Class.forName("java.awt.event.MouseWheelListener")};
                Object[] args = new Object[]{this.pmwl};
                Method m = this.window.getClass().getMethod("removeMouseWheelListener", types);
                m.invoke((Object)cpn, args);
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        this.grabbed = null;
    }

    private void cancelPopup() {
        Container top = this.getTopMostContainer();
        this.ungrabContainers();
        JRootPane root = this.getRootPane();
        if (root != null) {
            root.unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0));
        } else if (top != null) {
            top.removeKeyListener(this.pka);
        }
        this.window.removeWindowListener(this.pwa);
        if (on1dot4) {
            try {
                Class[] types = new Class[]{Class.forName("java.awt.event.WindowFocusListener")};
                Object[] args = new Object[]{this.pwa};
                Method m = this.window.getClass().getMethod("removeWindowFocusListener", types);
                m.invoke((Object)this.window, args);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.window.getRootPane().unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0));
        this.window.dispose();
        this.window = null;
        this.jheditor = null;
        currentPopup = null;
    }

    private static void debug(Object msg) {
    }

    static {
        try {
            Class<?> klass = Class.forName("java.awt.event.MouseWheelEvent");
            on1dot4 = klass == null;
        }
        catch (ClassNotFoundException e) {
            on1dot4 = false;
        }
        currentPopup = null;
    }

    private class PopupKeyAdapter
    extends KeyAdapter {
        private PopupKeyAdapter() {
        }

        public void keyReleased(KeyEvent e) {
            int code = e.getKeyCode();
            if (code == 27) {
                Popup.this.cancelPopup();
            }
        }
    }

    private class PopupComponentAdapter
    extends ComponentAdapter {
        private PopupComponentAdapter() {
        }

        public void componentResized(ComponentEvent e) {
            Popup.this.cancelPopup();
        }

        public void componentMoved(ComponentEvent e) {
            Popup.this.cancelPopup();
        }

        public void componentShown(ComponentEvent e) {
            Popup.this.cancelPopup();
        }

        public void componentHidden(ComponentEvent e) {
            Popup.this.cancelPopup();
        }
    }

    private class PopupMouseWheelListener
    implements MouseWheelListener {
        private PopupMouseWheelListener() {
        }

        public void mouseWheelMoved(MouseWheelEvent e) {
            Popup.this.cancelPopup();
        }
    }

    private class PopupMouseAdapter
    extends MouseInputAdapter {
        private PopupMouseAdapter() {
        }

        public void mousePressed(MouseEvent e) {
            Popup.this.cancelPopup();
        }
    }

    private class PopupWindowAdapter
    extends WindowAdapter {
        private PopupWindowAdapter() {
        }

        public void windowClosing(WindowEvent e) {
            Popup.this.cancelPopup();
        }

        public void windowClosed(WindowEvent e) {
            Popup.this.cancelPopup();
        }

        public void windowIconified(WindowEvent e) {
            Popup.this.cancelPopup();
        }

        public void windowGainedFocus(WindowEvent e) {
            Popup.this.window.toFront();
        }
    }
}

