/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.impl;

public class HeaderParser {
    String raw;
    String[][] tab;

    public HeaderParser(String raw) {
        this.raw = raw;
        this.tab = new String[10][2];
        this.parse();
    }

    private void parse() {
        if (this.raw != null) {
            this.raw = this.raw.trim();
            char[] ca = this.raw.toCharArray();
            int beg = 0;
            int end = 0;
            int i = 0;
            boolean inKey = true;
            boolean inQuote = false;
            int len = ca.length;
            while (end < len) {
                char c = ca[end];
                if (c == '=') {
                    this.tab[i][0] = new String(ca, beg, end - beg).toLowerCase();
                    inKey = false;
                    beg = ++end;
                    continue;
                }
                if (c == '\"') {
                    if (inQuote) {
                        this.tab[i++][1] = new String(ca, beg, end - beg);
                        inQuote = false;
                        while (++end < len && (ca[end] == ' ' || ca[end] == ',')) {
                        }
                        inKey = true;
                        beg = end;
                        continue;
                    }
                    inQuote = true;
                    beg = ++end;
                    continue;
                }
                if (c == ' ' || c == ',') {
                    if (inQuote) {
                        ++end;
                        continue;
                    }
                    if (inKey) {
                        this.tab[i++][0] = new String(ca, beg, end - beg).toLowerCase();
                    } else {
                        this.tab[i++][1] = new String(ca, beg, end - beg);
                    }
                    while (end < len && (ca[end] == ' ' || ca[end] == ',')) {
                        ++end;
                    }
                    inKey = true;
                    beg = end;
                    continue;
                }
                ++end;
            }
            if (--end > beg) {
                if (!inKey) {
                    this.tab[i++][1] = ca[end] == '\"' ? new String(ca, beg, end - beg) : new String(ca, beg, end - beg + 1);
                } else {
                    this.tab[i][0] = new String(ca, beg, end - beg + 1).toLowerCase();
                }
            } else if (end == beg) {
                if (!inKey) {
                    this.tab[i++][1] = ca[end] == '\"' ? String.valueOf(ca[end - 1]) : String.valueOf(ca[end]);
                } else {
                    this.tab[i][0] = String.valueOf(ca[end]).toLowerCase();
                }
            }
        }
    }

    public String findKey(int i) {
        if (i < 0 || i > 10) {
            return null;
        }
        return this.tab[i][0];
    }

    public String findValue(int i) {
        if (i < 0 || i > 10) {
            return null;
        }
        return this.tab[i][1];
    }

    public String findValue(String key) {
        return this.findValue(key, null);
    }

    public String findValue(String k, String Default) {
        if (k == null) {
            return Default;
        }
        k.toLowerCase();
        for (int i = 0; i < 10; ++i) {
            if (this.tab[i][0] == null) {
                return Default;
            }
            if (!k.equals(this.tab[i][0])) continue;
            return this.tab[i][1];
        }
        return Default;
    }

    public int findInt(String k, int Default) {
        try {
            return Integer.parseInt(this.findValue(k, String.valueOf(Default)));
        }
        catch (Throwable t) {
            return Default;
        }
    }
}

