/*
 * Decompiled with CFR 0.152.
 */
package javax.help;

import java.net.URL;
import java.util.Hashtable;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.help.DefaultHelpModel;
import javax.help.HelpModel;
import javax.help.NavigatorView;
import javax.help.SwingHelpUtilities;
import javax.help.TreeItem;
import javax.help.UnsupportedOperationException;
import javax.help.event.HelpModelListener;
import javax.help.plaf.HelpNavigatorUI;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class JHelpNavigator
extends JComponent
implements Accessible {
    protected HelpModel helpModel;
    protected String type;
    private static String jhPackageName;
    private NavigatorView view;
    private TreeItem[] selectedItems;
    private static final boolean debug = false;

    public JHelpNavigator(NavigatorView view) {
        this.view = view;
        if (view != null) {
            this.setModel(new DefaultHelpModel(view.getHelpSet()));
        } else {
            this.setModel(null);
        }
        this.updateUI();
    }

    public JHelpNavigator(NavigatorView view, HelpModel model) {
        this.view = view;
        this.setModel(model);
        this.updateUI();
    }

    public TreeItem[] getSelectedItems() {
        if (this.selectedItems == null) {
            return new TreeItem[0];
        }
        return (TreeItem[])this.selectedItems.clone();
    }

    public void setSelectedItems(TreeItem[] selectedItems) {
        TreeItem[] oldValue = this.selectedItems;
        this.selectedItems = selectedItems;
        this.firePropertyChange("SelectedItemsChangedProperty", oldValue, this.selectedItems);
    }

    public String getUIClassID() {
        return "HelpNavigatorUI";
    }

    public boolean canMerge(NavigatorView view) {
        return false;
    }

    public void merge(NavigatorView view) {
        throw new UnsupportedOperationException();
    }

    public void remove(NavigatorView view) {
        throw new UnsupportedOperationException();
    }

    public String getNavigatorName() {
        return this.view.getName();
    }

    public NavigatorView getNavigatorView() {
        return this.view;
    }

    public String getNavigatorLabel() {
        return this.view.getLabel();
    }

    public String getNavigatorLabel(Locale locale) {
        return this.view.getLabel(locale);
    }

    public Icon getIcon() {
        return this.getUI().getIcon();
    }

    public void setModel(HelpModel newModel) {
        HelpModel oldModel = this.helpModel;
        if (newModel != oldModel) {
            this.helpModel = newModel;
            this.firePropertyChange("helpModel", oldModel, this.helpModel);
            this.invalidate();
        }
    }

    public HelpModel getModel() {
        return this.helpModel;
    }

    public void setUI(HelpNavigatorUI ui) {
        if ((HelpNavigatorUI)this.ui != ui) {
            super.setUI(ui);
        }
    }

    public HelpNavigatorUI getUI() {
        return (HelpNavigatorUI)this.ui;
    }

    public void updateUI() {
        SwingHelpUtilities.installUIDefaults();
        this.setUI((HelpNavigatorUI)UIManager.getUI(this));
        this.invalidate();
    }

    public void addHelpModelListener(HelpModelListener l) {
        this.getModel().addHelpModelListener(l);
    }

    public void removeHelpModelListener(HelpModelListener l) {
        this.getModel().removeHelpModelListener(l);
    }

    protected static Hashtable createParams(URL data) {
        Hashtable<String, String> back = new Hashtable<String, String>();
        back.put("data", data.toString());
        return back;
    }

    private static void debug(String str) {
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJHelpNavigator();
        }
        return this.accessibleContext;
    }

    static {
        SwingHelpUtilities.installLookAndFeelDefaults();
    }

    protected class AccessibleJHelpNavigator
    extends JComponent.AccessibleJComponent {
        protected AccessibleJHelpNavigator() {
            super(JHelpNavigator.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PANEL;
        }
    }
}

