/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.registration;

import com.sun.enterprise.registration.RegistrationAccount;
import com.sun.enterprise.registration.RegistrationService;
import com.sun.enterprise.registration.glassfish.RegistrationUtil;
import com.sun.enterprise.registration.impl.SOAccount;
import com.sun.enterprise.registration.impl.SysnetRegistrationService;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import com.sun.jsftemplating.util.Util;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import javax.faces.context.FacesContext;
import org.glassfish.admingui.common.util.GuiUtil;

public class RegisterHandlers {
    public static void showRegistration(HandlerContext handlerCtx) {
        RegistrationService regService = RegisterHandlers.getRegistrationService();
        if (regService == null) {
            GuiUtil.getLogger().info("No RegistrationService available.");
            handlerCtx.setOutputValue("value", (Object)false);
            return;
        }
        if (RegisterHandlers.getRegistrationStatus() == RegistrationService.RegistrationStatus.NOT_REGISTERED && !regService.isRegistrationEnabled()) {
            GuiUtil.getLogger().info("Product is not registered and registration is not Enabled");
            handlerCtx.setOutputValue("value", (Object)false);
            return;
        }
        handlerCtx.setOutputValue("value", (Object)true);
    }

    public static void testIfRegistered(HandlerContext handlerCtx) {
        if (GuiUtil.getSessionValue((String)"showRegTreeNode") == null) {
            GuiUtil.setSessionValue((String)"showRegTreeNode", (Object)(RegisterHandlers.getRegistrationStatus() != RegistrationService.RegistrationStatus.REGISTERED ? 1 : 0));
        }
    }

    private static RegistrationService.RegistrationStatus getRegistrationStatus() {
        RegistrationService.RegistrationStatus regStatus = RegistrationService.RegistrationStatus.NOT_REGISTERED;
        try {
            RegistrationService regService = RegisterHandlers.getRegistrationService();
            if (regService != null) {
                regStatus = regService.getRegistrationStatus();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return regStatus;
    }

    private static RegistrationService.RegistrationReminder getRegistrationReminder() {
        try {
            RegistrationService regService = RegisterHandlers.getRegistrationService();
            if (regService.getRegistrationStatus() == RegistrationService.RegistrationStatus.REGISTERED) {
                return RegistrationService.RegistrationReminder.DONT_ASK_FOR_REGISTRATION;
            }
            if (!regService.isRegistrationEnabled()) {
                return RegistrationService.RegistrationReminder.DONT_ASK_FOR_REGISTRATION;
            }
            RegistrationService.RegistrationReminder rem = regService.getRegistrationReminder();
            return rem;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return RegistrationService.RegistrationReminder.DONT_ASK_FOR_REGISTRATION;
        }
    }

    private static void setRegistrationReminder(RegistrationService.RegistrationReminder value) {
        try {
            RegistrationService regService = RegisterHandlers.getRegistrationService();
            regService.setRegistrationReminder(value);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void setRegistrationDontAsk(HandlerContext handlerCtx) {
        RegisterHandlers.setRegistrationReminder(RegistrationService.RegistrationReminder.DONT_ASK_FOR_REGISTRATION);
        GuiUtil.setSessionValue((String)"dontAskRegistrationInThisSession", (Object)Boolean.TRUE);
    }

    public static void setRegistrationRemindLater(HandlerContext handlerCtx) {
        RegisterHandlers.setRegistrationReminder(RegistrationService.RegistrationReminder.REMIND_LATER);
        GuiUtil.setSessionValue((String)"dontAskRegistrationInThisSession", (Object)Boolean.TRUE);
    }

    private static RegistrationService getRegistrationService() {
        try {
            File registryFile = RegistrationUtil.getServiceTagRegistry();
            return new SysnetRegistrationService(registryFile);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static RegistrationService getRegistrationService(String proxyHost, int proxyPort) {
        try {
            File registryFile = RegistrationUtil.getServiceTagRegistry();
            return new SysnetRegistrationService(registryFile, proxyHost, proxyPort);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static void askRegistration(HandlerContext handlerCtx) {
        String thisSession = (String)handlerCtx.getInputValue("thisSession");
        if (!GuiUtil.isEmpty((String)thisSession)) {
            handlerCtx.setOutputValue("askRegistration", (Object)false);
            return;
        }
        RegistrationService.RegistrationReminder reminder = RegisterHandlers.getRegistrationReminder();
        if (reminder == RegistrationService.RegistrationReminder.DONT_ASK_FOR_REGISTRATION) {
            GuiUtil.setSessionValue((String)"dontAskRegistrationInThisSession", (Object)Boolean.TRUE);
            handlerCtx.setOutputValue("askRegistration", (Object)false);
            return;
        }
        if (reminder == RegistrationService.RegistrationReminder.ASK_FOR_REGISTRATION) {
            handlerCtx.setOutputValue("askRegistration", (Object)true);
            return;
        }
        String cookie = (String)handlerCtx.getInputValue("cookie");
        if (GuiUtil.isEmpty((String)cookie) || cookie.equals("null")) {
            handlerCtx.setOutputValue("askRegistration", (Object)true);
        } else {
            GuiUtil.setSessionValue((String)"dontAskRegistrationInThisSession", (Object)Boolean.TRUE);
            handlerCtx.setOutputValue("askRegistration", (Object)false);
        }
    }

    public static void registerAS(HandlerContext handlerCtx) {
        String accountStatus = (String)handlerCtx.getInputValue("accountStatus");
        if ("hasAccount".equals(accountStatus)) {
            String userName = (String)handlerCtx.getInputValue("userName");
            String pswd = (String)handlerCtx.getInputValue("pswd");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("userID", userName);
            map.put("password", pswd);
            Object[] accountParams = new Object[]{map};
            try {
                SOAccount account = new SOAccount(map);
                String proxy = (String)handlerCtx.getInputValue("proxy");
                String port = (String)handlerCtx.getInputValue("port");
                RegistrationService regService = RegisterHandlers.getRegServiceForRegister(proxy, port);
                if (regService == null) {
                    GuiUtil.handleError((HandlerContext)handlerCtx, (String)GuiUtil.getMessage((String)"reg.error.noRegService"));
                    return;
                }
                regService.register((RegistrationAccount)account);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
                return;
            }
        }
        String emailAdr = (String)handlerCtx.getInputValue("emailAdr");
        String newPswd = (String)handlerCtx.getInputValue("newPswd");
        String screenName = (String)handlerCtx.getInputValue("screenName");
        String firstName = (String)handlerCtx.getInputValue("firstName");
        String lastName = (String)handlerCtx.getInputValue("lastName");
        String companyName = (String)handlerCtx.getInputValue("companyName");
        String country = (String)handlerCtx.getInputValue("country");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("email", emailAdr);
        map.put("password", newPswd);
        map.put("country", country);
        if (GuiUtil.isEmpty((String)screenName)) {
            screenName = emailAdr;
        }
        map.put("userID", screenName);
        if (GuiUtil.isEmpty((String)firstName)) {
            firstName = " ";
        }
        map.put("firstName", firstName);
        if (GuiUtil.isEmpty((String)lastName)) {
            lastName = " ";
        }
        map.put("lastName", lastName);
        if (!GuiUtil.isEmpty((String)companyName)) {
            map.put("company", companyName);
        }
        Object[] accountParams = new Object[]{map};
        try {
            String proxy = (String)handlerCtx.getInputValue("newProxy");
            String port = (String)handlerCtx.getInputValue("newPort");
            RegistrationService regService = RegisterHandlers.getRegServiceForRegister(proxy, port);
            if (regService == null) {
                GuiUtil.handleError((HandlerContext)handlerCtx, (String)GuiUtil.getMessage((String)"reg.error.noRegService"));
                return;
            }
            SOAccount account = new SOAccount(map);
            regService.createRegistrationAccount((RegistrationAccount)account);
            regService.register((RegistrationAccount)account);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
            return;
        }
    }

    private static RegistrationService getRegServiceForRegister(String proxy, String port) {
        if (!GuiUtil.isEmpty((String)proxy) && !GuiUtil.isEmpty((String)port)) {
            return RegisterHandlers.getRegistrationService(proxy, Integer.parseInt(port));
        }
        return RegisterHandlers.getRegistrationService();
    }

    public static void getCountryListForRegistration(HandlerContext handlerCtx) {
        ArrayList<String> lab = new ArrayList<String>();
        lab.add("United States");
        lab.add("Albania");
        handlerCtx.setOutputValue("labels", lab);
        handlerCtx.setOutputValue("values", lab);
        Locale locale = Util.getLocale((FacesContext)FacesContext.getCurrentInstance());
        RegistrationService regService = RegisterHandlers.getRegistrationService();
        List countryList = regService.getAvailableCountries(locale);
        handlerCtx.setOutputValue("labels", countryList.get(0));
        handlerCtx.setOutputValue("values", countryList.get(1));
    }

    public static void getSupportImages(HandlerContext handlerCtx) {
        int maxImageCount = 26;
        ArrayList<String> result = new ArrayList<String>();
        int cnt = (Integer)handlerCtx.getInputValue("count");
        Random random = new Random();
        for (int i = 0; i < cnt; ++i) {
            int num;
            String imgName;
            do {
                num = Math.abs(random.nextInt() % maxImageCount);
            } while (result.contains(imgName = "square-" + num + ".gif"));
            result.add(imgName);
        }
        handlerCtx.setOutputValue("imageList", result);
    }

    public static void getIssueQueryString(HandlerContext handlerCtx) {
        GregorianCalendar current = new GregorianCalendar();
        ((Calendar)current).add(10, -168);
        int month = Integer.parseInt("" + current.get(2)) + 1;
        String startTime = "" + current.get(1) + "-" + month + "-" + current.get(5);
        String query = "https://glassfish.dev.java.net/issues/buglist.cgi?component=glassfish&issue_status=RESOLVED&chfield=issue_status&chfieldto=Now&cmdtype=doit&chfieldfrom=" + startTime;
        handlerCtx.setOutputValue("query", (Object)query);
    }

    public static void getProductInstanceURN(HandlerContext handlerCtx) {
        Map sessionMap = handlerCtx.getFacesContext().getExternalContext().getSessionMap();
        String productInstanceURN = (String)sessionMap.get("productInstanceURN");
        if (!GuiUtil.isEmpty((String)productInstanceURN)) {
            return;
        }
        try {
            String urn = RegistrationUtil.getGFProductURN();
            sessionMap.put("productInstanceURN", urn);
        }
        catch (Exception ex) {
            System.out.println("!!!!!! Cannot get ProductURN, set to '0000' ");
            sessionMap.put("productInstanceURN", "0000");
            ex.printStackTrace();
        }
    }
}

