/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import com.sun.java.help.search.DBPartParameters;
import com.sun.java.help.search.Schema;
import java.net.URL;

class BlockManagerParameters
extends DBPartParameters {
    private URL url;
    private int blockSize;
    protected int root;
    private boolean debug = false;

    public BlockManagerParameters(Schema schema, String partName) throws Exception {
        super(schema, partName);
        this.url = schema.getURL(partName);
        this.debug(this.url.toString());
    }

    public boolean readState() {
        if (this.parametersKnown()) {
            this.blockSize = this.integerParameter("bs");
            this.root = this.integerParameter("rt");
            return true;
        }
        return false;
    }

    public void updateSchema(String params) {
        super.updateSchema("bs=" + this.blockSize + " rt=" + this.root + " fl=-1 " + params);
    }

    public BlockManagerParameters(URL url, int blockSize, int root) {
        this.url = url;
        this.blockSize = blockSize;
        this.root = root;
    }

    public URL getURL() {
        return this.url;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public void setBlockSize(int size) {
        this.blockSize = size;
    }

    public int getRootPosition() {
        return this.root;
    }

    public void setRoot(int root) {
        this.root = root;
    }

    private void debug(String msg) {
        if (this.debug) {
            System.err.println("Block Manager Parameters: " + msg);
        }
    }
}

