/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

class ConceptLocation {
    private int _concept;
    private int _begin;
    private int _end;
    private static ConceptLocationSorter _cComp;
    private static ConceptLocationSorter _pComp;

    private ConceptLocation() {
        _cComp = new ConceptSorter();
        _pComp = new PositionSorter();
    }

    public ConceptLocation(int conceptID, int begin, int end) {
        this._concept = conceptID;
        this._begin = begin;
        this._end = end;
    }

    public boolean equals(ConceptLocation other) {
        return this._concept == other._concept && this._begin == other._begin && this._end == other._end;
    }

    public void setConcept(int concept) {
        this._concept = concept;
    }

    public int getConcept() {
        return this._concept;
    }

    public int getBegin() {
        return this._begin;
    }

    public int getEnd() {
        return this._end;
    }

    public int getLength() {
        return this._end - this._begin;
    }

    public static void sortByConcept(ConceptLocation[] array, int i1, int i2) {
        _cComp.quicksort(array, i1, i2 - 1);
    }

    public static void sortByPosition(ConceptLocation[] array, int i1, int i2) {
        _pComp.quicksort(array, i1, i2 - 1);
    }

    public void print() {
        System.out.println(this._concept + "\t" + this._begin + "\t" + this._end);
    }

    public static void main(String[] args) {
        int i;
        int limit = 30;
        ConceptLocation[] array = new ConceptLocation[limit];
        for (i = 0; i < limit; ++i) {
            int b = (int)(Math.random() * 1000.0);
            array[i] = new ConceptLocation((int)(Math.random() * 1000.0), b, b + (int)(Math.random() * 10.0));
        }
        for (i = 0; i < limit; ++i) {
            array[i].print();
        }
        ConceptLocation.sortByConcept(array, 0, limit);
        System.out.println("----------------------------------");
        for (i = 0; i < limit; ++i) {
            array[i].print();
        }
        ConceptLocation.sortByPosition(array, 0, limit);
        System.out.println("----------------------------------");
        for (i = 0; i < limit; ++i) {
            array[i].print();
        }
    }

    static {
        new ConceptLocation();
    }

    private class PositionSorter
    extends ConceptLocationSorter {
        private PositionSorter() {
        }

        public boolean smallerThan(ConceptLocation a, ConceptLocation b) {
            return a._begin < b._begin || a._begin == b._begin && a._end < b._end;
        }
    }

    private class ConceptSorter
    extends ConceptLocationSorter {
        private ConceptSorter() {
        }

        public boolean smallerThan(ConceptLocation a, ConceptLocation b) {
            return a._concept < b._concept;
        }
    }

    private abstract class ConceptLocationSorter {
        private ConceptLocationSorter() {
        }

        public abstract boolean smallerThan(ConceptLocation var1, ConceptLocation var2);

        private int partition(ConceptLocation[] array, int p, int r) {
            ConceptLocation x = array[p];
            int i = p - 1;
            int j = r + 1;
            while (true) {
                if (this.smallerThan(x, array[--j])) {
                    continue;
                }
                while (this.smallerThan(array[++i], x)) {
                }
                if (i >= j) break;
                ConceptLocation t = array[i];
                array[i] = array[j];
                array[j] = t;
            }
            return j;
        }

        public void quicksort(ConceptLocation[] array, int p, int r) {
            if (p < r) {
                int q = this.partition(array, p, r);
                this.quicksort(array, p, q);
                this.quicksort(array, q + 1, r);
            }
        }
    }
}

