/*
 * Decompiled with CFR 0.152.
 */
package javax.help.tagext;

import java.net.MalformedURLException;
import java.net.URL;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.help.InvalidHelpSetContextException;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.tagext.TagSupport;

public class ValidateTag
extends TagSupport {
    private HelpBroker helpBroker;
    private String invalidURLPath = "invalidhelp.html";
    private String hsName = null;
    private String id = null;
    private boolean merge = false;

    public void setHelpBroker(HelpBroker helpBroker) {
        this.helpBroker = helpBroker;
    }

    public void setInvalidURL(String relativeURLPath) {
        this.invalidURLPath = relativeURLPath;
    }

    public void setHelpSetName(String hsName) {
        this.hsName = hsName;
    }

    public void setCurrentID(String id) {
        this.id = id;
    }

    public void setMerge(boolean merge) {
        this.merge = merge;
    }

    public int doStartTag() {
        this.checkRequestParams();
        this.validateHelpSet();
        this.validateID();
        return 0;
    }

    private void checkRequestParams() {
        ServletRequest request = this.pageContext.getRequest();
        if (this.hsName == null) {
            this.hsName = request.getParameter("helpset");
        }
        if (this.id == null) {
            this.id = request.getParameter("id");
        }
    }

    private void validateHelpSet() {
        HelpSet tesths = this.helpBroker.getHelpSet();
        if (tesths != null && this.hsName == null) {
            return;
        }
        if (tesths == null && this.hsName == null) {
            try {
                this.pageContext.forward(this.invalidURLPath);
            }
            catch (Exception e) {
                return;
            }
        }
        if (tesths == null && this.hsName != null) {
            this.helpBroker.setHelpSet(this.createHelpSet());
            return;
        }
        if (tesths != null && this.hsName != null && this.merge) {
            tesths.add(this.createHelpSet());
        }
    }

    private HelpSet createHelpSet() {
        HelpSet hs = null;
        ServletRequest request = this.pageContext.getRequest();
        if (!this.hsName.startsWith("/")) {
            this.hsName = "/" + this.hsName;
        }
        URL url = null;
        try {
            url = this.hsName.startsWith("http") ? new URL(this.hsName) : new URL(request.getScheme(), request.getServerName(), request.getServerPort(), this.hsName);
            hs = new HelpSet(null, url);
        }
        catch (MalformedURLException e) {
        }
        catch (HelpSetException hse) {
            throw new RuntimeException(hse.getMessage());
        }
        return hs;
    }

    private void validateID() {
        if (this.id != null) {
            this.helpBroker.setCurrentID(this.id);
        } else if (this.helpBroker.getCurrentID() == null && this.helpBroker.getCurrentURL() == null) {
            try {
                this.helpBroker.setCurrentID(this.helpBroker.getHelpSet().getHomeID());
            }
            catch (InvalidHelpSetContextException invalidHelpSetContextException) {
                // empty catch block
            }
        }
    }
}

