/*
 * Decompiled with CFR 0.152.
 */
package jmaki.runtime;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.ServletContext;
import jmaki.runtime.IOUtil;
import jmaki.runtime.LocalizedMessage;
import jmaki.runtime.WidgetResourceException;

public class ResourceManager {
    private ServletContext context;
    private HashMap webResources;
    private HashMap classPathResources;
    private boolean usecache;
    private boolean strict;
    private String resoucesDir;
    private static final String CLASSPATHPREFIX = "META-INF";

    public ResourceManager(ServletContext ctx, boolean usecache, boolean strict) {
        this.context = ctx;
        this.usecache = usecache;
        this.strict = strict;
        if (usecache) {
            this.webResources = new HashMap();
            this.classPathResources = new HashMap();
        }
        if ((this.resoucesDir = ctx.getInitParameter("jmaki-resources")) == null) {
            this.resoucesDir = "/resources";
        }
    }

    public boolean isWebAppResource(String resource) throws WidgetResourceException {
        if (IOUtil.isExternalUri(resource)) {
            return false;
        }
        return this.locateWebAppResource(resource) != null;
    }

    public URL locateWebAppResource(String resource) throws WidgetResourceException {
        if (this.usecache && this.webResources.containsKey(resource)) {
            return (URL)this.webResources.get(resource);
        }
        try {
            URL url = this.context.getResource(resource);
            if (this.usecache) {
                this.webResources.put(resource, url);
            }
            return url;
        }
        catch (MalformedURLException mue) {
            String[] parameter = new String[]{resource};
            throw new WidgetResourceException(new LocalizedMessage("ERROR_LOCATE_RESOURCE", parameter), (Throwable)mue);
        }
    }

    public boolean isClassPathResource(String resource) throws WidgetResourceException {
        URL[] resources = this.locateClassPathResources(resource);
        if (this.strict && resources.length > 1) {
            String[] parameter = new String[]{resource};
            throw new WidgetResourceException(new LocalizedMessage("ERROR_NOT_UNIQUE_IN_CLASSPATH", parameter));
        }
        return resources.length > 0;
    }

    public URL locateClassPathResource(String resource) throws WidgetResourceException {
        URL[] resources = this.locateClassPathResources(resource);
        return resources.length > 0 ? resources[0] : null;
    }

    public URL[] locateClassPathResources(String resource) throws WidgetResourceException {
        if (this.usecache && this.classPathResources.containsKey(resource)) {
            return (URL[])this.classPathResources.get(resource);
        }
        try {
            Enumeration<URL> resourceURLs = this.getClass().getClassLoader().getResources(CLASSPATHPREFIX + resource);
            ArrayList<URL> resourceList = new ArrayList<URL>();
            while (resourceURLs.hasMoreElements()) {
                resourceList.add(resourceURLs.nextElement());
            }
            URL[] resourceArray = new URL[resourceList.size()];
            resourceList.toArray(resourceArray);
            if (this.usecache) {
                this.classPathResources.put(resource, resourceArray);
            }
            return resourceArray;
        }
        catch (IOException ioe) {
            String[] parameter = new String[]{CLASSPATHPREFIX + resource};
            throw new WidgetResourceException(new LocalizedMessage("ERROR_LOCATE_IN_CLASSPATH", parameter), (Throwable)ioe);
        }
    }

    public String getClassPathResourcePath() {
        return this.getResourcesDir();
    }

    public String getWebResourcePath() {
        return this.getResourcesDir();
    }

    public String getResourcesDir() {
        return this.resoucesDir;
    }

    public String getWidgetDir(String widgettype) {
        return "/" + widgettype.replace('.', '/');
    }

    public String getExtensionDir(String extension) {
        return "/" + extension.replace('.', '/');
    }
}

