/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.handlers;

import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import com.sun.jsftemplating.util.Util;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.management.Attribute;
import org.glassfish.admin.amx.logging.LogQuery;
import org.glassfish.admin.amx.logging.LogQueryEntry;
import org.glassfish.admin.amx.logging.LogQueryResult;
import org.glassfish.admin.amx.logging.Logging;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.V3AMX;

public class LogViewHandlers {
    public static final String GET_DATE_SHORT = "short";
    public static final String GET_DATE_MEDIUM = "medium";
    public static final String GET_DATE_LONG = "long";
    public static final String GET_DATE_FULL = "full";
    public static final String TIME_FORMAT = " HH:mm:ss.SSS";
    public static final String TIME_FORMAT_2 = " HH:mm:ss";
    public static final String TIME_FORMAT_3 = " HH:mm";
    public static final Boolean FALSE = (boolean)new Boolean(false);
    public static final Boolean TRUE = (boolean)new Boolean(true);
    public static final Integer DEFAULT_NUMBER_TO_DISPLAY = new Integer(40);
    public static final String FIRST_LOG_ROW = "firstLogRow";
    public static final int FROM_RECORD = 0;
    public static final String LAST_LOG_ROW = "lastLogRow";
    public static final String CUSTOM_LOGGER_DELIMITERS = " \t\n\r\f,;:";
    public static final String NVP_DELIMITERS = " \t\n\r\f,;:";
    public static final char EQUALS = '=';
    public static final String SHOW_LEVEL_IMAGE = "showLevelImage";
    public static final String LEVEL_IMAGE_ROOT = "/com_sun_web_ui/images/alerts/";
    public static final long ONE_HOUR = 3600000L;

    public static void getLogResultsTable(HandlerContext handlerCtx) {
        String archivedLogFile = (String)handlerCtx.getInputValue("LogFileName");
        Integer fromRecord = (Integer)handlerCtx.getInputValue("FromRecord");
        Boolean after = (Boolean)handlerCtx.getInputValue("AfterRecord");
        String dateEnabledString = (String)handlerCtx.getInputValue("DateEnabled");
        Object fromDate = handlerCtx.getInputValue("FromDate");
        Object fromTime = handlerCtx.getInputValue("FromTime");
        Object toDate = handlerCtx.getInputValue("ToDate");
        Object toTime = handlerCtx.getInputValue("ToTime");
        Object loggers = handlerCtx.getInputValue("Loggers");
        String logLevel = (String)handlerCtx.getInputValue("LogLevel");
        Object customLoggers = handlerCtx.getInputValue("CustomLoggers");
        Object nvp = handlerCtx.getInputValue("Nvp");
        String anySearch = (String)handlerCtx.getInputValue("anySearch");
        Integer numberToDisplay = (Integer)handlerCtx.getInputValue("NumToDisplay");
        Boolean onlyLevel = (Boolean)handlerCtx.getInputValue("OnlyLevel");
        Boolean direction = (Boolean)handlerCtx.getInputValue("LogDateSortDirection");
        Boolean truncMsg = (Boolean)handlerCtx.getInputValue("TruncateMessage");
        Integer truncLenInteger = (Integer)handlerCtx.getInputValue("TruncateLength");
        ArrayList result = new ArrayList();
        String instanceName = (String)handlerCtx.getInputValue("InstanceName");
        String logFileDir = "";
        Boolean hasResults = new Boolean(false);
        if (instanceName != null && archivedLogFile != null) {
            boolean truncateMessage = true;
            if (truncMsg != null) {
                truncateMessage = truncMsg;
            }
            int truncLen = 100;
            if (truncLenInteger != null) {
                truncLen = truncLenInteger;
            }
            Boolean dateEnabled = null;
            if ("enabled".equals(dateEnabledString)) {
                dateEnabled = TRUE;
            }
            boolean dateEnabledFlag = false;
            if (dateEnabled != null) {
                dateEnabledFlag = dateEnabled;
            }
            if (dateEnabledFlag) {
                fromDate = LogViewHandlers.convertDateTime(handlerCtx, fromDate, fromTime);
                toDate = LogViewHandlers.convertDateTime(handlerCtx, toDate, toTime);
                if (fromDate == null) {
                    GuiUtil.handleError(handlerCtx, "Specific Date Range was chosen, however, date fields are incomplete.");
                }
                if (toDate != null && fromDate != null && ((Date)fromDate).after((Date)toDate)) {
                    GuiUtil.handleError(handlerCtx, "Timestamp value of 'From: ' field " + fromDate + " must not be greater than 'To: ' field value " + toDate);
                }
            } else {
                fromDate = null;
                toDate = null;
            }
            if (logLevel != null && logLevel.toString().trim().length() == 0) {
                logLevel = null;
            }
            if (onlyLevel == null) {
                onlyLevel = FALSE;
            }
            HashSet<Object> moduleList = null;
            if (loggers != null) {
                int len = ((Object[])loggers).length;
                moduleList = new HashSet<Object>();
                for (int count = 0; count < len; ++count) {
                    Object val = ((Object[])loggers)[count];
                    if (val == null || val.toString().trim().length() == 0) continue;
                    moduleList.add(val);
                }
            }
            if (customLoggers != null && customLoggers.toString().trim().length() != 0) {
                StringTokenizer tok = new StringTokenizer(customLoggers.toString(), " \t\n\r\f,;:");
                if (moduleList == null) {
                    moduleList = new HashSet();
                }
                while (tok.hasMoreTokens()) {
                    String token = tok.nextToken();
                    if (token == null || token.length() == 0) continue;
                    moduleList.add(token);
                }
            }
            ArrayList<Attribute> nvpProps = null;
            if (nvp != null && nvp.toString().trim().length() != 0) {
                nvpProps = new ArrayList<Attribute>();
                StringTokenizer tok = new StringTokenizer(nvp.toString(), " \t\n\r\f,;:");
                while (tok.hasMoreTokens()) {
                    String token = tok.nextToken();
                    if (token == null || token.length() == 0) continue;
                    try {
                        int equalsIdx = token.indexOf(61);
                        if (equalsIdx < 0) {
                            GuiUtil.handleError(handlerCtx, "Name-Value Pairs must be in the format \"<name>=<value>\".");
                        }
                        String key = null;
                        key = token.substring(0, equalsIdx++);
                        Attribute attr = new Attribute(key, token.substring(equalsIdx));
                        nvpProps.add(attr);
                    }
                    catch (Exception ex) {
                        GuiUtil.handleError(handlerCtx, "Name-Value Pairs must be in the format \"<name>=<value>\".");
                    }
                }
            }
            if (numberToDisplay == null) {
                numberToDisplay = DEFAULT_NUMBER_TO_DISPLAY;
            } else {
                numberToDisplay.intValue();
            }
            if (direction == null) {
                direction = FALSE;
            }
            if (after == null) {
                after = direction;
            }
            if (fromRecord == null) {
                fromRecord = -1;
            } else {
                fromRecord.intValue();
            }
            List results = null;
            Logging logging = V3AMX.getInstance().getDomainRoot().getLogging();
            try {
                results = logging.queryServerLog(archivedLogFile, (long)fromRecord.intValue(), direction.booleanValue(), numberToDisplay.intValue(), fromDate == null ? null : Long.valueOf(((Date)fromDate).getTime()), toDate == null ? null : Long.valueOf(((Date)toDate).getTime()), logLevel, moduleList, nvpProps, anySearch);
            }
            catch (Exception ex) {
                GuiUtil.handleError(handlerCtx, "Error while querying Log File.");
            }
            LogQueryEntry[] query = null;
            if (results != null) {
                LogQueryResult r = LogQuery.Helper.toLogQueryResult(results);
                query = r.getEntries();
                for (int i = 0; i < query.length; ++i) {
                    HashMap<String, Object> oneRow = new HashMap<String, Object>();
                    LogQueryEntry row = query[i];
                    oneRow.put("recNumber", row.getRecordNumber());
                    oneRow.put("dateTime", LogViewHandlers.formatDateForDisplay(GuiUtil.getLocale(), row.getDate()));
                    String msgId = row.getMessageID();
                    String level = row.getLevel();
                    String moduleName = row.getModule();
                    if (level.equalsIgnoreCase("severe")) {
                        oneRow.put("levelImage", GuiUtil.getMessage("common.errorGif"));
                        oneRow.put(SHOW_LEVEL_IMAGE, new Boolean(true));
                        oneRow.put("diagnosticCauses", LogViewHandlers.getDiagnosticCauses(handlerCtx, msgId, moduleName));
                        oneRow.put("diagnosticChecks", LogViewHandlers.getDiagnosticChecks(handlerCtx, msgId, moduleName));
                    } else {
                        oneRow.put(SHOW_LEVEL_IMAGE, new Boolean(false));
                        oneRow.put("diagnostic", "");
                    }
                    oneRow.put("level", level);
                    oneRow.put("productName", row.getProductName());
                    oneRow.put("logger", moduleName);
                    try {
                        oneRow.put("nvp", row.getNameValuePairsMap());
                    }
                    catch (Exception ex) {
                        oneRow.put("nvp", "");
                    }
                    oneRow.put("messageID", msgId);
                    String message = row.getMessage().trim();
                    if (truncateMessage && message.length() > truncLen) {
                        message = message.substring(0, truncLen).concat("...\n");
                    }
                    oneRow.put("message", message == null ? " " : Util.htmlEscape((String)message));
                    result.add(oneRow);
                }
            }
            if (query != null && query.length > 1) {
                handlerCtx.setOutputValue("FirstLogRow", (Object)query[0].getRecordNumber());
                handlerCtx.setOutputValue("LastLogRow", (Object)query[query.length - 1].getRecordNumber());
                hasResults = new Boolean(true);
            } else {
                handlerCtx.setOutputValue("FirstLogRow", (Object)"-1");
                handlerCtx.setOutputValue("LastLogRow", (Object)"-1");
            }
        }
        handlerCtx.setOutputValue("result", result);
        handlerCtx.setOutputValue("HasResults", (Object)hasResults);
    }

    protected static Date convertDateTime(HandlerContext handlerCtx, Object date, Object time) {
        if (date instanceof Date) {
            return (Date)date;
        }
        if (date == null || date.toString().trim().length() == 0) {
            return null;
        }
        String dateTime = date.toString() + (time == null ? "" : " " + time.toString());
        DateFormat df = DateFormat.getDateInstance(3, GuiUtil.getLocale());
        if (time != null && df instanceof SimpleDateFormat) {
            SimpleDateFormat fmt = (SimpleDateFormat)df;
            String formatPrefix = fmt.toLocalizedPattern();
            try {
                date = LogViewHandlers.parseDateString(fmt, formatPrefix + TIME_FORMAT, dateTime);
            }
            catch (ParseException ex) {
                try {
                    date = LogViewHandlers.parseDateString(fmt, formatPrefix + TIME_FORMAT_2, dateTime);
                }
                catch (ParseException ex2) {
                    try {
                        date = LogViewHandlers.parseDateString(fmt, formatPrefix + TIME_FORMAT_3, dateTime);
                    }
                    catch (ParseException ex3) {
                        GuiUtil.handleError(handlerCtx, "Unable to parse Date/Time: '" + dateTime + "'.");
                    }
                }
            }
        } else if (time != null) {
            df = DateFormat.getDateTimeInstance(3, 1, GuiUtil.getLocale());
            try {
                date = df.parse(dateTime);
            }
            catch (ParseException ex) {
                GuiUtil.handleError(handlerCtx, "Unable to parse Date/Time: '" + dateTime + "'.");
            }
        } else {
            try {
                date = df.parse(dateTime);
            }
            catch (ParseException ex) {
                GuiUtil.handleError(handlerCtx, "Unable to parse Date/Time: '" + dateTime + "'.");
            }
        }
        Date convertDate = null;
        try {
            convertDate = (Date)date;
        }
        catch (Exception ex) {
            convertDate = null;
        }
        return convertDate;
    }

    private static Date parseDateString(SimpleDateFormat fmt, String format, String dateTime) throws ParseException {
        fmt.applyLocalizedPattern(format);
        return fmt.parse(dateTime);
    }

    public static String formatDateForDisplay(Locale locale, Date date) {
        DateFormat dateFormat = DateFormat.getDateInstance(2, locale);
        if (dateFormat instanceof SimpleDateFormat) {
            SimpleDateFormat fmt = (SimpleDateFormat)dateFormat;
            fmt.applyLocalizedPattern(fmt.toLocalizedPattern() + TIME_FORMAT);
            return fmt.format(date);
        }
        dateFormat = DateFormat.getDateTimeInstance(2, 1, locale);
        return dateFormat.format(date);
    }

    private static String getDiagnosticChecks(HandlerContext handlerCtx, String msgId, String moduleName) {
        if (msgId == null || "".equals(msgId)) {
            return LogViewHandlers.formatArrayForDisplay(null);
        }
        Logging logging = V3AMX.getInstance().getDomainRoot().getLogging();
        String[] results = logging.getDiagnosticChecks(msgId, moduleName);
        String res = LogViewHandlers.formatArrayForDisplay(results);
        return res;
    }

    private static String getDiagnosticCauses(HandlerContext handlerCtx, String msgId, String moduleName) {
        if (msgId == null || "".equals(msgId)) {
            return LogViewHandlers.formatArrayForDisplay(null);
        }
        Logging logging = V3AMX.getInstance().getDomainRoot().getLogging();
        String[] results = logging.getDiagnosticCauses(msgId, moduleName);
        String res = LogViewHandlers.formatArrayForDisplay(results);
        return res;
    }

    public static String getLogFilesDirectory(String instanceName) {
        if (GuiUtil.isEmpty(instanceName)) {
            return "";
        }
        String dir = "";
        return dir;
    }

    public static void getFirstLastRecord(HandlerContext handlerCtx) {
        String firstLogRow = (String)handlerCtx.getInputValue("FirstRecord");
        String lastLogRow = (String)handlerCtx.getInputValue("LastRecord");
        if (firstLogRow == null) {
            firstLogRow = "0";
        }
        if (lastLogRow == null) {
            lastLogRow = "0";
        }
        int firstRow = 0;
        try {
            firstRow = Integer.parseInt(firstLogRow);
            int lastRow = Integer.parseInt(lastLogRow);
            if (firstRow > lastRow) {
                String temp = firstLogRow;
                firstLogRow = lastLogRow;
                lastLogRow = temp;
                firstRow = lastRow;
            }
            handlerCtx.setOutputValue("First", (Object)firstLogRow);
            handlerCtx.setOutputValue("Last", (Object)lastLogRow);
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
    }

    private static String getDiagnosticURI(HandlerContext handlerCtx, String msgId, String moduleName) {
        if (msgId == null || "".equals(msgId)) {
            return "";
        }
        Logging logging = V3AMX.getInstance().getDomainRoot().getLogging();
        String res = logging.getDiagnosticURI(msgId);
        return res;
    }

    protected static String formatArrayForDisplay(String[] diag) {
        if (diag == null || diag.length == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer("<br>");
        for (int i = 0; i < diag.length; ++i) {
            buf.append(diag[i]);
            buf.append("<br>");
        }
        return buf.toString();
    }

    public void getTime(HandlerContext handlerCtx) {
        try {
            DateFormat df = DateFormat.getTimeInstance(3, GuiUtil.getLocale());
            ((SimpleDateFormat)df).applyLocalizedPattern(TIME_FORMAT);
            handlerCtx.setOutputValue("Time", (Object)df.format(new Date()));
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public void getDate(HandlerContext handlerCtx) {
        String formatString = (String)handlerCtx.getInputValue("DateFormat");
        int formatType = -1;
        if (formatString.equals(GET_DATE_SHORT)) {
            formatType = 3;
        } else if (formatString.equals(GET_DATE_MEDIUM)) {
            formatType = 2;
        } else if (formatString.equals(GET_DATE_LONG)) {
            formatType = 1;
        } else if (formatString.equals(GET_DATE_FULL)) {
            formatType = 0;
        }
        DateFormat df = null;
        if (formatType == -1) {
            df = DateFormat.getDateInstance(3, GuiUtil.getLocale());
            ((SimpleDateFormat)df).applyLocalizedPattern(formatString);
        } else {
            df = DateFormat.getDateInstance(formatType, GuiUtil.getLocale());
        }
        handlerCtx.setOutputValue("Date", (Object)df.format(new Date()));
    }

    public static void getLoggers(HandlerContext handlerCtx) {
        String[] selectedLoggers = (String[])handlerCtx.getInputValue("selectedLoggers");
        String selected = GuiUtil.arrayToString(selectedLoggers, ",");
        ArrayList<String> loggernames = new ArrayList<String>();
        Logging logging = V3AMX.getInstance().getDomainRoot().getLogging();
        Map loggers = logging.getLoggingProperties();
        if (loggers != null) {
            for (String oneLogger : loggers.keySet()) {
                if (!oneLogger.endsWith(".level") || oneLogger.equals(".level")) continue;
                loggernames.add(oneLogger.substring(0, oneLogger.lastIndexOf(".level")));
            }
        }
        handlerCtx.setOutputValue("LoggerList", loggernames);
    }

    public void getFormatedDateTime(HandlerContext handlerCtx) {
        String ts = (String)handlerCtx.getInputValue("Timestamp");
        Boolean addHour = (Boolean)handlerCtx.getInputValue("AddHour");
        Date date = null;
        date = ts == null || "".equals(ts) ? new Date(System.currentTimeMillis()) : (addHour != null ? new Date(Long.parseLong(ts) + 3600000L) : new Date(Long.parseLong(ts)));
        DateFormat df = DateFormat.getDateInstance(3, GuiUtil.getLocale());
        DateFormat tf = DateFormat.getTimeInstance(2, GuiUtil.getLocale());
        ((SimpleDateFormat)tf).applyLocalizedPattern(TIME_FORMAT);
        String ftime = tf.format(date);
        String fdate = df.format(date);
        handlerCtx.setOutputValue("Time", (Object)ftime);
        handlerCtx.setOutputValue("Date", (Object)fdate);
    }
}

