/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.util;

import com.sun.jersey.api.client.ClientResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.glassfish.admingui.common.util.JSONUtil;
import org.glassfish.admingui.common.util.MiscUtil;
import org.glassfish.admingui.common.util.RestResponse;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JerseyRestResponse
extends RestResponse {
    protected ClientResponse response;
    private String body = null;

    public JerseyRestResponse(ClientResponse response) {
        this.response = response;
    }

    @Override
    public String getResponseBody() {
        if (this.body == null) {
            this.body = (String)this.response.getEntity(String.class);
        }
        return this.body;
    }

    @Override
    public int getResponseCode() {
        return this.response.getStatus();
    }

    @Override
    public Map<String, Object> getResponse() {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        result.put("responseCode", this.getResponseCode());
        result.put("responseBody", this.getResponseBody());
        String contentType = (String)this.response.getHeaders().getFirst((Object)"Content-type");
        if (contentType != null) {
            if ((contentType = contentType.toLowerCase()).endsWith("xml")) {
                Document document = MiscUtil.getDocument(this.getResponseBody());
                Element root = document.getDocumentElement();
                if ("action-report".equalsIgnoreCase(root.getNodeName())) {
                    result.put("description", root.getAttribute("description"));
                    result.put("exit-code", root.getAttribute("exit-code"));
                    ArrayList<Map<String, Object>> messages = new ArrayList<Map<String, Object>>(2);
                    result.put("messages", messages);
                    NodeList nl = root.getChildNodes();
                    int len = nl.getLength();
                    for (int idx = 0; idx < len; ++idx) {
                        Node child = nl.item(idx);
                        if (child.getNodeType() != 1 || !child.getNodeName().equals("message-part")) continue;
                        messages.add(this.processMessagePart(child));
                    }
                } else {
                    result.put("data", this.getJavaFromXML(root));
                }
            } else if (contentType.endsWith("json")) {
                result.put("data", JSONUtil.jsonToJava(this.getResponseBody()));
            } else {
                System.out.println("Unsupported Response Format!");
            }
        }
        return result;
    }

    private Map<String, Object> getJavaFromXML(Element element) {
        HashMap<String, Object> result = new HashMap<String, Object>(10);
        NamedNodeMap attributes = element.getAttributes();
        int attLen = attributes.getLength();
        for (int attIdx = 0; attIdx < attLen; ++attIdx) {
            Node attribute = attributes.item(attIdx);
            result.put(attribute.getNodeName(), attribute.getNodeValue());
        }
        NodeList nl = element.getChildNodes();
        int len = nl.getLength();
        for (int idx = 0; idx < len; ++idx) {
            ArrayList<Map<String, Object>> childList;
            Node child = nl.item(idx);
            if (child.getNodeType() != 1) continue;
            String childName = child.getNodeName();
            if (result.containsKey(childName)) {
                childList = (ArrayList<Map<String, Object>>)result.get(childName);
            } else {
                childList = new ArrayList<Map<String, Object>>(5);
                result.put(childName, childList);
            }
            childList.add(this.getJavaFromXML((Element)child));
        }
        return result;
    }

    private Map<String, Object> processMessagePart(Node messageNode) {
        HashMap<String, Object> message = new HashMap<String, Object>(5);
        NamedNodeMap attributes = messageNode.getAttributes();
        int attLen = attributes.getLength();
        for (int attIdx = 0; attIdx < attLen; ++attIdx) {
            Node attribute = attributes.item(attIdx);
            message.put(attribute.getNodeName(), attribute.getNodeValue());
        }
        NodeList nl = messageNode.getChildNodes();
        int len = nl.getLength();
        boolean hasChildMessages = false;
        boolean hasProperty = false;
        ArrayList<Map<String, Object>> properties = null;
        ArrayList<Map<String, Object>> messages = null;
        for (int idx = 0; idx < len; ++idx) {
            Node child = nl.item(idx);
            if (child.getNodeType() != 1) continue;
            if (child.getNodeName().equals("message-part")) {
                if (!hasChildMessages) {
                    messages = new ArrayList<Map<String, Object>>(2);
                    message.put("messages", messages);
                    hasChildMessages = true;
                }
                messages.add(this.processMessagePart(child));
                continue;
            }
            if (!child.getNodeName().equals("property")) continue;
            if (!hasProperty) {
                properties = new ArrayList<Map<String, Object>>(10);
                message.put("properties", properties);
                hasProperty = true;
            }
            properties.add(this.processProperty(child));
        }
        return message;
    }

    private Map<String, Object> processProperty(Node propertyNode) {
        HashMap<String, Object> property = new HashMap<String, Object>(5);
        NamedNodeMap attributes = propertyNode.getAttributes();
        int attLen = attributes.getLength();
        for (int attIdx = 0; attIdx < attLen; ++attIdx) {
            Node attribute = attributes.item(attIdx);
            property.put(attribute.getNodeName(), attribute.getNodeValue());
        }
        NodeList nl = propertyNode.getChildNodes();
        int len = nl.getLength();
        boolean hasProperty = false;
        ArrayList<Map<String, Object>> properties = null;
        for (int idx = 0; idx < len; ++idx) {
            Node child = nl.item(idx);
            if (child.getNodeType() != 1 || !child.getNodeName().equals("property")) continue;
            if (!hasProperty) {
                properties = new ArrayList<Map<String, Object>>(10);
                property.put("properties", properties);
                hasProperty = true;
            }
            properties.add(this.processProperty(child));
        }
        return property;
    }
}

