/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.handlers;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.MultivaluedMap;
import javax.xml.parsers.ParserConfigurationException;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.MiscUtil;
import org.glassfish.admingui.common.util.RestResponse;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestApiHandlers {
    public static final String FORM_ENCODING = "application/x-www-form-urlencoded";
    public static final String RESPONSE_TYPE = "application/xml";
    public static final String GUI_TOKEN_FOR_EMPTY_PROPERTY_VALUE = "()";
    public static final Client JERSEY_CLIENT = Client.create();

    public static void getDefaultValues(HandlerContext handlerCtx) {
        try {
            String endpoint = (String)handlerCtx.getInputValue("endpoint");
            Map orig = (Map)handlerCtx.getInputValue("orig");
            Map<String, String> defaultValues = RestApiHandlers.buildDefaultValueMap(endpoint);
            if (orig == null) {
                handlerCtx.setOutputValue("valueMap", defaultValues);
            } else {
                for (String origKey : orig.keySet()) {
                    String defaultV = defaultValues.get(origKey);
                    if (defaultV == null) continue;
                    orig.put(origKey, defaultV);
                }
                handlerCtx.setOutputValue("valueMap", (Object)orig);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getEntityAttrs(HandlerContext handlerCtx) {
        try {
            String endpoint = (String)handlerCtx.getInputValue("endpoint");
            Map currentMap = (Map)handlerCtx.getInputValue("currentMap");
            RestResponse response = RestApiHandlers.get(endpoint);
            if (!response.isSuccess()) {
                throw new Exception(response.getResponseBody());
            }
            Map<String, String> valueMap = RestApiHandlers.getEntityAttrs(response.getResponseBody());
            if (currentMap != null) {
                valueMap.putAll(currentMap);
            }
            handlerCtx.setOutputValue("valueMap", valueMap);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void checkIfEndPointExist(HandlerContext handlerCtx) {
        handlerCtx.setOutputValue("exists", (Object)RestApiHandlers.get((String)handlerCtx.getInputValue("endpoint")).isSuccess());
    }

    public static void createEntity(HandlerContext handlerCtx) {
        HashMap<String, Object> attrs = (HashMap<String, Object>)handlerCtx.getInputValue("attrs");
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        String endpoint = (String)handlerCtx.getInputValue("endpoint");
        RestResponse response = RestApiHandlers.sendCreateRequest(endpoint, attrs, (List)handlerCtx.getInputValue("skipAttrs"), (List)handlerCtx.getInputValue("onlyUseAttrs"), (List)handlerCtx.getInputValue("convertToFalse"));
        Map resultMap = RestApiHandlers.parseResponse(response, handlerCtx, endpoint, attrs);
        handlerCtx.setOutputValue("result", (Object)endpoint);
    }

    public static void restRequest(HandlerContext handlerCtx) {
        Map attrs = (Map)handlerCtx.getInputValue("attrs");
        String endpoint = (String)handlerCtx.getInputValue("endpoint");
        String method = ((String)handlerCtx.getInputValue("method")).toLowerCase();
        handlerCtx.setOutputValue("result", (Object)RestApiHandlers.restRequest(endpoint, attrs, method, handlerCtx));
    }

    public static Map restRequest(String endpoint, Map attrs, String method, HandlerContext handlerCtx) {
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        method = method.toLowerCase();
        GuiUtil.getLogger().info("restRequest: endpoint=" + endpoint + "\nattrs=" + attrs + "\nmethod=" + method);
        RestResponse response = null;
        if ("post".equals(method)) {
            response = RestApiHandlers.post(endpoint, attrs);
        } else if ("get".equals(method)) {
            response = RestApiHandlers.get(endpoint, attrs);
        } else if ("delete".equals(method)) {
            response = RestApiHandlers.delete(endpoint, attrs);
        }
        return RestApiHandlers.parseResponse(response, handlerCtx, endpoint, attrs);
    }

    private static Map parseResponse(RestResponse response, HandlerContext handlerCtx, String endpoint, Map attrs) {
        if (response != null) {
            try {
                int status = response.getResponseCode();
                if (status != 200 && status != 201) {
                    GuiUtil.getLogger().severe("RestResponse.getResponse() failed.  endpoint = '" + endpoint + "'; attrs = '" + attrs + "'; RestResponse: " + response);
                    if (handlerCtx != null) {
                        GuiUtil.handleError(handlerCtx, (String)((Map)response.getResponse().get("messages")).get("message"));
                    }
                }
                return response.getResponse();
            }
            catch (Exception ex) {
                GuiUtil.getLogger().severe("RestResponse.getResponse() failed.  endpoint = '" + endpoint + "'; attrs = '" + attrs + "'; RestResponse: " + response);
                if (handlerCtx != null) {
                    GuiUtil.handleError(handlerCtx, GuiUtil.getMessage("error.checkServerLog"));
                }
                throw new RuntimeException(ex);
            }
        }
        return null;
    }

    public static void updateEntity(HandlerContext handlerCtx) {
        String endpoint;
        RestResponse response;
        HashMap<String, Object> attrs = (HashMap<String, Object>)handlerCtx.getInputValue("attrs");
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        if (!(response = RestApiHandlers.sendUpdateRequest(endpoint = (String)handlerCtx.getInputValue("endpoint"), attrs, (List)handlerCtx.getInputValue("skipAttrs"), (List)handlerCtx.getInputValue("onlyUseAttrs"), (List)handlerCtx.getInputValue("convertToFalse"))).isSuccess()) {
            GuiUtil.getLogger().severe("CreateProxy failed.  parent=" + endpoint + "; attrs =" + attrs);
            GuiUtil.handleError(handlerCtx, GuiUtil.getMessage("msg.error.checkLog"));
            return;
        }
        handlerCtx.setOutputValue("result", (Object)endpoint);
    }

    public static void deleteCascade(HandlerContext handlerCtx) {
        try {
            HashMap<String, Object> payload = new HashMap<String, Object>();
            String endpoint = (String)handlerCtx.getInputValue("endpoint");
            String id = (String)handlerCtx.getInputValue("id");
            String cascade = (String)handlerCtx.getInputValue("cascade");
            if (cascade != null) {
                payload.put("cascade", "false");
            }
            for (Map oneRow : (List)handlerCtx.getInputValue("selectedRows")) {
                RestApiHandlers.delete(endpoint + "/" + (String)oneRow.get(id), payload);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getChildList(HandlerContext handlerCtx) {
        try {
            handlerCtx.setOutputValue("result", RestApiHandlers.buildChildEntityList((String)handlerCtx.getInputValue("parentEndpoint"), (String)handlerCtx.getInputValue("childType"), (List)handlerCtx.getInputValue("skipList"), (List)handlerCtx.getInputValue("includeList"), (String)handlerCtx.getInputValue("id")));
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getChildrenNamesList(HandlerContext handlerCtx) {
        try {
            handlerCtx.setOutputValue("result", RestApiHandlers.getChildrenNames((String)handlerCtx.getInputValue("endpoint"), (String)handlerCtx.getInputValue("id")));
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static Map getAttributesMap(String endpoint) {
        RestResponse response = RestApiHandlers.get(endpoint);
        if (!response.isSuccess()) {
            return new HashMap();
        }
        return RestApiHandlers.getEntityAttrs(response.getResponseBody());
    }

    protected static Map<String, String> buildDefaultValueMap(String endpoint) throws ParserConfigurationException, SAXException, IOException {
        HashMap<String, String> defaultValues = new HashMap<String, String>();
        String options = RestApiHandlers.options(endpoint, RESPONSE_TYPE);
        Document doc = MiscUtil.getDocument(options);
        Element root = doc.getDocumentElement();
        NodeList nl = root.getElementsByTagName("messageParameters");
        if (nl.getLength() > 0) {
            NodeList params = nl.item(0).getChildNodes();
            for (int i = 0; i < params.getLength(); ++i) {
                String defaultValue;
                Node child = params.item(i);
                if (child.getNodeType() != 1 || "".equals(defaultValue = ((Element)child).getAttribute("defaultValue")) || defaultValue == null) continue;
                String nodeName = child.getNodeName();
                nodeName = nodeName.substring(0, 1).toUpperCase() + nodeName.substring(1);
                defaultValues.put(nodeName, defaultValue);
            }
        }
        return defaultValues;
    }

    protected static MultivaluedMap buildMultivalueMap(Map<String, Object> payload) {
        MultivaluedMapImpl formData = new MultivaluedMapImpl();
        for (Map.Entry<String, Object> entry : payload.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof List) {
                String key = entry.getKey();
                for (Object obj : (List)value) {
                    formData.add((Object)key, obj);
                }
                continue;
            }
            formData.putSingle((Object)entry.getKey(), value);
        }
        return formData;
    }

    public static RestResponse sendCreateRequest(String endpoint, Map<String, Object> attrs, List<String> skipAttrs, List<String> onlyUseAttrs, List<String> convertToFalse) {
        RestApiHandlers.removeSpecifiedAttrs(attrs, skipAttrs);
        attrs = RestApiHandlers.buildUseOnlyAttrMap(attrs, onlyUseAttrs);
        attrs = RestApiHandlers.convertNullValuesToFalse(attrs, convertToFalse);
        attrs = RestApiHandlers.fixKeyNames(attrs);
        return RestApiHandlers.post(endpoint, attrs);
    }

    public static RestResponse sendUpdateRequest(String endpoint, Map<String, Object> attrs, List<String> skipAttrs, List<String> onlyUseAttrs, List<String> convertToFalse) {
        RestApiHandlers.removeSpecifiedAttrs(attrs, skipAttrs);
        attrs = RestApiHandlers.buildUseOnlyAttrMap(attrs, onlyUseAttrs);
        attrs = RestApiHandlers.convertNullValuesToFalse(attrs, convertToFalse);
        attrs = RestApiHandlers.fixKeyNames(attrs);
        return RestApiHandlers.post(endpoint, attrs);
    }

    protected static Map<String, Object> fixKeyNames(Map<String, Object> map) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey().substring(0, 1).toLowerCase() + entry.getKey().substring(1);
            Object value = entry.getValue();
            results.put(key, value);
        }
        return results;
    }

    protected static void removeSpecifiedAttrs(Map<String, Object> attrs, List<String> removeList) {
        if (removeList == null || removeList.size() <= 0) {
            return;
        }
        Set<Map.Entry<String, Object>> attrSet = attrs.entrySet();
        Iterator<Map.Entry<String, Object>> iter = attrSet.iterator();
        while (iter.hasNext()) {
            Map.Entry<String, Object> oneEntry = iter.next();
            if (!removeList.contains(oneEntry.getKey())) continue;
            iter.remove();
        }
    }

    protected static Map buildUseOnlyAttrMap(Map<String, Object> attrs, List<String> onlyUseAttrs) {
        if (onlyUseAttrs != null) {
            HashMap<String, Object> newAttrs = new HashMap<String, Object>();
            for (String key : onlyUseAttrs) {
                if (!attrs.keySet().contains(key)) continue;
                newAttrs.put(key, attrs.get(key));
            }
            return newAttrs;
        }
        return attrs;
    }

    protected static Map<String, Object> convertNullValuesToFalse(Map<String, Object> attrs, List<String> convertToFalse) {
        if (convertToFalse != null) {
            HashMap<String, Object> newAttrs = new HashMap<String, Object>();
            for (Map.Entry<String, Object> entry : attrs.entrySet()) {
                String key = entry.getKey();
                if (convertToFalse.contains(key) && (entry.getValue() == null || "null".equals(entry.getValue()))) {
                    newAttrs.put(key, "false");
                    continue;
                }
                newAttrs.put(key, entry.getValue());
            }
            return newAttrs;
        }
        return attrs;
    }

    public static Map<String, String> getEntityAttrs(String entity) {
        HashMap<String, String> attrs = new HashMap<String, String>();
        try {
            Document doc = MiscUtil.getDocument(entity);
            Element root = doc.getDocumentElement();
            NamedNodeMap nnm = root.getAttributes();
            for (int i = 0; i < nnm.getLength(); ++i) {
                Node node = nnm.item(i);
                attrs.put(RestApiHandlers.upperCaseFirstLetter(node.getNodeName()), node.getNodeValue());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return attrs;
    }

    public static String upperCaseFirstLetter(String string) {
        if (string == null || string.length() <= 0) {
            return string;
        }
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    public static List<String> getChildResourceList(String document) throws SAXException, IOException, ParserConfigurationException {
        ArrayList<String> children = new ArrayList<String>();
        Document doc = MiscUtil.getDocument(document);
        Element root = doc.getDocumentElement();
        NodeList nl = root.getElementsByTagName("childResource");
        if (nl.getLength() > 0) {
            for (int i = 0; i < nl.getLength(); ++i) {
                Node child = nl.item(i);
                if (child.getNodeType() != 1) continue;
                children.add(child.getTextContent());
            }
        }
        return children;
    }

    public static Map<String, Map> getMonitoringStatInfo(String document) throws SAXException, IOException, ParserConfigurationException {
        HashMap<String, Map> result = new HashMap<String, Map>();
        Document doc = MiscUtil.getDocument(document);
        Element root = doc.getDocumentElement();
        NodeList nl = root.getChildNodes();
        if (nl.getLength() > 0) {
            for (int i = 0; i < nl.getLength(); ++i) {
                Node child = nl.item(i);
                if (child.getNodeType() != 1) continue;
                HashMap<String, String> attrs = new HashMap<String, String>();
                NamedNodeMap nnm = child.getAttributes();
                for (int j = 0; j < nnm.getLength(); ++j) {
                    Node node = nnm.item(j);
                    attrs.put(node.getNodeName(), node.getNodeValue());
                }
                result.put(child.getNodeName(), attrs);
            }
        }
        return result;
    }

    public static List<Map> buildChildEntityList(String parent, String childType, List skipList, List includeList, String id) throws Exception {
        String endpoint = parent.endsWith("/") ? parent + childType : parent + "/" + childType;
        boolean hasSkip = skipList != null;
        boolean hasInclude = includeList != null;
        boolean convert = childType.equals("property");
        ArrayList<Map> childElements = new ArrayList<Map>();
        RestResponse response = RestApiHandlers.get(endpoint);
        String parentString = response.getResponseBody();
        List<String> childUrls = RestApiHandlers.getChildResourceList(parentString);
        for (String childUrl : childUrls) {
            String childString = RestApiHandlers.get(childUrl).getResponseBody();
            Map<String, String> entity = RestApiHandlers.getEntityAttrs(childString);
            HashMap<String, Object> oneRow = new HashMap<String, Object>();
            if (hasSkip && skipList.contains(entity.get(id)) || hasInclude && !includeList.contains(entity.get(id))) continue;
            oneRow.put("selected", false);
            for (String attrName : entity.keySet()) {
                oneRow.put(attrName, RestApiHandlers.getA(entity, attrName, convert));
            }
            oneRow.put("encodedName", URLEncoder.encode(entity.get(id), "UTF-8"));
            oneRow.put("Name", entity.get(id));
            childElements.add(oneRow);
        }
        return childElements;
    }

    private static String getA(Map<String, String> attrs, String key, boolean convert) {
        String val = attrs.get(key);
        if (val == null) {
            return "";
        }
        return convert && val.equals("") ? GUI_TOKEN_FOR_EMPTY_PROPERTY_VALUE : val.toString();
    }

    public static List<String> getChildrenNames(String endpoint, String id) throws Exception {
        ArrayList<String> childElements = new ArrayList<String>();
        String foo = RestApiHandlers.get(endpoint).getResponseBody();
        List<String> childUrls = RestApiHandlers.getChildResourceList(foo);
        for (String childUrl : childUrls) {
            childElements.add(childUrl.substring(childUrl.lastIndexOf("/") + 1));
        }
        return childElements;
    }

    public static RestResponse get(String address) {
        return RestApiHandlers.get(address, new HashMap<String, Object>());
    }

    public static RestResponse get(String address, Map<String, Object> payload) {
        return RestResponse.getRestResponse((ClientResponse)JERSEY_CLIENT.resource(address).queryParams(RestApiHandlers.buildMultivalueMap(payload)).accept(new String[]{RESPONSE_TYPE}).get(ClientResponse.class));
    }

    public static RestResponse post(String address, Map<String, Object> payload) {
        WebResource webResource = JERSEY_CLIENT.resource(address);
        MultivaluedMap formData = RestApiHandlers.buildMultivalueMap(payload);
        ClientResponse cr = (ClientResponse)webResource.post(ClientResponse.class, (Object)formData);
        RestResponse rr = RestResponse.getRestResponse(cr);
        return rr;
    }

    public static String put(String address) {
        throw new UnsupportedOperationException();
    }

    public static RestResponse delete(String address, Map<String, Object> payload) {
        WebResource webResource = JERSEY_CLIENT.resource(address);
        ClientResponse cr = (ClientResponse)webResource.queryParams(RestApiHandlers.buildMultivalueMap(payload)).delete(ClientResponse.class);
        RestApiHandlers.checkStatusForSuccess(cr);
        return RestResponse.getRestResponse(cr);
    }

    public static String options(String address, String responseType) {
        return (String)JERSEY_CLIENT.resource(address).accept(new String[]{responseType}).options(String.class);
    }

    public static void checkStatusForSuccess(ClientResponse cr) {
        int status = cr.getStatus();
        if (status < 200 || status > 299) {
            throw new RuntimeException(cr.toString());
        }
    }
}

