/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.util.fileStreamer;

import com.sun.jsftemplating.layout.LayoutDefinitionManager;
import com.sun.jsftemplating.util.FileUtil;
import com.sun.jsftemplating.util.LogUtil;
import com.sun.jsftemplating.util.fileStreamer.ContentSource;
import com.sun.jsftemplating.util.fileStreamer.Context;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import javax.faces.context.FacesContext;

public class ResourceContentSource
implements ContentSource {
    protected static final long DEFAULT_MODIFIED_DATE = new Date().getTime();
    public static final String ID = "resourceCS";

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public InputStream getInputStream(Context ctx) throws IOException {
        InputStream in = (InputStream)ctx.getAttribute("inputStream");
        if (in != null) {
            return in;
        }
        String path = this.getResourcePath(ctx);
        URL url = FileUtil.searchForFile(path, null);
        if (url == null) {
            return null;
        }
        int index = path.lastIndexOf(46);
        if (index > 0) {
            ctx.setAttribute("extension", path.substring(index + 1));
        }
        in = url.openStream();
        ctx.setAttribute("inputStream", in);
        return in;
    }

    @Override
    public String getResourcePath(Context ctx) {
        String path = (String)ctx.getAttribute("filePathnorm");
        if (path != null) {
            return path;
        }
        String origPath = (String)ctx.getAttribute("filePath");
        path = ResourceContentSource.normalize(origPath);
        ctx.setAttribute("filePathnorm", path);
        return path;
    }

    public static String normalize(String origPath) {
        String path = origPath;
        if (path != null) {
            path = path.replace('\\', '/');
            while (path.charAt(0) == '/') {
                path = path.substring(1);
            }
            while (path.indexOf("//") != -1) {
                path = path.replace("//", "/");
            }
            int idx = path.indexOf("../");
            while (idx != -1) {
                if (idx == 0) {
                    LogUtil.info((Object)"JSFT0010", origPath);
                    throw new IllegalArgumentException("Invalid Resource Path: '" + origPath + "'");
                }
                if (path.charAt(idx - 1) == '/') {
                    int prevPathIdx = path.lastIndexOf(47, idx - 2) + 1;
                    path = path.substring(0, prevPathIdx) + path.substring(idx + 3);
                    while (path.length() > 0 && path.charAt(0) == '/') {
                        path = path.substring(1);
                    }
                }
                idx = path.indexOf("../");
            }
            if (path.equals("..")) {
                path = null;
            }
        }
        return path;
    }

    @Override
    public void cleanUp(Context ctx) {
        InputStream is = (InputStream)ctx.getAttribute("inputStream");
        if (is != null) {
            try {
                is.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ctx.removeAttribute("inputStream");
    }

    @Override
    public long getLastModified(Context context) {
        FacesContext fc = FacesContext.getCurrentInstance();
        if (LayoutDefinitionManager.isDebug(fc) && fc != null) {
            long time;
            String path = this.getResourcePath(context);
            path = FileUtil.getRealPath(fc.getExternalContext().getContext(), path);
            if (path != null && (time = new File(path).lastModified()) > 0L) {
                return time;
            }
        }
        return DEFAULT_MODIFIED_DATE;
    }
}

