/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.handlers;

import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.admin.amx.intf.config.ConnectorConnectionPool;
import org.glassfish.admin.amx.intf.config.ConnectorResource;
import org.glassfish.admin.amx.intf.config.Resources;
import org.glassfish.admingui.common.handlers.RestApiHandlers;
import org.glassfish.admingui.common.handlers.RestUtilHandlers;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.V3AMX;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcTempHandler {
    public static Logger guiLogger = GuiUtil.getLogger();
    public static final String REASON_FAILED_KEY = "ReasonFailedKey";
    private static final String DATA_SOURCE = "javax.sql.DataSource";
    private static final String XADATA_SOURCE = "javax.sql.XADataSource";
    private static final String CCDATA_SOURCE = "javax.sql.ConnectionPoolDataSource";
    private static final String DRIVER = "java.sql.Driver";
    private static final String JAVADB = "JavaDB";
    private static final String ORACLE = "Oracle";
    private static final String DERBY = "Derby";
    private static final String SYBASE = "Sybase";
    private static final String DB2 = "DB2";
    private static final String POINTBASE = "PointBase";
    private static final String POSTGRESQL = "PostgreSQL";
    private static final String INFORMIX = "Informix";
    private static final String CLOUDSCAPE = "Cloudscape";
    private static final String MSSQL = "Microsoft SQL Server";
    private static final String MYSQL = "MySQL";
    private static List resTypeList = new ArrayList();
    private static List dbVendorList = new ArrayList();

    public static void setJDBCPoolWizard(HandlerContext handlerCtx) {
        Boolean fromStep2 = (Boolean)handlerCtx.getInputValue("fromStep2");
        if (fromStep2 == null || !fromStep2.booleanValue()) {
            Map attrMap = (Map)handlerCtx.getInputValue("attrMap");
            Map sessionMap = handlerCtx.getFacesContext().getExternalContext().getSessionMap();
            sessionMap.put("wizardMap", attrMap);
            sessionMap.put("wizardPoolExtra", new HashMap());
        }
        handlerCtx.setOutputValue("ResTypeList", (Object)resTypeList);
        handlerCtx.setOutputValue("DBVendorList", (Object)dbVendorList);
    }

    public static void updateJDBCPoolWizardStep1(HandlerContext handlerCtx) {
        Map extra = (Map)handlerCtx.getFacesContext().getExternalContext().getSessionMap().get("wizardPoolExtra");
        String resType = (String)extra.get("ResType");
        String dbVendorBox = (String)extra.get("DBVendorBox");
        String dbVendorField = (String)extra.get("DBVendorField");
        String dbVendor = GuiUtil.isEmpty(dbVendorField) ? dbVendorBox : dbVendorField;
        extra.put("DBVendor", dbVendor);
        String previousResType = (String)extra.get("PreviousResType");
        String previousDB = (String)extra.get("PreviousDB");
        if (!resType.equals(previousResType) || !dbVendor.equals(previousDB)) {
            block15: {
                if (!GuiUtil.isEmpty(resType) && !GuiUtil.isEmpty(dbVendor)) {
                    List dsl = new ArrayList();
                    try {
                        Map<String, String> props;
                        String dslName;
                        String classname = "";
                        dsl = JdbcTempHandler.getJdbcDriverClassNames(dbVendor, resType, false);
                        if (guiLogger.isLoggable(Level.FINE)) {
                            guiLogger.fine("======= getJdbcDriverClassNames(" + dbVendor + ", " + resType + ")");
                            guiLogger.fine("=======  # of items for JDBC_DRIVER_CLASS_NAMES_KEY  " + dsl.size());
                            for (int i = 0; i < dsl.size(); ++i) {
                                guiLogger.fine("classname[" + i + "] : " + dsl.get(i));
                            }
                        }
                        ArrayList noprops = new ArrayList();
                        String string = dslName = dsl != null && dsl.size() > 0 ? (String)dsl.get(0) : "";
                        if (resType.equals(DRIVER)) {
                            extra.put("DList", dsl);
                            extra.put("DSList", "");
                            extra.put("DatasourceClassnameField", "");
                            extra.put("dsClassname", Boolean.FALSE);
                        } else {
                            extra.put("DSList", dsl);
                            extra.put("DList", "");
                            extra.put("DriverClassnameField", "");
                            extra.put("dsClassname", Boolean.TRUE);
                            extra.put("DatasourceClassname", dslName);
                        }
                        if (guiLogger.isLoggable(Level.FINE)) {
                            guiLogger.fine("===== getConnectionDefinitionPropertiesAndDefaults(\"" + dslName + "\"," + resType + ")");
                        }
                        if ((props = JdbcTempHandler.getConnectionDefinitionPropertiesAndDefaults(dslName, resType)).size() > 0) {
                            if (guiLogger.isLoggable(Level.FINE)) {
                                guiLogger.fine("=======  getConnectionDefinitionPropertiesAndDefaults returns # of properties: " + props.size());
                            }
                            handlerCtx.getFacesContext().getExternalContext().getSessionMap().put("wizardPoolProperties", GuiUtil.convertMapToListOfMap(props));
                            break block15;
                        }
                        if (guiLogger.isLoggable(Level.FINE)) {
                            guiLogger.fine("======= getConnectionDefinitionPropertiesAndDefaults returns NULL");
                        }
                        handlerCtx.getFacesContext().getExternalContext().getSessionMap().put("wizardPoolProperties", noprops);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                } else if (DRIVER.equals(resType)) {
                    extra.put("DatasourceClassnameField", "");
                    extra.put("dsClassname", Boolean.FALSE);
                } else {
                    extra.put("DatasourceClassnameField", "");
                    extra.put("dsClassname", Boolean.TRUE);
                }
            }
            extra.put("PreviousResType", resType);
            extra.put("PreviousDB", dbVendor);
        }
    }

    public static void updateJdbcConnectionPoolPropertiesTable(HandlerContext handlerCtx) {
        Map<String, String> props;
        Map extra = (Map)handlerCtx.getFacesContext().getExternalContext().getSessionMap().get("wizardPoolExtra");
        String resType = (String)extra.get("ResType");
        String classname = (String)extra.get("DatasourceClassname");
        ArrayList noprops = new ArrayList();
        if (guiLogger.isLoggable(Level.FINE)) {
            guiLogger.fine("===== getConnectionDefinitionPropertiesAndDefaults(\"" + classname + "\"," + resType + ")");
        }
        if ((props = JdbcTempHandler.getConnectionDefinitionPropertiesAndDefaults(classname, resType)).size() != 0) {
            if (guiLogger.isLoggable(Level.FINE)) {
                guiLogger.fine("=======  getConnectionDefinitionPropertiesAndDefaults returns # of properties: " + props.size());
            }
            handlerCtx.getFacesContext().getExternalContext().getSessionMap().put("wizardPoolProperties", GuiUtil.convertMapToListOfMap(props));
        } else {
            if (guiLogger.isLoggable(Level.FINE)) {
                guiLogger.fine("======= getConnectionDefinitionPropertiesAndDefaults returns NULL");
            }
            handlerCtx.getFacesContext().getExternalContext().getSessionMap().put("wizardPoolProperties", noprops);
        }
    }

    public static void updateJdbcConnectionPoolWizardStep2(HandlerContext handlerCtx) {
        Map extra = (Map)handlerCtx.getFacesContext().getExternalContext().getSessionMap().get("wizardPoolExtra");
        Map attrs = (Map)handlerCtx.getFacesContext().getExternalContext().getSessionMap().get("wizardMap");
        String resType = (String)extra.get("ResType");
        String classname = (String)extra.get("DatasourceClassname");
        String driver = (String)extra.get("DriverClassname");
        String name = (String)extra.get("Name");
        String classnamefield = (String)extra.get("DatasourceClassnameField");
        String driverfield = (String)extra.get("DriverClassnameField");
        attrs.put("Name", name);
        attrs.put("ResType", resType);
        if ("".equals(attrs.get("TransactionIsolationLevel"))) {
            attrs.remove("TransactionIsolationLevel");
        }
        if (!GuiUtil.isEmpty(classnamefield) || !GuiUtil.isEmpty(driverfield)) {
            attrs.put("DatasourceClassname", classnamefield);
            attrs.put("DriverClassname", driverfield);
        } else if (!GuiUtil.isEmpty(classname) || !GuiUtil.isEmpty(driver)) {
            attrs.put("DatasourceClassname", classname);
            attrs.put("DriverClassname", driver);
        } else {
            GuiUtil.handleError(handlerCtx, GuiUtil.getMessage("org.glassfish.jdbc.admingui.Strings", "msg.Error.classNameCannotBeEmpty"));
            return;
        }
    }

    public static void getJMSFactoriesTable(HandlerContext handlerCtx) {
        Resources resources = V3AMX.getInstance().getResources();
        Map conResources = resources.getConnectorResource();
        ArrayList result = new ArrayList();
        for (ConnectorResource cr : conResources.values()) {
            ConnectorConnectionPool ccPool;
            String poolName = cr.getPoolName();
            if (GuiUtil.isEmpty(poolName) || (ccPool = (ConnectorConnectionPool)resources.getConnectorConnectionPool().get(poolName)) == null || !ccPool.getResourceAdapterName().equals("jmsra")) continue;
            HashMap<String, Object> oneRow = new HashMap<String, Object>();
            oneRow.put("selected", false);
            oneRow.put("Name", poolName);
            oneRow.put("JndiName", cr.getName());
            oneRow.put("ConnectionDefinitionName", ccPool.getConnectionDefinitionName());
            oneRow.put("Description", GuiUtil.isEmpty(ccPool.getDescription()) ? "" : ccPool.getDescription());
            result.add(oneRow);
        }
        handlerCtx.setOutputValue("result", result);
    }

    private static List getJdbcDriverClassNames(String dbVendor, String resType, boolean introspect) {
        String endpoint = (String)GuiUtil.getSessionValue("REST_URL");
        endpoint = endpoint + "/resources/get-jdbc-driver-class-names.json";
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("dbVendor", dbVendor);
        attrs.put("restype", resType);
        attrs.put("introspect", Boolean.valueOf(introspect).toString());
        List<Object> jdbcClassNames = new ArrayList();
        try {
            Map responseMap = RestApiHandlers.restRequest(endpoint, attrs, "GET", null);
            jdbcClassNames = RestUtilHandlers.getListFromMapKey((List)((Map)responseMap.get("data")).get("result"));
        }
        catch (Exception ex) {
            GuiUtil.getLogger().severe("Error in getJdbcDriverClassNames ; \nendpoint = " + endpoint + "attrs=" + attrs + "method=GET");
        }
        return jdbcClassNames;
    }

    private static List getDatabaseVendorNames() {
        String endpoint = (String)GuiUtil.getSessionValue("REST_URL");
        endpoint = endpoint + "/resources/get-database-vendor-names.json";
        List<Object> vendorList = new ArrayList();
        try {
            Map responseMap = RestApiHandlers.restRequest(endpoint, null, "GET", null);
            vendorList = RestUtilHandlers.getListFromMapKey((List)((Map)responseMap.get("data")).get("result"));
        }
        catch (Exception ex) {
            GuiUtil.getLogger().severe("Error in getDatabaseVendorNames ; \nendpoint = " + endpoint + "attrs=null method=GET");
        }
        return vendorList;
    }

    private static Map<String, String> getConnectionDefinitionPropertiesAndDefaults(String datasourceClassName, String resType) {
        String endpoint = (String)GuiUtil.getSessionValue("REST_URL");
        endpoint = endpoint + "/resources/get-connection-definition-properties-and-defaults.json";
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("connectionDefinitionClass", datasourceClassName);
        attrs.put("restype", resType);
        HashMap<String, String> connDefProps = new HashMap();
        try {
            Map responseMap = RestApiHandlers.restRequest(endpoint, attrs, "GET", null);
            connDefProps = RestUtilHandlers.getMapFromMapKey((List)((Map)responseMap.get("data")).get("result"));
        }
        catch (Exception ex) {
            GuiUtil.getLogger().severe("Error in getJdbcDriverClassNames ; \nendpoint = " + endpoint + "attrs=" + attrs + "method=GET");
        }
        return connDefProps;
    }

    static {
        dbVendorList = JdbcTempHandler.getDatabaseVendorNames();
        dbVendorList.add(0, "");
        resTypeList.add("");
        resTypeList.add(DATA_SOURCE);
        resTypeList.add(XADATA_SOURCE);
        resTypeList.add(CCDATA_SOURCE);
        resTypeList.add(DRIVER);
    }
}

