/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.glassfish.admingui.common.handlers.RestApiHandlers;
import org.glassfish.admingui.common.handlers.RestUtilHandlers;
import org.glassfish.admingui.common.util.GuiUtil;

public class TargetUtil {
    public static boolean isCluster(String name) {
        if (GuiUtil.isEmpty(name)) {
            return false;
        }
        return TargetUtil.getClusters().contains(name);
    }

    public static List getStandaloneInstances() {
        List<Object> result = new ArrayList();
        String endpoint = GuiUtil.getSessionValue("REST_URL") + "/list-instances";
        HashMap<String, Object> attrsMap = new HashMap<String, Object>();
        attrsMap.put("standaloneonly", "true");
        try {
            Map responseMap = RestApiHandlers.restRequest(endpoint, attrsMap, "get", null);
            Map dataMap = (Map)responseMap.get("data");
            Map extraProps = (Map)dataMap.get("extraProperties");
            List props = (List)extraProps.get("instanceList");
            if (props == null) {
                return result;
            }
            result = RestUtilHandlers.getListFromMapKey(props, new String[0]);
        }
        catch (Exception ex) {
            GuiUtil.getLogger().severe("Error in getStandaloneInstances ; \nendpoint = " + endpoint + ", attrsMap=" + attrsMap);
        }
        return result;
    }

    public static List getClusters() {
        ArrayList<String> clusters = new ArrayList<String>();
        try {
            clusters.addAll(RestApiHandlers.getChildMap(GuiUtil.getSessionValue("REST_URL") + "/clusters/cluster").keySet());
        }
        catch (Exception ex) {
            GuiUtil.getLogger().severe("Error in getClusters;");
            ex.printStackTrace();
        }
        return clusters;
    }
}

