/*
 * Decompiled with CFR 0.152.
 */
package jmaki.runtime;

import java.io.IOException;
import java.io.Writer;

public class AjaxWriter {
    private Writer out;
    private boolean useCDATA = false;

    public AjaxWriter(Writer out) {
        this.out = out;
    }

    public AjaxWriter(Writer out, boolean useCDATA) {
        this.out = out;
        this.useCDATA = useCDATA;
    }

    public void writeScript(String script) throws IOException {
        if (this.useCDATA) {
            this.out.write("<script type=\"text/javascript\"> //<![CDATA[\r\n" + script + "\r\n//]]>\r\n</script>\r\n");
        } else {
            this.out.write("<script type=\"text/javascript\">" + script + "</script>\r\n");
        }
    }

    public void writeLib(String lib) throws IOException {
        this.out.write("<script type=\"text/javascript\" src=\"" + lib + "\"></script>\r\n");
    }

    public void writeStyle(String style) throws IOException {
        this.out.write("<link rel=\"stylesheet\" type=\"text/css\" href=\"" + style + "\" />\r\n");
    }

    public void writeInlineStyle(String style) throws IOException {
        this.out.write("<style type=\"text/css\">" + style + "</style>\r\n");
    }

    public void write(String string) throws IOException {
        this.out.write(string);
    }

    public void writeComment(String comment) throws IOException {
        this.out.write("<!-- " + comment + "-->\r\n");
    }

    public Writer getWrapped() {
        return this.out;
    }
}

