/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.handlers;

import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.glassfish.admingui.common.handlers.RestApiHandlers;
import org.glassfish.admingui.common.util.DeployUtil;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.TargetUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationHandlers {
    public static void getDeployedAppsInfo(HandlerContext handlerCtx) {
        String serverName = (String)handlerCtx.getInputValue("serverName");
        Map appPropsMap = (Map)handlerCtx.getInputValue("appPropsMap");
        String filterValue = (String)handlerCtx.getInputValue("filterValue");
        TreeSet<String> filters = new TreeSet<String>();
        filters.add("");
        if (GuiUtil.isEmpty(filterValue)) {
            filterValue = null;
        }
        ArrayList result = new ArrayList();
        if (appPropsMap != null) {
            for (String oneAppName : appPropsMap.keySet()) {
                try {
                    String engines = (String)appPropsMap.get(oneAppName);
                    if (GuiUtil.isEmpty(engines)) continue;
                    HashMap<String, Object> oneRow = new HashMap<String, Object>();
                    oneRow.put("name", oneAppName);
                    oneRow.put("encodedName", URLEncoder.encode(oneAppName, "UTF-8"));
                    oneRow.put("selected", false);
                    oneRow.put("enableURL", DeployUtil.getTargetEnableInfo(oneAppName, true, true));
                    oneRow.put("sniffers", engines);
                    List sniffersList = GuiUtil.parseStringList(engines, ",");
                    oneRow.put("sniffersList", sniffersList);
                    for (int ix = 0; ix < sniffersList.size(); ++ix) {
                        filters.add((String)sniffersList.get(ix));
                    }
                    if (filterValue != null && !sniffersList.contains(filterValue)) continue;
                    ApplicationHandlers.getLaunchInfo(serverName, oneAppName, oneRow);
                    result.add(oneRow);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        handlerCtx.setOutputValue("result", result);
        handlerCtx.setOutputValue("filters", new ArrayList(filters));
    }

    public static void getLifecyclesInfo(HandlerContext handlerCtx) {
        List children = (List)handlerCtx.getInputValue("children");
        ArrayList result = new ArrayList();
        String prefix = GuiUtil.getSessionValue("REST_URL") + "/applications/application/";
        if (children == null) {
            handlerCtx.setOutputValue("result", result);
            return;
        }
        for (Map oneChild : children) {
            HashMap<String, Object> oneRow = new HashMap<String, Object>();
            try {
                String name = (String)oneChild.get("message");
                String encodedName = URLEncoder.encode(name, "UTF-8");
                oneRow.put("name", name);
                oneRow.put("encodedName", encodedName);
                oneRow.put("selected", false);
                oneRow.put("loadOrder", ApplicationHandlers.getPropValue(prefix + encodedName, "load-order", handlerCtx));
                oneRow.put("enableURL", DeployUtil.getTargetEnableInfo(name, true, true));
                result.add(oneRow);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        handlerCtx.setOutputValue("result", result);
    }

    private static String getPropValue(String endpoint, String propName, HandlerContext handlerCtx) {
        Map<String, Object> responseMap = RestApiHandlers.restRequest(endpoint + "/property.json", null, "GET", handlerCtx);
        Map extraPropertiesMap = (Map)((Map)responseMap.get("data")).get("extraProperties");
        if (extraPropertiesMap != null) {
            List props = (List)extraPropertiesMap.get("properties");
            for (Map oneProp : props) {
                if (!oneProp.get("name").equals(propName)) continue;
                return (String)oneProp.get("value");
            }
        }
        return "";
    }

    private static void getLaunchInfo(String serverName, String appName, Map oneRow) {
        Map entity;
        Map extraProperties;
        String endpoint = GuiUtil.getSessionValue("REST_URL") + "/applications/application/" + appName + ".json";
        Map<String, Object> map = RestApiHandlers.restRequest(endpoint, null, "GET", null);
        Map data = (Map)map.get("data");
        String contextRoot = "";
        boolean enabled = false;
        if (data != null && (extraProperties = (Map)data.get("extraProperties")) != null && (entity = (Map)extraProperties.get("entity")) != null) {
            contextRoot = (String)entity.get("contextRoot");
            enabled = Boolean.parseBoolean((String)entity.get("enabled"));
        }
        oneRow.put("contextRoot", contextRoot == null ? "" : contextRoot);
        oneRow.put("hasLaunch", false);
        if (!enabled || GuiUtil.isEmpty(contextRoot)) {
            return;
        }
        List targetList = DeployUtil.getApplicationTarget(appName, "application-ref");
        for (String target : targetList) {
            String virtualServers = ApplicationHandlers.getVirtualServers(target, appName);
            Map result = ApplicationHandlers.getListener(virtualServers, "server-config");
            String vs = (String)result.get("vs");
            if (vs.equals("server")) {
                vs = serverName;
            }
            String port = (String)result.get("port");
            String protocol = (String)result.get("protocol");
            oneRow.put("hasLaunch", true);
            oneRow.put("launchLink", protocol + "://" + vs + ":" + port + ApplicationHandlers.calContextRoot(contextRoot));
        }
    }

    private static String getVirtualServers(String target, String appName) {
        List clusters = TargetUtil.getClusters();
        List standalone = TargetUtil.getStandaloneInstances();
        standalone.add("server");
        String ep = (String)GuiUtil.getSessionValue("REST_URL");
        ep = clusters.contains(target) ? ep + "/clusters/cluster/" + target + "/application-ref/" + appName : ep + "/servers/server/" + target + "/application-ref/" + appName;
        String virtualServers = (String)RestApiHandlers.getAttributesMap(ep).get("virtualServers");
        return virtualServers;
    }

    private static Map getListener(String vsIds, String configName) {
        return ApplicationHandlers.getOneVsWithNetworkListener(GuiUtil.parseStringList(vsIds, ","), configName);
    }

    private static Map getOneVsWithNetworkListener(List<String> vsList, String configName) {
        HashMap result = new HashMap();
        if (vsList == null || vsList.size() == 0) {
            return null;
        }
        if (vsList.contains("server")) {
            vsList.remove("server");
            vsList.add(0, "server");
        }
        boolean found = false;
        String ep = (String)GuiUtil.getSessionValue("REST_URL");
        ep = ep + "/configs/config/" + configName + "/http-service/virtual-server";
        Map<Object, Object> vsInConfig = new HashMap();
        try {
            vsInConfig = RestApiHandlers.getChildMap(ep);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        for (String vsName : vsList) {
            String listener;
            Object vs;
            if (vsName.equals("admin-listener") || (vs = vsInConfig.get(vsName)) == null || GuiUtil.isEmpty(listener = (String)RestApiHandlers.getAttributesMap(ep = (String)GuiUtil.getSessionValue("REST_URL") + "/configs/config/" + configName + "/http-service/virtual-server/" + vsName).get("networkListeners"))) continue;
            List hpList = GuiUtil.parseStringList(listener, ",");
            for (String one : hpList) {
                ep = (String)GuiUtil.getSessionValue("REST_URL") + "/configs/config/server-config/network-config/network-listeners/network-listener/" + one;
                Map nlAttributes = RestApiHandlers.getAttributesMap(ep);
                if ("false".equals((String)nlAttributes.get("enabled"))) continue;
                String protocol = (String)nlAttributes.get("protocol");
                ep = (String)GuiUtil.getSessionValue("REST_URL") + "/configs/config/" + configName + "/network-config/protocols/protocol/" + protocol;
                String security = (String)RestApiHandlers.getAttributesMap(ep).get("securityEnabled");
                result.put("port", nlAttributes.get("port"));
                result.put("vs", vsName);
                if ("true".equals(security)) {
                    result.put("protocol", "https");
                    found = true;
                    continue;
                }
                result.put("protocol", "http");
                return result;
            }
        }
        return found ? result : null;
    }

    public static void getTargetEndpoint(HandlerContext handlerCtx) {
        handlerCtx.setOutputValue("endpoint", (Object)TargetUtil.getTargetEndpoint((String)handlerCtx.getInputValue("target")));
    }

    public static void getConfigName(HandlerContext handlerCtx) {
        String endpoint = TargetUtil.getTargetEndpoint((String)handlerCtx.getInputValue("target"));
        handlerCtx.setOutputValue("configName", RestApiHandlers.getAttributesMap(endpoint).get("configRef"));
    }

    public static void getApplicationTarget(HandlerContext handlerCtx) {
        String appName = (String)handlerCtx.getInputValue("appName");
        handlerCtx.setOutputValue("result", (Object)DeployUtil.getApplicationTarget(appName, "application-ref"));
    }

    public static void changeTargetStatus(HandlerContext handlerCtx) {
        String Enabled = (String)handlerCtx.getInputValue("Enabled");
        List selectedRows = (List)handlerCtx.getInputValue("selectedRows");
        boolean forLB = (Boolean)handlerCtx.getInputValue("forLB");
        String prefix = (String)GuiUtil.getSessionValue("REST_URL");
        for (Map oneRow : selectedRows) {
            HashMap<String, Object> attrs = new HashMap<String, Object>();
            String endpoint = (String)oneRow.get("endpoint");
            if (forLB) {
                attrs.put("lbEnabled", Enabled);
                RestApiHandlers.restRequest(prefix + endpoint, attrs, "post", handlerCtx);
                continue;
            }
            DeployUtil.enableApp((String)oneRow.get("name"), (String)oneRow.get("targetName"), handlerCtx, Boolean.parseBoolean(Enabled));
        }
    }

    public static void changeAppTargets(HandlerContext handlerCtx) {
        String endpoint;
        String appName = (String)handlerCtx.getInputValue("appName");
        String[] selTargets = (String[])handlerCtx.getInputValue("targets");
        List<String> selectedTargets = Arrays.asList(selTargets);
        List clusters = TargetUtil.getClusters();
        List standalone = TargetUtil.getStandaloneInstances();
        String clusterEndpoint = GuiUtil.getSessionValue("REST_URL") + "/clusters/cluster/";
        String serverEndpoint = GuiUtil.getSessionValue("REST_URL") + "/servers/server/";
        standalone.add("server");
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("id", appName);
        List associatedTargets = DeployUtil.getApplicationTarget(appName, "application-ref");
        for (String newTarget : selectedTargets) {
            if (associatedTargets.contains(newTarget)) {
                associatedTargets.remove(newTarget);
                continue;
            }
            endpoint = clusters.contains(newTarget) ? clusterEndpoint + newTarget + "/application-ref" : serverEndpoint + newTarget + "/application-ref";
            attrs.put("target", newTarget);
            RestApiHandlers.restRequest(endpoint, attrs, "post", handlerCtx);
        }
        for (String oTarget : associatedTargets) {
            endpoint = clusters.contains(oTarget) ? clusterEndpoint + oTarget : serverEndpoint + oTarget;
            HashMap<String, Object> attrMap = new HashMap<String, Object>();
            attrMap.put("target", oTarget);
            RestApiHandlers.restRequest(endpoint + "/application-ref/" + appName, attrMap, "delete", handlerCtx);
        }
    }

    public static void reloadApplication(HandlerContext handlerCtx) {
        List associatedTargets;
        String appName = (String)handlerCtx.getInputValue("appName");
        if (DeployUtil.reloadApplication(appName, associatedTargets = DeployUtil.getApplicationTarget(appName, "application-ref"), handlerCtx)) {
            GuiUtil.prepareAlert("success", GuiUtil.getMessage("org.glassfish.web.admingui.Strings", "restart.successPE"), null);
        }
    }

    public static void getTargetEnableInfo(HandlerContext handlerCtx) {
        String appName = (String)handlerCtx.getInputValue("appName");
        Boolean isApp = (Boolean)handlerCtx.getInputValue("isApp");
        if (isApp == null) {
            isApp = true;
        }
        handlerCtx.setOutputValue("status", (Object)DeployUtil.getTargetEnableInfo(appName, false, isApp));
    }

    public static void getVsForDeployment(HandlerContext handlerCtx) {
        String targetConfig = (String)handlerCtx.getInputValue("targetConfig");
        String endpoint = GuiUtil.getSessionValue("REST_URL") + "/configs/config/" + targetConfig + "/http-service/virtual-server";
        ArrayList<Object> vsList = new ArrayList();
        try {
            vsList = new ArrayList<String>(RestApiHandlers.getChildMap(endpoint).keySet());
            vsList.remove("__asadmin");
        }
        catch (Exception ex) {
            // empty catch block
        }
        handlerCtx.setOutputValue("result", vsList);
    }

    public static void getTargetListInfo(HandlerContext handlerCtx) {
        String appName = (String)handlerCtx.getInputValue("appName");
        String prefix = (String)GuiUtil.getSessionValue("REST_URL");
        List clusters = TargetUtil.getClusters();
        List standalone = TargetUtil.getStandaloneInstances();
        standalone.add("server");
        List targetList = DeployUtil.getApplicationTarget(appName, "application-ref");
        ArrayList result = new ArrayList();
        Map attrs = null;
        String endpoint = "";
        for (String oneTarget : targetList) {
            HashMap<String, Object> oneRow = new HashMap<String, Object>();
            if (clusters.contains(oneTarget)) {
                endpoint = prefix + "/clusters/cluster/" + oneTarget + "/application-ref/" + appName;
                attrs = RestApiHandlers.getAttributesMap(prefix + endpoint);
            } else {
                endpoint = prefix + "/servers/server/" + oneTarget + "/application-ref/" + appName;
                attrs = RestApiHandlers.getAttributesMap(endpoint);
            }
            oneRow.put("name", appName);
            oneRow.put("selected", false);
            oneRow.put("endpoint", endpoint);
            oneRow.put("targetName", oneTarget);
            oneRow.put("enabled", attrs.get("enabled"));
            oneRow.put("lbEnabled", attrs.get("lbEnabled"));
            result.add(oneRow);
        }
        handlerCtx.setOutputValue("result", result);
    }

    public static void getSingleTargetAppsInfo(HandlerContext handlerCtx) {
        String appRefEndpoint = (String)handlerCtx.getInputValue("appRefEndpoint");
        String target = (String)handlerCtx.getInputValue("target");
        Map appPropsMap = (Map)handlerCtx.getInputValue("appPropsMap");
        String filterValue = (String)handlerCtx.getInputValue("filterValue");
        TreeSet<String> filters = new TreeSet<String>();
        filters.add("");
        if (GuiUtil.isEmpty(filterValue)) {
            filterValue = null;
        }
        ArrayList result = new ArrayList();
        String prefix = (String)GuiUtil.getSessionValue("REST_URL");
        if (appPropsMap != null) {
            for (String oneAppName : appPropsMap.keySet()) {
                try {
                    String engines = (String)appPropsMap.get(oneAppName);
                    HashMap<String, Object> oneRow = new HashMap<String, Object>();
                    oneRow.put("name", oneAppName);
                    String encodedName = URLEncoder.encode(oneAppName, "UTF-8");
                    oneRow.put("targetName", target);
                    oneRow.put("selected", false);
                    Map appRefAttrsMap = RestApiHandlers.getAttributesMap(prefix + appRefEndpoint + encodedName);
                    String image = appRefAttrsMap.get("enabled").equals("true") ? "/resource/images/enabled.png" : "/resource/images/disabled.png";
                    oneRow.put("enabled", image);
                    image = appRefAttrsMap.get("lbEnabled").equals("true") ? "/resource/images/enabled.png" : "/resource/images/disabled.png";
                    oneRow.put("lbEnabled", image);
                    oneRow.put("endpoint", appRefEndpoint + encodedName);
                    oneRow.put("sniffers", engines);
                    List sniffersList = GuiUtil.parseStringList(engines, ",");
                    oneRow.put("sniffersList", sniffersList);
                    for (int ix = 0; ix < sniffersList.size(); ++ix) {
                        filters.add((String)sniffersList.get(ix));
                    }
                    if (filterValue != null && !sniffersList.contains(filterValue)) continue;
                    result.add(oneRow);
                }
                catch (Exception ex) {}
            }
        }
        handlerCtx.setOutputValue("result", result);
        handlerCtx.setOutputValue("filters", new ArrayList(filters));
    }

    public void getTargetURLList(HandlerContext handlerCtx) {
        String id = (String)handlerCtx.getInputValue("AppID");
        String contextRoot = (String)handlerCtx.getInputValue("contextRoot");
        String ctxRoot = ApplicationHandlers.calContextRoot(contextRoot);
        List urls = ApplicationHandlers.getLaunchInfo2(id);
        Iterator it = urls.iterator();
        String url = null;
        ArrayList list = new ArrayList();
        while (it.hasNext()) {
            url = (String)it.next();
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("url", url + ctxRoot);
            list.add(m);
        }
        handlerCtx.setOutputValue("URLList", list);
    }

    public static void getApplicationType(HandlerContext handlerCtx) {
        Map snifferMap = (Map)handlerCtx.getInputValue("snifferMap");
        String appType = "ejb";
        if (!GuiUtil.isEmpty((String)snifferMap.get("web"))) {
            appType = "war";
        } else if (!GuiUtil.isEmpty((String)snifferMap.get("connector"))) {
            appType = "rar";
        } else if (!GuiUtil.isEmpty((String)snifferMap.get("appclient"))) {
            appType = "appclient";
        }
        handlerCtx.setOutputValue("appType", (Object)appType);
    }

    private static String calContextRoot(String contextRoot) {
        String ctxRoot = "";
        ctxRoot = contextRoot == null || contextRoot.equals("") || contextRoot.equals("/") ? "/" : (contextRoot.startsWith("/") ? contextRoot : "/" + contextRoot);
        return ctxRoot;
    }

    private static List getLaunchInfo2(String appName) {
        List targetList = DeployUtil.getApplicationTarget(appName, "application-ref");
        ArrayList URLs = new ArrayList();
        for (String target : targetList) {
            String virtualServers = ApplicationHandlers.getVirtualServers(target, appName);
            URLs.addAll(ApplicationHandlers.getURLs(GuiUtil.parseStringList(virtualServers, ","), "server-config"));
        }
        return URLs;
    }

    private static List getURLs(List<String> vsList, String configName) {
        ArrayList<String> URLs = new ArrayList<String>();
        HashMap result = new HashMap();
        if (vsList == null || vsList.size() == 0) {
            return null;
        }
        if (vsList.contains("server")) {
            vsList.remove("server");
            vsList.add(0, "server");
        }
        boolean found = false;
        String ep = (String)GuiUtil.getSessionValue("REST_URL");
        ep = ep + "/configs/config/" + configName + "/http-service/virtual-server";
        Map<Object, Object> vsInConfig = new HashMap();
        try {
            vsInConfig = RestApiHandlers.getChildMap(ep);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        for (String vsName : vsList) {
            String listener;
            Object vs;
            if (vsName.equals("admin-listener") || (vs = vsInConfig.get(vsName)) == null || GuiUtil.isEmpty(listener = (String)RestApiHandlers.getAttributesMap(ep = (String)GuiUtil.getSessionValue("REST_URL") + "/configs/config/" + configName + "/http-service/virtual-server/" + vsName).get("networkListeners"))) continue;
            List hpList = GuiUtil.parseStringList(listener, ",");
            for (String one : hpList) {
                ep = (String)GuiUtil.getSessionValue("REST_URL") + "/configs/config/server-config/network-config/network-listeners/network-listener/" + one;
                Map nlAttributes = RestApiHandlers.getAttributesMap(ep);
                if ("false".equals((String)nlAttributes.get("enabled"))) continue;
                ep = (String)GuiUtil.getSessionValue("REST_URL") + "/configs/config/" + configName + "/network-config/protocols/protocol/" + (String)nlAttributes.get("protocol");
                String security = (String)RestApiHandlers.getAttributesMap(ep).get("securityEnabled");
                String protocol = "http";
                if ("true".equals(security)) {
                    protocol = "https";
                }
                URLs.add(protocol + "://" + "localhost" + ":" + (String)nlAttributes.get("port"));
            }
        }
        return URLs;
    }
}

